/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;

public final class ContributedProcessorDescriptor {
    private final IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private Boolean fStatus;
    private boolean fLastResult;
    private final Set fHandledMarkerTypes;
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String HANDLED_MARKER_TYPES = "handledMarkerTypes";
    private static final String MARKER_TYPE = "markerType";

    public ContributedProcessorDescriptor(IConfigurationElement element, boolean testMarkerTypes) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
        this.fHandledMarkerTypes = testMarkerTypes ? this.getHandledMarkerTypes(element) : null;
    }

    private Set getHandledMarkerTypes(IConfigurationElement element) {
        HashSet<String> map = new HashSet<String>(7);
        IConfigurationElement[] children = element.getChildren(HANDLED_MARKER_TYPES);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement[] types = children[i].getChildren(MARKER_TYPE);
            int k = 0;
            while (k < types.length) {
                String attribute = types[k].getAttribute(ID);
                if (attribute != null) {
                    map.add(attribute);
                }
                ++k;
            }
            ++i;
        }
        if (map.isEmpty()) {
            map.add("org.rubypeople.rdt.core.problem");
            map.add("org.rubypeople.rdt.core.buildpath_problem");
            map.add("org.rubypeople.rdt.core.task");
        }
        return map;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            String id = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, "Only one < enablement > element allowed. Disabling " + id);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    private boolean matches(IRubyScript cunit) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length == 1) {
            try {
                ExpressionConverter parser = ExpressionConverter.getDefault();
                Expression expression = parser.perform(children[0]);
                EvaluationContext evalContext = new EvaluationContext(null, (Object)cunit);
                evalContext.addVariable("rubyScript", (Object)cunit);
                IRubyProject javaProject = cunit.getRubyProject();
                String[] natures = javaProject.getProject().getDescription().getNatureIds();
                evalContext.addVariable("projectNatures", Arrays.asList(natures));
                this.fLastResult = expression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
                return this.fLastResult;
            }
            catch (CoreException e) {
                RubyPlugin.log(e);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public Object getProcessor(IRubyScript cunit) throws CoreException {
        if (this.matches(cunit)) {
            if (this.fProcessorInstance == null) {
                this.fProcessorInstance = this.fConfigurationElement.createExecutableExtension(CLASS);
            }
            return this.fProcessorInstance;
        }
        return null;
    }

    public boolean canHandleMarkerType(String markerType) {
        return this.fHandledMarkerTypes == null || this.fHandledMarkerTypes.contains(markerType);
    }
}

