/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.hyperlinks;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.ui.text.hyperlinks.IHyperlinkProvider;

public class RubyHyperLinkDetector
implements IHyperlinkDetector {
    public static final String RDT_UI_NAMESPACE = "org.rubypeople.rdt.ui";
    public static final String RDT_UI_HYPERLINKPROVIDER = "hyperlinkProvider";
    private List fExtensions;
    private final IEditorInput fEditorInput;

    public RubyHyperLinkDetector(IEditorInput editorInput) {
        this.fEditorInput = editorInput;
    }

    private IExtensionPoint[] getExtensionPoints() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        return reg.getExtensionPoints(RDT_UI_NAMESPACE);
    }

    private List initExtensions() {
        if (this.fExtensions != null) {
            return this.fExtensions;
        }
        this.fExtensions = new ArrayList();
        IExtensionPoint[] points = this.getExtensionPoints();
        IExtensionPoint point = this.getExtensionPoint(points);
        if (point != null) {
            IExtension[] exts = point.getExtensions();
            int i = 0;
            while (i < exts.length) {
                IConfigurationElement[] elem = exts[i].getConfigurationElements();
                elem[0].getAttributeNames();
                try {
                    Object tempProv = elem[0].createExecutableExtension("class");
                    if (tempProv instanceof IHyperlinkProvider) {
                        IHyperlinkProvider prov = (IHyperlinkProvider)tempProv;
                        this.fExtensions.add(prov);
                    }
                }
                catch (Exception e) {
                    RubyPlugin.log(e);
                }
                ++i;
            }
        }
        return this.fExtensions;
    }

    private IExtensionPoint getExtensionPoint(IExtensionPoint[] points) {
        int i = 0;
        while (i < points.length) {
            IExtensionPoint currentPoint = points[i];
            String uniqueIdentifier = currentPoint.getUniqueIdentifier();
            if (uniqueIdentifier.endsWith(RDT_UI_HYPERLINKPROVIDER)) {
                return currentPoint;
            }
            ++i;
        }
        return null;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        List extensions = this.initExtensions();
        if (extensions.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < extensions.size()) {
            IHyperlinkProvider currentProvider = (IHyperlinkProvider)extensions.get(i);
            IHyperlink link = currentProvider.getHyperlink(this.fEditorInput, textViewer, null, region, canShowMultipleHyperlinks);
            if (link != null) {
                return new IHyperlink[]{link};
            }
            ++i;
        }
        return null;
    }
}

