/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.rubypeople.rdt.core.CompletionProposal;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyCompletionProposal;
import org.rubypeople.rdt.internal.ui.text.ruby.ProposalInfo;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyContentAssistInvocationContext;

public class LazyRubyCompletionProposal
extends AbstractRubyCompletionProposal {
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String COMMA = ",";
    protected static final String SPACE = " ";
    private boolean fDisplayStringComputed;
    private boolean fReplacementStringComputed;
    private boolean fReplacementOffsetComputed;
    private boolean fReplacementLengthComputed;
    private boolean fCursorPositionComputed;
    private boolean fImageComputed;
    private boolean fContextInformationComputed;
    private boolean fProposalInfoComputed;
    private boolean fTriggerCharactersComputed;
    private boolean fSortStringComputed;
    private boolean fRelevanceComputed;
    protected final CompletionProposal fProposal;
    protected final RubyContentAssistInvocationContext fInvocationContext;

    public LazyRubyCompletionProposal(CompletionProposal proposal, RubyContentAssistInvocationContext context) {
        Assert.isNotNull((Object)proposal);
        Assert.isNotNull((Object)context);
        this.fInvocationContext = context;
        this.fProposal = proposal;
    }

    public final char[] getTriggerCharacters() {
        if (!this.fTriggerCharactersComputed) {
            this.setTriggerCharacters(this.computeTriggerCharacters());
        }
        return super.getTriggerCharacters();
    }

    protected char[] computeTriggerCharacters() {
        return new char[0];
    }

    public final void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharactersComputed = true;
        super.setTriggerCharacters(triggerCharacters);
    }

    public final void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfoComputed = true;
        super.setProposalInfo(proposalInfo);
    }

    protected final ProposalInfo getProposalInfo() {
        if (!this.fProposalInfoComputed) {
            this.setProposalInfo(this.computeProposalInfo());
        }
        return super.getProposalInfo();
    }

    protected ProposalInfo computeProposalInfo() {
        return null;
    }

    public final void setCursorPosition(int cursorPosition) {
        this.fCursorPositionComputed = true;
        super.setCursorPosition(cursorPosition);
    }

    protected final int getCursorPosition() {
        if (!this.fCursorPositionComputed) {
            this.setCursorPosition(this.computeCursorPosition());
        }
        return super.getCursorPosition();
    }

    protected int computeCursorPosition() {
        return this.getReplacementString().length();
    }

    public final IContextInformation getContextInformation() {
        if (!this.fContextInformationComputed) {
            this.setContextInformation(this.computeContextInformation());
        }
        return super.getContextInformation();
    }

    protected IContextInformation computeContextInformation() {
        return null;
    }

    public final void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformationComputed = true;
        super.setContextInformation(contextInformation);
    }

    public final String getDisplayString() {
        if (!this.fDisplayStringComputed) {
            this.setDisplayString(this.computeDisplayString());
        }
        return super.getDisplayString();
    }

    protected final void setDisplayString(String string) {
        this.fDisplayStringComputed = true;
        super.setDisplayString(string);
    }

    protected String computeDisplayString() {
        return this.fInvocationContext.getLabelProvider().createLabel(this.fProposal);
    }

    public final String getAdditionalProposalInfo() {
        return super.getAdditionalProposalInfo();
    }

    public final int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public final int getReplacementOffset() {
        if (!this.fReplacementOffsetComputed) {
            this.setReplacementOffset(this.fProposal.getReplaceStart());
        }
        return super.getReplacementOffset();
    }

    public final void setReplacementOffset(int replacementOffset) {
        this.fReplacementOffsetComputed = true;
        super.setReplacementOffset(replacementOffset);
    }

    public final int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public final int getReplacementLength() {
        if (!this.fReplacementLengthComputed) {
            this.setReplacementLength(this.fProposal.getReplaceEnd() - this.fProposal.getReplaceStart());
        }
        return super.getReplacementLength();
    }

    public final void setReplacementLength(int replacementLength) {
        this.fReplacementLengthComputed = true;
        super.setReplacementLength(replacementLength);
    }

    public final String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            this.setReplacementString(this.computeReplacementString());
        }
        return super.getReplacementString();
    }

    protected String computeReplacementString() {
        return String.valueOf(this.fProposal.getCompletion());
    }

    public final void setReplacementString(String replacementString) {
        this.fReplacementStringComputed = true;
        super.setReplacementString(replacementString);
    }

    public final Image getImage() {
        if (!this.fImageComputed) {
            this.setImage(this.computeImage());
        }
        return super.getImage();
    }

    protected Image computeImage() {
        return RubyPlugin.getImageDescriptorRegistry().get(this.fInvocationContext.getLabelProvider().createImageDescriptor(this.fProposal));
    }

    public final void setImage(Image image) {
        this.fImageComputed = true;
        super.setImage(image);
    }

    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        if (this.fProposal.getKind() == 12) {
            return this.isPrefix(prefix, this.getDisplayString());
        }
        return false;
    }

    public final int getRelevance() {
        if (!this.fRelevanceComputed) {
            this.setRelevance(this.computeRelevance());
        }
        return super.getRelevance();
    }

    public final void setRelevance(int relevance) {
        this.fRelevanceComputed = true;
        super.setRelevance(relevance);
    }

    protected int computeRelevance() {
        int baseRelevance = this.fProposal.getRelevance() * 16;
        switch (this.fProposal.getKind()) {
            case 3: {
                return baseRelevance + 2;
            }
            case 9: {
                return baseRelevance + 3;
            }
            case 6: 
            case 7: 
            case 12: {
                return baseRelevance + 4;
            }
            case 11: {
                return baseRelevance + 4;
            }
            case 5: 
            case 10: {
                return baseRelevance + 6;
            }
        }
        return baseRelevance;
    }

    public final String getSortString() {
        if (!this.fSortStringComputed) {
            this.setSortString(this.computeSortString());
        }
        return super.getSortString();
    }

    protected final void setSortString(String string) {
        this.fSortStringComputed = true;
        super.setSortString(string);
    }

    protected String computeSortString() {
        return this.getDisplayString();
    }
}

