/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.ProposalSorterHandle;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyTextMessages;

public final class ProposalSorterRegistry {
    private static final String EXTENSION_POINT = "rubyCompletionProposalSorters";
    private static final String DEFAULT_ID = "org.rubypeople.rdt.ui.RelevanceSorter";
    private static ProposalSorterRegistry fInstance;
    private final IPreferenceStore fPreferenceStore;
    private final String fKey;
    private Map fSorters = null;
    private ProposalSorterHandle fDefaultSorter;

    public static synchronized ProposalSorterRegistry getDefault() {
        if (fInstance == null) {
            fInstance = new ProposalSorterRegistry(RubyPlugin.getDefault().getPreferenceStore(), "content_assist_sorter");
        }
        return fInstance;
    }

    private ProposalSorterRegistry(IPreferenceStore preferenceStore, String key) {
        Assert.isTrue((preferenceStore != null ? 1 : 0) != 0);
        Assert.isTrue((key != null ? 1 : 0) != 0);
        this.fPreferenceStore = preferenceStore;
        this.fKey = key;
    }

    public ProposalSorterHandle getCurrentSorter() {
        this.ensureSortersRead();
        String id = this.fPreferenceStore.getString(this.fKey);
        ProposalSorterHandle sorter = (ProposalSorterHandle)this.fSorters.get(id);
        return sorter != null ? sorter : this.fDefaultSorter;
    }

    private synchronized void ensureSortersRead() {
        if (this.fSorters != null) {
            return;
        }
        LinkedHashMap<String, ProposalSorterHandle> sorters = new LinkedHashMap<String, ProposalSorterHandle>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList elements = new ArrayList(Arrays.asList(registry.getConfigurationElementsFor(RubyPlugin.getPluginId(), EXTENSION_POINT)));
        for (IConfigurationElement element : elements) {
            try {
                ProposalSorterHandle handle = new ProposalSorterHandle(element);
                String id = handle.getId();
                sorters.put(id, handle);
                if (!DEFAULT_ID.equals(id)) continue;
                this.fDefaultSorter = handle;
            }
            catch (InvalidRegistryObjectException x) {
                Object[] args = new Object[]{element.toString()};
                String message = Messages.format(RubyTextMessages.CompletionProposalComputerRegistry_invalid_message, args);
                Status status = new Status(2, RubyPlugin.getPluginId(), 0, message, (Throwable)x);
                this.informUser((IStatus)status);
            }
        }
        this.fSorters = sorters;
    }

    private void informUser(IStatus status) {
        RubyPlugin.log(status);
        String title = RubyTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String message = status.getMessage();
        MessageDialog.openError((Shell)RubyPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    public ProposalSorterHandle[] getSorters() {
        this.ensureSortersRead();
        Collection sorters = this.fSorters.values();
        return sorters.toArray(new ProposalSorterHandle[sorters.size()]);
    }

    public void select(ProposalSorterHandle handle) {
        Assert.isTrue((handle != null ? 1 : 0) != 0);
        String id = handle.getId();
        this.fPreferenceStore.setValue(this.fKey, id);
    }
}

