/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.ruby.IProblemRequestorExtension;
import org.rubypeople.rdt.internal.ui.text.ruby.IRubyReconcilingListener;
import org.rubypeople.rdt.ui.IWorkingCopyManager;

public class RubyReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IRubyReconcilingListener fRubyReconcilingListener;
    private boolean fIsRubyReconcilingListener;

    public RubyReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = RubyPlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = RubyPlugin.getDefault().getRubyDocumentProvider();
        this.fIsRubyReconcilingListener = this.fEditor instanceof IRubyReconcilingListener;
        if (this.fIsRubyReconcilingListener) {
            this.fRubyReconcilingListener = (IRubyReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    private void reconcile(boolean initialReconcile) {
        final RootNode[] ast = new RootNode[1];
        final IRubyScript unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        try {
            if (unit != null) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() {
                        try {
                            IProblemRequestorExtension extension = RubyReconcilingStrategy.this.getProblemRequestorExtension();
                            if (extension != null) {
                                extension.setProgressMonitor(RubyReconcilingStrategy.this.fProgressMonitor);
                                extension.setIsActive(true);
                            }
                            try {
                                try {
                                    ast[0] = unit.reconcile(true, null, RubyReconcilingStrategy.this.fProgressMonitor);
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    Assert.isTrue((RubyReconcilingStrategy.this.fProgressMonitor == null || RubyReconcilingStrategy.this.fProgressMonitor.isCanceled() ? 1 : 0) != 0);
                                    ast[0] = null;
                                    if (extension != null) {
                                        extension.setProgressMonitor(null);
                                        extension.setIsActive(false);
                                    }
                                }
                            }
                            finally {
                                if (extension != null) {
                                    extension.setProgressMonitor(null);
                                    extension.setIsActive(false);
                                }
                            }
                        }
                        catch (RubyModelException ex) {
                            this.handleException(ex);
                        }
                    }

                    public void handleException(Throwable ex) {
                        Status status = new Status(4, "org.rubypeople.rdt.ui", 0, "Error in RDT Core during reconcile", ex);
                        RubyPlugin.getDefault().getLog().log((IStatus)status);
                    }
                });
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.fIsRubyReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fRubyReconcilingListener.reconciled(unit, ast[0], !this.fNotify, pm);
                }
            }
            finally {
                this.fNotify = true;
            }
            throw throwable;
        }
        try {
            if (this.fIsRubyReconcilingListener) {
                IProgressMonitor pm = this.fProgressMonitor;
                if (pm == null) {
                    pm = new NullProgressMonitor();
                }
                this.fRubyReconcilingListener.reconciled(unit, ast[0], !this.fNotify, pm);
            }
        }
        finally {
            this.fNotify = true;
        }
    }

    public void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile(true);
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsRubyReconcilingListener) {
            this.fRubyReconcilingListener.aboutToBeReconciled();
        }
    }
}

