/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jruby.CompatVersion;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.RubyYaccLexer;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.ParserSupport;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.KCode;
import org.rubypeople.rdt.internal.ui.RubyPlugin;

public class RubyTokenScanner
implements ITokenScanner {
    private static final int COMMA = 44;
    private static final int COLON = 58;
    private static final int NEWLINE = 10;
    public static final int CHARACTER = 128;
    static final int MIN_KEYWORD = 257;
    static final int MAX_KEYWORD = 303;
    private RubyYaccLexer lexer = new RubyYaccLexer();
    private LexerSource lexerSource;
    private ParserSupport parserSupport = new ParserSupport();
    private int fTokenLength;
    private int fOffset;
    private boolean isInSymbol;
    private boolean inAlias;
    private RubyParserResult result;
    private int origOffset;
    private int origLength;
    private String fContents;

    public RubyTokenScanner() {
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        this.parserSupport.setConfiguration(config);
        this.result = new RubyParserResult();
        this.parserSupport.setResult(this.result);
        this.lexer.setParserSupport(this.parserSupport);
        this.lexer.setWarnings((IRubyWarnings)new NullWarnings());
        this.lexer.setEncoding(config.getKCode().getEncoding());
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        this.fOffset = this.getOffset();
        this.fTokenLength = 0;
        Token returnValue = new Token((Object)306);
        boolean isEOF = false;
        try {
            boolean bl = isEOF = !this.lexer.advance();
            if (isEOF) {
                returnValue = Token.EOF;
            } else {
                this.fTokenLength = this.getOffset() - this.fOffset;
                returnValue = this.token(this.lexer.token());
            }
        }
        catch (SyntaxException syntaxException) {
            if (this.lexerSource.getOffset() - this.origLength == 0) {
                return Token.EOF;
            }
            this.fTokenLength = this.getOffset() - this.fOffset;
            return this.token(256);
        }
        catch (NumberFormatException numberFormatException) {
            this.fTokenLength = this.getOffset() - this.fOffset;
            return returnValue;
        }
        catch (IOException e) {
            RubyPlugin.log(e);
        }
        return returnValue;
    }

    private int getOffset() {
        return this.lexerSource.getOffset() + this.origOffset;
    }

    private IToken token(int i) {
        if (this.isInSymbol) {
            if (this.isSymbolTerminator(i)) {
                this.isInSymbol = false;
                if (this.shouldReturnDefault(i)) {
                    return new Token((Object)new Integer(i));
                }
            }
            return new Token((Object)new Integer(364));
        }
        if (i == 298) {
            this.inAlias = true;
        }
        if (i == 58 && this.inAlias) {
            this.isInSymbol = true;
            this.inAlias = false;
            return new Token((Object)new Integer(364));
        }
        if (this.isKeyword(i)) {
            return new Token((Object)new Integer(303));
        }
        switch (i) {
            case 364: {
                if (this.looksLikeTertiaryConditionalWithNoSpaces()) {
                    return new Token((Object)new Integer(335));
                }
                this.isInSymbol = true;
                return new Token((Object)new Integer(364));
            }
            case 308: 
            case 376: {
                return new Token((Object)new Integer(308));
            }
            case 378: 
            case 379: {
                if (this.fOffset - this.origOffset + 1 < this.fContents.length() && this.fContents.charAt(this.fOffset - this.origOffset + 1) == '?') {
                    return new Token((Object)new Integer(128));
                }
                return new Token((Object)new Integer(i));
            }
        }
        return new Token((Object)new Integer(i));
    }

    private boolean looksLikeTertiaryConditionalWithNoSpaces() {
        if (this.fTokenLength > 1) {
            return false;
        }
        int index = this.fOffset - this.origOffset - 1;
        if (index < 0) {
            return false;
        }
        try {
            char c = this.fContents.charAt(index);
            return !Character.isWhitespace(c) && Character.isUnicodeIdentifierPart(c);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private boolean shouldReturnDefault(int i) {
        switch (i) {
            case 10: 
            case 44: 
            case 338: 
            case 341: {
                return true;
            }
        }
        return false;
    }

    private boolean isSymbolTerminator(int i) {
        if (this.isRealKeyword(i)) {
            return true;
        }
        switch (i) {
            case 10: 
            case 44: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 331: 
            case 332: 
            case 333: 
            case 338: 
            case 341: 
            case 348: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 360: 
            case 363: {
                return true;
            }
        }
        return false;
    }

    private boolean isRealKeyword(int i) {
        return i >= 257 && i <= 303;
    }

    private boolean isKeyword(int i) {
        String src;
        if (i != 306) {
            return false;
        }
        try {
            src = this.fContents.substring(this.fOffset - this.origOffset, this.fOffset - this.origOffset + this.fTokenLength);
        }
        catch (RuntimeException e) {
            RubyPlugin.log(e);
            return false;
        }
        if (src == null || src.trim().length() == 0) {
            return false;
        }
        Preferences prefs = RubyPlugin.getDefault().getPluginPreferences();
        if (prefs == null) {
            return false;
        }
        String rawKeywords = prefs.getString("userDefinedKeywords");
        if (rawKeywords == null || rawKeywords.length() == 0) {
            return false;
        }
        String[] keywords = rawKeywords.split(",");
        if (keywords == null || keywords.length == 0) {
            return false;
        }
        int j = 0;
        while (j < keywords.length) {
            if (keywords[j] != null && keywords[j].equals(src.trim())) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.lexer.reset();
        this.lexer.setState(RubyYaccLexer.LexState.EXPR_BEG);
        this.parserSupport.initTopLocalVariables();
        this.isInSymbol = false;
        ParserConfiguration config = new ParserConfiguration(KCode.NIL, 0, true, false, CompatVersion.RUBY1_8);
        try {
            this.fContents = document.get(offset, length);
            this.lexerSource = LexerSource.getSource((String)"filename", (Reader)new StringReader(this.fContents), null, (ParserConfiguration)config);
            this.lexer.setSource(this.lexerSource);
        }
        catch (BadLocationException badLocationException) {
            this.lexerSource = LexerSource.getSource((String)"filename", (Reader)new StringReader(""), null, (ParserConfiguration)config);
            this.lexer.setSource(this.lexerSource);
        }
        this.origOffset = offset;
        this.origLength = length;
    }
}

