/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.osgi.framework.Bundle;
import org.rubypeople.rdt.core.ICodeAssist;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyScriptEditorInput;
import org.rubypeople.rdt.internal.ui.rubyeditor.WorkingCopyManager;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.RubyWordFinder;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyHoverMessages;
import org.rubypeople.rdt.ui.text.ruby.hover.IRubyEditorTextHover;

public abstract class AbstractRubyEditorTextHover
implements IRubyEditorTextHover,
ITextHoverExtension {
    private static String fgStyleSheet;
    private IEditorPart fEditor;
    private IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);

    public void setEditor(IEditorPart editor) {
        this.fEditor = editor;
    }

    protected IEditorPart getEditor() {
        return this.fEditor;
    }

    protected ICodeAssist getCodeAssist() {
        if (this.fEditor != null) {
            IEditorInput input = this.fEditor.getEditorInput();
            if (input instanceof RubyScriptEditorInput) {
                RubyScriptEditorInput cfeInput = (RubyScriptEditorInput)input;
                return cfeInput.getRubyScript();
            }
            WorkingCopyManager manager = RubyPlugin.getDefault().getWorkingCopyManager();
            return manager.getWorkingCopy(input, false);
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return RubyWordFinder.findWord(textViewer.getDocument(), offset);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        ICodeAssist resolve;
        IDocument doc;
        block13: {
            if (hoverRegion.getLength() == 0) {
                return null;
            }
            try {
                doc = textViewer.getDocument();
                if (doc != null) break block13;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        String contentType = null;
        if (doc instanceof IDocumentExtension3) {
            IDocumentExtension3 extension = (IDocumentExtension3)doc;
            try {
                contentType = extension.getContentType("___ruby_partitioning", hoverRegion.getOffset(), false);
            }
            catch (BadPartitioningException badPartitioningException) {}
        }
        if (contentType != null && !contentType.equals("__dftl_partition_content_type")) {
            return null;
        }
        if ((resolve = this.getCodeAssist()) != null) {
            IRubyElement[] result;
            block15: {
                block14: {
                    try {
                        result = resolve.codeSelect(hoverRegion.getOffset(), hoverRegion.getLength());
                        if (result != null) break block14;
                        return null;
                    }
                    catch (RubyModelException rubyModelException) {
                        return null;
                    }
                }
                int nResults = result.length;
                if (nResults != 0) break block15;
                return null;
            }
            return this.getHoverInfo(result);
        }
        return null;
    }

    protected String getHoverInfo(IRubyElement[] rubyElements) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractRubyEditorTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null || !RubyPlugin.getDefault().getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.rubypeople.rdt.ui.edit.text.ruby.show.rdoc");
        if (keySequence == null) {
            return null;
        }
        return Messages.format((String)RubyHoverMessages.RubyTextHover_makeStickyHint, (String)(keySequence == null ? "" : keySequence));
    }

    public static String getStyleSheet() {
        Bundle bundle;
        URL styleSheetURL;
        if (fgStyleSheet == null && (styleSheetURL = (bundle = Platform.getBundle((String)RubyPlugin.getPluginId())).getEntry("/RubydocHoverStyleSheet.css")) != null) {
            try {
                styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
                BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
                StringBuffer buffer = new StringBuffer(200);
                String line = reader.readLine();
                while (line != null) {
                    buffer.append(line);
                    buffer.append('\n');
                    line = reader.readLine();
                }
                fgStyleSheet = buffer.toString();
            }
            catch (IOException ex) {
                RubyPlugin.log(ex);
                fgStyleSheet = "";
            }
        }
        return fgStyleSheet;
    }
}

