/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.ruby.hover;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.corext.util.RDocUtil;
import org.rubypeople.rdt.internal.ui.text.HTMLPrinter;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.ruby.IInformationControlExtension4;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractReusableInformationControlCreator;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.AbstractRubyEditorTextHover;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.BrowserInformationControl;

public class CommentHoverProvider
extends AbstractRubyEditorTextHover
implements IInformationProviderExtension2 {
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;

    protected String getHoverInfo(IRubyElement[] result) {
        StringBuffer buffer = new StringBuffer();
        String contents = RDocUtil.getHTMLDocumentation(result);
        if (contents != null) {
            buffer.append(contents);
        }
        if (buffer.length() > 0) {
            HTMLPrinter.insertPageProlog(buffer, 0, CommentHoverProvider.getStyleSheet());
            HTMLPrinter.addPageEpilog(buffer);
            return buffer.toString();
        }
        return null;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    int shellStyle = 20;
                    int style = 768;
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, shellStyle, style);
                    }
                    return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
                }
            };
        }
        return this.fPresenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new AbstractReusableInformationControlCreator(){

                public IInformationControl doCreateInformationControl(Shell parent) {
                    if (BrowserInformationControl.isAvailable((Composite)parent)) {
                        return new BrowserInformationControl(parent, 12, 0, CommentHoverProvider.this.getTooltipAffordanceString());
                    }
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), CommentHoverProvider.this.getTooltipAffordanceString());
                }

                public boolean canReuse(IInformationControl control) {
                    boolean canReuse = super.canReuse(control);
                    if (canReuse && control instanceof IInformationControlExtension4) {
                        ((IInformationControlExtension4)control).setStatusText(CommentHoverProvider.this.getTooltipAffordanceString());
                    }
                    return canReuse;
                }
            };
        }
        return this.fHoverControlCreator;
    }
}

