/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.text.spelling.RubySpellingProblem;
import org.rubypeople.rdt.internal.ui.text.spelling.SpellCheckEngine;
import org.rubypeople.rdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class AddWordProposal
implements IRubyCompletionProposal {
    private final IInvocationContext fContext;
    private final String fWord;

    public AddWordProposal(String word, IInvocationContext context) {
        this.fContext = context;
        this.fWord = word;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore());
        if (checker != null) {
            checker.addWord(this.fWord);
            RubySpellingProblem.removeAllInActiveEditor(this.fWord);
        }
    }

    public String getAdditionalProposalInfo() {
        return Messages.format(RubyUIMessages.Spelling_add_info, new String[]{WordCorrectionProposal.getHtmlRepresentation(this.fWord)});
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return Messages.format(RubyUIMessages.Spelling_add_label, new String[]{this.fWord});
    }

    public Image getImage() {
        return RubyPluginImages.get("org.rubypeople.rdt.ui.add_correction.gif");
    }

    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument document) {
        return new Point(this.fContext.getSelectionOffset(), this.fContext.getSelectionLength());
    }
}

