/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyDocumentProvider;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellEvent;

public class RubySpellingProblem
extends SpellingProblem {
    private ISpellEvent fSpellEvent;

    public RubySpellingProblem(ISpellEvent spellEvent) {
        this.fSpellEvent = spellEvent;
    }

    public int getOffset() {
        return this.fSpellEvent.getBegin();
    }

    public int getLength() {
        return this.fSpellEvent.getEnd() - this.fSpellEvent.getBegin() + 1;
    }

    public String getMessage() {
        if (this.isSentenceStart() && this.isDictionaryMatch()) {
            return Messages.format(RubyUIMessages.Spelling_error_case_label, new String[]{this.fSpellEvent.getWord()});
        }
        return Messages.format(RubyUIMessages.Spelling_error_label, new String[]{this.fSpellEvent.getWord()});
    }

    public ICompletionProposal[] getProposals() {
        return new ICompletionProposal[0];
    }

    public boolean isDictionaryMatch() {
        return this.fSpellEvent.isMatch();
    }

    public boolean isSentenceStart() {
        return this.fSpellEvent.isStart();
    }

    public static void removeAllInActiveEditor(String word) {
        if (word == null) {
            return;
        }
        IWorkbenchPage activePage = RubyPlugin.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (activePage.getActivePart() != editor || !(editor instanceof ITextEditor)) {
            return;
        }
        IDocumentProvider documentProvider = ((ITextEditor)editor).getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return;
        }
        boolean supportsBatchReplace = model instanceof IAnnotationModelExtension;
        ArrayList<Annotation> toBeRemovedAnnotations = new ArrayList<Annotation>();
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            String[] arguments;
            Annotation annotation = (Annotation)iter.next();
            if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(annotation.getType()) || !(annotation instanceof RubyDocumentProvider.ProblemAnnotation) || (arguments = ((RubyDocumentProvider.ProblemAnnotation)annotation).getArguments()) == null || arguments.length <= 0 || !word.equals(arguments[0])) continue;
            if (supportsBatchReplace) {
                toBeRemovedAnnotations.add(annotation);
                continue;
            }
            model.removeAnnotation(annotation);
        }
        if (supportsBatchReplace && !toBeRemovedAnnotations.isEmpty()) {
            Annotation[] annotationArray = toBeRemovedAnnotations.toArray(new Annotation[toBeRemovedAnnotations.size()]);
            ((IAnnotationModelExtension)model).replaceAnnotations(annotationArray, null);
        }
    }
}

