/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.internal.ui.text.spelling.AddWordProposal;
import org.rubypeople.rdt.internal.ui.text.spelling.ChangeCaseProposal;
import org.rubypeople.rdt.internal.ui.text.spelling.SpellCheckEngine;
import org.rubypeople.rdt.internal.ui.text.spelling.WordCorrectionProposal;
import org.rubypeople.rdt.internal.ui.text.spelling.WordIgnoreProposal;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.rubypeople.rdt.internal.ui.text.spelling.engine.RankedWordProposal;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.text.ruby.IInvocationContext;
import org.rubypeople.rdt.ui.text.ruby.IProblemLocation;
import org.rubypeople.rdt.ui.text.ruby.IQuickFixProcessor;
import org.rubypeople.rdt.ui.text.ruby.IRubyCompletionProposal;

public class WordQuickFixProcessor
implements IQuickFixProcessor {
    public IRubyCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        int threshold = PreferenceConstants.getPreferenceStore().getInt("spelling_proposal_threshold");
        int size = 0;
        List proposals = null;
        String[] arguments = null;
        IProblemLocation location = null;
        RankedWordProposal proposal = null;
        IRubyCompletionProposal[] result = null;
        boolean fixed = false;
        boolean match = false;
        boolean sentence = false;
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), PreferenceConstants.getPreferenceStore());
        if (checker != null) {
            int index = 0;
            while (index < locations.length) {
                location = locations[index];
                if (location.getProblemId() == Integer.MIN_VALUE && (arguments = location.getProblemArguments()) != null && arguments.length > 4) {
                    sentence = Boolean.valueOf(arguments[3]);
                    match = Boolean.valueOf(arguments[4]);
                    if (sentence && match && !fixed) {
                        result = new IRubyCompletionProposal[]{new ChangeCaseProposal(arguments, location.getOffset(), location.getLength(), context, engine.getLocale())};
                        break;
                    }
                    proposals = new ArrayList(checker.getProposals(arguments[0], sentence));
                    size = proposals.size();
                    if (threshold > 0 && size > threshold) {
                        Collections.sort(proposals);
                        proposals = proposals.subList(size - threshold - 1, size - 1);
                        size = proposals.size();
                    }
                    boolean extendable = !fixed ? checker.acceptsWords() : false;
                    result = new IRubyCompletionProposal[size + (extendable ? 2 : 1)];
                    index = 0;
                    while (index < size) {
                        proposal = (RankedWordProposal)proposals.get(index);
                        result[index] = new WordCorrectionProposal(proposal.getText(), arguments, location.getOffset(), location.getLength(), context, proposal.getRank());
                        ++index;
                    }
                    if (extendable) {
                        result[index++] = new AddWordProposal(arguments[0], context);
                    }
                    result[index++] = new WordIgnoreProposal(arguments[0], context);
                    break;
                }
                ++index;
            }
        }
        return result;
    }

    public boolean hasCorrections(IRubyScript unit, int id) {
        return id == Integer.MIN_VALUE;
    }
}

