/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.rubypeople.rdt.core.ElementChangedEvent;
import org.rubypeople.rdt.core.IElementChangedListener;
import org.rubypeople.rdt.core.IRegion;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.ITypeHierarchyChangedListener;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.codeassist.RubyElementRequestor;
import org.rubypeople.rdt.internal.core.LogicalType;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IRubyElement fInputElement = null;
    private boolean fIsSuperTypesOnly;
    private List fChangeListeners;

    public TypeHierarchyLifeCycle() {
        this(false);
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
        this.fIsSuperTypesOnly = isSuperTypesOnly;
        this.fChangeListeners = new ArrayList(2);
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IRubyElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            RubyCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(IType[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(final IRubyElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        if (element == null || !element.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(element, pm);
                    }
                    catch (RubyModelException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            context.run(true, true, op);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private IType getLogicalType(IType type, String name) {
        RubyElementRequestor requestor = new RubyElementRequestor(type.getRubyScript());
        IType[] types = requestor.findType(name);
        if (types == null || types.length == 0) {
            return null;
        }
        return new LogicalType(types);
    }

    private ITypeHierarchy createTypeHierarchy(IRubyElement element, IProgressMonitor pm) throws RubyModelException {
        ISourceFolderRoot[] roots;
        if (element.getElementType() == 5) {
            IType type = (IType)element;
            type = this.getLogicalType(type, type.getFullyQualifiedName());
            if (this.fIsSuperTypesOnly) {
                return type.newSupertypeHierarchy(pm);
            }
            return type.newTypeHierarchy(pm);
        }
        IRegion region = RubyCore.newRegion();
        if (element.getElementType() == 1) {
            roots = ((IRubyProject)element).getSourceFolderRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isExternal()) {
                    region.add((IRubyElement)roots[i]);
                }
                ++i;
            }
        } else if (element.getElementType() == 3) {
            roots = element.getRubyProject().getSourceFolderRoots();
            String name = element.getElementName();
            int i = 0;
            while (i < roots.length) {
                ISourceFolder pack = roots[i].getSourceFolder(name);
                if (pack.exists()) {
                    region.add((IRubyElement)pack);
                }
                ++i;
            }
        } else {
            region.add(element);
        }
        IRubyProject jproject = element.getRubyProject();
        return jproject.newTypeHierarchy(region, pm);
    }

    public synchronized void doHierarchyRefresh(IRubyElement element, IProgressMonitor pm) throws RubyModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            RubyCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            this.fHierarchy = this.createTypeHierarchy(element, pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElement = element;
        } else {
            this.fHierarchy.refresh(pm);
        }
        if (this.fHierarchy != null) {
            this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            RubyCore.addElementChangedListener((IElementChangedListener)this);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new IType[changedTypes.size()]));
        }
    }

    private void processDelta(IRubyElementDelta delta, ArrayList changedTypes) {
        IRubyElement element = delta.getElement();
        switch (element.getElementType()) {
            case 5: {
                this.processTypeDelta((IType)element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 4: {
                IRubyScript cu = (IRubyScript)element;
                if (!RubyModelUtil.isPrimary(cu)) {
                    return;
                }
                if (delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    try {
                        if (!cu.exists()) break;
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.processTypeDelta(types[i], changedTypes);
                            ++i;
                        }
                    }
                    catch (RubyModelException e) {
                        RubyPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x4001) == 1;
    }

    private void processTypeDelta(IType type, ArrayList changedTypes) {
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(IRubyElementDelta delta, ArrayList changedTypes) {
        IRubyElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }
}

