/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.ITypeHierarchy;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.CompositeActionGroup;
import org.rubypeople.rdt.internal.ui.actions.NewWizardsActionGroup;
import org.rubypeople.rdt.internal.ui.actions.SelectAllAction;
import org.rubypeople.rdt.internal.ui.dnd.RdtViewerDragAdapter;
import org.rubypeople.rdt.internal.ui.packageview.ResourceTransferDragAdapter;
import org.rubypeople.rdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.rubypeople.rdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.typehierarchy.EnableMemberFilterAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.FocusOnSelectionAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.FocusOnTypeAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.HistoryDropDownAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.rubypeople.rdt.internal.ui.typehierarchy.MethodsViewer;
import org.rubypeople.rdt.internal.ui.typehierarchy.ShowQualifiedTypeNamesAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.SubTypeHierarchyViewer;
import org.rubypeople.rdt.internal.ui.typehierarchy.SuperTypeHierarchyViewer;
import org.rubypeople.rdt.internal.ui.typehierarchy.ToggleLinkingAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.ToggleOrientationAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.ToggleViewAction;
import org.rubypeople.rdt.internal.ui.typehierarchy.TraditionalHierarchyViewer;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyMessages;
import org.rubypeople.rdt.internal.ui.typehierarchy.TypeHierarchyViewer;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.SelectionProviderMediator;
import org.rubypeople.rdt.internal.ui.viewsupport.StatusBarUpdater;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.rubypeople.rdt.ui.ITypeHierarchyViewPart;
import org.rubypeople.rdt.ui.PreferenceConstants;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.actions.OpenEditorActionGroup;
import org.rubypeople.rdt.ui.actions.OpenViewActionGroup;
import org.rubypeople.rdt.ui.actions.RubySearchActionGroup;

public class TypeHierarchyViewPart
extends ViewPart
implements ITypeHierarchyViewPart,
IViewPartInputProvider {
    public static final int VIEW_ID_TYPE = 2;
    public static final int VIEW_ID_SUPER = 0;
    public static final int VIEW_ID_SUB = 1;
    public static final int VIEW_ORIENTATION_VERTICAL = 0;
    public static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    public static final int VIEW_ORIENTATION_SINGLE = 2;
    public static final int VIEW_ORIENTATION_AUTOMATIC = 3;
    private static final String DIALOGSTORE_HIERARCHYVIEW = "TypeHierarchyViewPart.hierarchyview";
    private static final String DIALOGSTORE_VIEWORIENTATION = "TypeHierarchyViewPart.orientation";
    private static final String TAG_INPUT = "input";
    private static final String TAG_VIEW = "view";
    private static final String TAG_ORIENTATION = "orientation";
    private static final String TAG_RATIO = "ratio";
    private static final String TAG_SELECTION = "selection";
    private static final String TAG_VERTICAL_SCROLL = "vertical_scroll";
    private static final String GROUP_FOCUS = "group.focus";
    private IType fSelectedType = null;
    private IRubyElement fInputElement = null;
    private ArrayList fInputHistory;
    private IMemento fMemento;
    private IDialogSettings fDialogSettings;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle = new TypeHierarchyLifeCycle();
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

        public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchy, IType[] changedTypes) {
            TypeHierarchyViewPart.this.doTypeHierarchyChanged(typeHierarchy, changedTypes);
        }
    };
    private IPropertyChangeListener fPropertyChangeListener;
    private SelectionProviderMediator fSelectionProviderMediator;
    private ISelectionChangedListener fSelectionChangedListener;
    private IPartListener2 fPartListener;
    private int fCurrentOrientation;
    int fOrientation = 3;
    boolean fInComputeOrientation = false;
    private boolean fLinkingEnabled;
    private boolean fSelectInEditor = true;
    private boolean fIsVisible = false;
    private boolean fNeedRefresh;
    private boolean fIsEnableMemberFilter;
    private boolean fIsRefreshRunnablePosted = false;
    private int fCurrentViewerIndex;
    private TypeHierarchyViewer[] fAllViewers;
    private MethodsViewer fMethodsViewer;
    private SashForm fTypeMethodsSplitter;
    private PageBook fViewerbook;
    private PageBook fPagebook;
    private Label fNoHierarchyShownLabel;
    private Label fEmptyTypesViewer;
    private ViewForm fTypeViewerViewForm;
    private ViewForm fMethodViewerViewForm;
    private CLabel fMethodViewerPaneLabel;
    private RubyUILabelProvider fPaneLabelProvider;
    private Composite fParent;
    private ToggleViewAction[] fViewActions;
    private ToggleLinkingAction fToggleLinkingAction;
    private HistoryDropDownAction fHistoryDropDownAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private EnableMemberFilterAction fEnableMemberFilterAction;
    private ShowQualifiedTypeNamesAction fShowQualifiedTypeNamesAction;
    private FocusOnTypeAction fFocusOnTypeAction;
    private FocusOnSelectionAction fFocusOnSelectionAction;
    private CompositeActionGroup fActionGroups;
    private SelectAllAction fSelectAllAction;
    private WorkingSetFilterActionGroup fWorkingSetActionGroup;
    private Job fRestoreStateJob = null;

    public TypeHierarchyViewPart() {
        this.fHierarchyLifeCycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TypeHierarchyViewPart.this.doPropertyChange(event);
            }
        };
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        this.fIsEnableMemberFilter = false;
        this.fInputHistory = new ArrayList();
        this.fAllViewers = null;
        this.fViewActions = new ToggleViewAction[]{new ToggleViewAction(this, 2), new ToggleViewAction(this, 0), new ToggleViewAction(this, 1)};
        this.fDialogSettings = RubyPlugin.getDefault().getDialogSettings();
        this.fHistoryDropDownAction = new HistoryDropDownAction(this);
        this.fHistoryDropDownAction.setEnabled(false);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 3), new ToggleOrientationAction(this, 2)};
        this.fEnableMemberFilterAction = new EnableMemberFilterAction(this, false);
        this.fShowQualifiedTypeNamesAction = new ShowQualifiedTypeNamesAction(this, false);
        this.fFocusOnTypeAction = new FocusOnTypeAction(this);
        this.fPaneLabelProvider = new RubyUILabelProvider();
        this.fFocusOnSelectionAction = new FocusOnSelectionAction(this);
        this.fPartListener = new IPartListener2(){

            public void partVisible(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(true);
                }
            }

            public void partHidden(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part == TypeHierarchyViewPart.this) {
                    TypeHierarchyViewPart.this.visibilityChanged(false);
                }
            }

            public void partActivated(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)part);
                }
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
                IWorkbenchPart part = ref.getPart(false);
                if (part instanceof IEditorPart) {
                    TypeHierarchyViewPart.this.editorActivated((IEditorPart)part);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
            }

            public void partClosed(IWorkbenchPartReference ref) {
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }
        };
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TypeHierarchyViewPart.this.doSelectionChanged(event);
            }
        };
        this.fLinkingEnabled = PreferenceConstants.getPreferenceStore().getBoolean("org.rubypeople.rdt.ui.packages.linktypehierarchytoeditor");
    }

    protected void doPropertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (this.fMethodsViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.fMethodsViewer.refresh();
        }
        if ("workingSetContentChange".equals(property)) {
            this.updateHierarchyViewer(true);
            this.updateTitle();
        }
    }

    private void addHistoryEntry(IRubyElement entry) {
        if (this.fInputHistory.contains(entry)) {
            this.fInputHistory.remove(entry);
        }
        this.fInputHistory.add(0, entry);
        this.fHistoryDropDownAction.setEnabled(true);
    }

    private void updateHistoryEntries() {
        int i = this.fInputHistory.size() - 1;
        while (i >= 0) {
            IRubyElement type = (IRubyElement)this.fInputHistory.get(i);
            if (!type.exists()) {
                this.fInputHistory.remove(i);
            }
            --i;
        }
        this.fHistoryDropDownAction.setEnabled(!this.fInputHistory.isEmpty());
    }

    public void gotoHistoryEntry(IRubyElement entry) {
        if (this.fInputHistory.contains(entry)) {
            this.updateInput(entry);
        }
    }

    public IRubyElement[] getHistoryEntries() {
        if (this.fInputHistory.size() > 0) {
            this.updateHistoryEntries();
        }
        return this.fInputHistory.toArray(new IRubyElement[this.fInputHistory.size()]);
    }

    public void setHistoryEntries(IRubyElement[] elems) {
        this.fInputHistory.clear();
        int i = 0;
        while (i < elems.length) {
            this.fInputHistory.add(elems[i]);
            ++i;
        }
        this.updateHistoryEntries();
    }

    public void selectMember(IMember member) {
        this.fSelectInEditor = false;
        if (member.getElementType() != 5) {
            Control methodControl = this.fMethodsViewer.getControl();
            if (methodControl != null && !methodControl.isDisposed()) {
                methodControl.setFocus();
            }
            this.fMethodsViewer.setSelection((ISelection)new StructuredSelection((Object)member), true);
        } else {
            Control viewerControl = this.getCurrentViewer().getControl();
            if (viewerControl != null && !viewerControl.isDisposed()) {
                viewerControl.setFocus();
            }
            if (!member.equals(this.fSelectedType)) {
                this.getCurrentViewer().setSelection((ISelection)new StructuredSelection((Object)member), true);
            }
        }
        this.fSelectInEditor = true;
    }

    public IType getInput() {
        if (this.fInputElement instanceof IType) {
            return (IType)this.fInputElement;
        }
        return null;
    }

    public void setInput(IType type) {
        this.setInputElement((IRubyElement)type);
    }

    public IRubyElement getInputElement() {
        return this.fInputElement;
    }

    public void setInputElement(IRubyElement element) {
        IMember memberToSelect = null;
        if (element != null) {
            if (element instanceof IMember) {
                if (element.getElementType() != 5) {
                    memberToSelect = (IMember)element;
                    element = memberToSelect.getDeclaringType();
                }
                if (!element.exists()) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)TypeHierarchyMessages.TypeHierarchyViewPart_error_title, (String)TypeHierarchyMessages.TypeHierarchyViewPart_error_message);
                    return;
                }
            } else {
                int kind = element.getElementType();
                if (kind != 1 && kind != 2 && kind != 3) {
                    element = null;
                    RubyPlugin.logErrorMessage("Invalid type hierarchy input type.");
                }
            }
        }
        if (element != null && !element.equals(this.fInputElement)) {
            this.addHistoryEntry(element);
        }
        this.updateInput(element);
        if (memberToSelect != null) {
            this.selectMember(memberToSelect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInput(IRubyElement inputElement) {
        IRubyElement prevInput = this.fInputElement;
        TypeHierarchyViewPart typeHierarchyViewPart = this;
        synchronized (typeHierarchyViewPart) {
            block16: {
                if (this.fRestoreStateJob != null) {
                    this.fRestoreStateJob.cancel();
                    try {
                        try {
                            this.fRestoreStateJob.join();
                        }
                        catch (InterruptedException interruptedException) {
                            this.fRestoreStateJob = null;
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fRestoreStateJob = null;
                        throw throwable;
                    }
                    this.fRestoreStateJob = null;
                }
            }
        }
        this.processOutstandingEvents();
        if (inputElement == null) {
            this.clearInput();
        } else {
            this.fInputElement = inputElement;
            try {
                this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(inputElement, (IRunnableContext)RubyPlugin.getActiveWorkbenchWindow());
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), TypeHierarchyMessages.TypeHierarchyViewPart_exception_title, TypeHierarchyMessages.TypeHierarchyViewPart_exception_message);
                this.clearInput();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            if (inputElement.getElementType() != 5) {
                this.setView(2);
            }
            this.fSelectInEditor = false;
            this.setMemberFilter(null);
            this.internalSelectType(null, false);
            this.fIsEnableMemberFilter = false;
            if (!inputElement.equals(prevInput)) {
                this.updateHierarchyViewer(true);
            }
            IType root = this.getSelectableType(inputElement);
            this.internalSelectType((IMember)root, true);
            this.updateMethodViewer(root);
            this.updateToolbarButtons();
            this.updateTitle();
            this.enableMemberFilter(false);
            this.fPagebook.showPage((Control)this.fTypeMethodsSplitter);
            this.fSelectInEditor = true;
        }
    }

    private void processOutstandingEvents() {
        Display display = this.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.update();
        }
    }

    private void clearInput() {
        this.fInputElement = null;
        this.fHierarchyLifeCycle.freeHierarchy();
        this.updateHierarchyViewer(false);
        this.updateToolbarButtons();
    }

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void dispose() {
        this.fHierarchyLifeCycle.freeHierarchy();
        this.fHierarchyLifeCycle.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
        this.fPaneLabelProvider.dispose();
        if (this.fMethodsViewer != null) {
            this.fMethodsViewer.dispose();
        }
        if (this.fPropertyChangeListener != null) {
            RubyPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        if (this.fWorkingSetActionGroup != null) {
            this.fWorkingSetActionGroup.dispose();
        }
        super.dispose();
    }

    public Object getAdapter(Class key) {
        if (key == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (key == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.rubypeople.rdt.ui.RubyExplorer", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        return super.getAdapter(key);
    }

    private Control createTypeViewerControl(Composite parent) {
        int currViewerIndex;
        this.fViewerbook = new PageBook(parent, 0);
        KeyListener keyListener = this.createKeyListener();
        SuperTypeHierarchyViewer superTypesViewer = new SuperTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(superTypesViewer, keyListener, "org.rubypeople.rdt.ui.TypeHierarchy.supertypes");
        SubTypeHierarchyViewer subTypesViewer = new SubTypeHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(subTypesViewer, keyListener, "org.rubypeople.rdt.ui.TypeHierarchy.subtypes");
        TraditionalHierarchyViewer vajViewer = new TraditionalHierarchyViewer((Composite)this.fViewerbook, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.initializeTypesViewer(vajViewer, keyListener, "org.rubypeople.rdt.ui.TypeHierarchy.typehierarchy");
        this.fAllViewers = new TypeHierarchyViewer[3];
        this.fAllViewers[0] = superTypesViewer;
        this.fAllViewers[1] = subTypesViewer;
        this.fAllViewers[2] = vajViewer;
        try {
            currViewerIndex = this.fDialogSettings.getInt(DIALOGSTORE_HIERARCHYVIEW);
            if (currViewerIndex < 0 || currViewerIndex > 2) {
                currViewerIndex = 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            currViewerIndex = 2;
        }
        this.fEmptyTypesViewer = new Label((Composite)this.fViewerbook, 16576);
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setInput(this.fAllViewers[i]);
            ++i;
        }
        this.fCurrentViewerIndex = -1;
        this.setView(currViewerIndex);
        return this.fViewerbook;
    }

    private KeyListener createKeyListener() {
        return new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.stateMask == 0 && event.keyCode == 0x100000E) {
                    ITypeHierarchy hierarchy = TypeHierarchyViewPart.this.fHierarchyLifeCycle.getHierarchy();
                    if (hierarchy != null) {
                        TypeHierarchyViewPart.this.fHierarchyLifeCycle.typeHierarchyChanged(hierarchy);
                        TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(null);
                    }
                    TypeHierarchyViewPart.this.updateHierarchyViewer(false);
                    return;
                }
            }
        };
    }

    private void initializeTypesViewer(final TypeHierarchyViewer typesViewer, KeyListener keyListener, String cotextHelpId) {
        typesViewer.getControl().setVisible(false);
        typesViewer.getControl().addKeyListener(keyListener);
        typesViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                TypeHierarchyViewPart.this.fillTypesViewerContextMenu(typesViewer, menu);
            }
        }, cotextHelpId, this.getSite());
        typesViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        typesViewer.setQualifiedTypeName(this.isShowQualifiedTypeNames());
        typesViewer.setWorkingSetFilter(this.fWorkingSetActionGroup.getWorkingSetFilter());
    }

    private Control createMethodViewerControl(Composite parent) {
        this.fMethodsViewer = new MethodsViewer(parent, this.fHierarchyLifeCycle, (IWorkbenchPart)this);
        this.fMethodsViewer.initContextMenu(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                TypeHierarchyViewPart.this.fillMethodsViewerContextMenu(menu);
            }
        }, "org.rubypeople.rdt.ui.TypeHierarchy.members", this.getSite());
        this.fMethodsViewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
        Table control = this.fMethodsViewer.getTable();
        control.addKeyListener(this.createKeyListener());
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(true);
            }

            public void focusLost(FocusEvent e) {
                TypeHierarchyViewPart.this.fSelectAllAction.setEnabled(false);
            }
        });
        return control;
    }

    private void initDragAndDrop() {
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.addDragAdapters((StructuredViewer)this.fAllViewers[i]);
            this.addDropAdapters((AbstractTreeViewer)this.fAllViewers[i]);
            ++i;
        }
        this.addDragAdapters((StructuredViewer)this.fMethodsViewer);
        this.fMethodsViewer.addDropSupport(0, new Transfer[0], (DropTargetListener)new DropTargetAdapter());
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
    }

    private void addDropAdapters(AbstractTreeViewer viewer) {
    }

    private void addDragAdapters(StructuredViewer viewer) {
        int ops = 5;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)viewer), new ResourceTransferDragAdapter((ISelectionProvider)viewer)};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new RdtViewerDragAdapter(viewer, dragListeners));
    }

    public void createPartControl(Composite container) {
        this.fParent = container;
        this.addResizeListener(container);
        this.fPagebook = new PageBook(container, 0);
        this.fWorkingSetActionGroup = new WorkingSetFilterActionGroup(this.getSite(), this.fPropertyChangeListener);
        this.fNoHierarchyShownLabel = new Label((Composite)this.fPagebook, 16576);
        this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
        this.fTypeMethodsSplitter = new SashForm((Composite)this.fPagebook, 512);
        this.fTypeMethodsSplitter.setVisible(false);
        this.fTypeViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        Control typeViewerControl = this.createTypeViewerControl((Composite)this.fTypeViewerViewForm);
        this.fTypeViewerViewForm.setContent(typeViewerControl);
        this.fMethodViewerViewForm = new ViewForm((Composite)this.fTypeMethodsSplitter, 0);
        this.fTypeMethodsSplitter.setWeights(new int[]{35, 65});
        Control methodViewerPart = this.createMethodViewerControl((Composite)this.fMethodViewerViewForm);
        this.fMethodViewerViewForm.setContent(methodViewerPart);
        this.fMethodViewerPaneLabel = new CLabel((Composite)this.fMethodViewerViewForm, 0);
        this.fMethodViewerViewForm.setTopLeft((Control)this.fMethodViewerPaneLabel);
        ToolBar methodViewerToolBar = new ToolBar((Composite)this.fMethodViewerViewForm, 0x800040);
        this.fMethodViewerViewForm.setTopCenter((Control)methodViewerToolBar);
        this.initDragAndDrop();
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.fFocusOnTypeAction);
        this.fNoHierarchyShownLabel.setMenu(menu.createContextMenu((Control)this.fNoHierarchyShownLabel));
        this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        try {
            this.fOrientation = this.fDialogSettings.getInt(DIALOGSTORE_VIEWORIENTATION);
            if (this.fOrientation < 0 || this.fOrientation > 3) {
                this.fOrientation = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fOrientation = 3;
        }
        this.fCurrentOrientation = -1;
        this.setOrientation(this.fOrientation);
        if (this.fMemento != null) {
            this.restoreLinkingEnabled(this.fMemento);
        }
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action = this.fViewActions[i];
            viewMenu.add((IAction)action);
            action.setEnabled(false);
            ++i;
        }
        viewMenu.add((IContributionItem)new Separator());
        this.fWorkingSetActionGroup.fillViewMenu(viewMenu);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(TypeHierarchyMessages.TypeHierarchyViewPart_layout_submenu);
        viewMenu.add((IContributionItem)layoutSubMenu);
        int i2 = 0;
        while (i2 < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i2]);
            ++i2;
        }
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IAction)this.fShowQualifiedTypeNamesAction);
        viewMenu.add((IAction)this.fToggleLinkingAction);
        ToolBarManager lowertbmanager = new ToolBarManager(methodViewerToolBar);
        lowertbmanager.add((IAction)this.fEnableMemberFilterAction);
        lowertbmanager.add((IContributionItem)new Separator());
        this.fMethodsViewer.contributeToToolBar(lowertbmanager);
        lowertbmanager.update(true);
        int nHierarchyViewers = this.fAllViewers.length;
        StructuredViewer[] trackedViewers = new StructuredViewer[nHierarchyViewers + 1];
        int i3 = 0;
        while (i3 < nHierarchyViewers) {
            trackedViewers[i3] = this.fAllViewers[i3];
            ++i3;
        }
        trackedViewers[nHierarchyViewers] = this.fMethodsViewer;
        this.fSelectionProviderMediator = new SelectionProviderMediator(trackedViewers, (StructuredViewer)this.getCurrentViewer());
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fSelectionProviderMediator.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProviderMediator);
        this.getSite().getPage().addPartListener(this.fPartListener);
        IRubyElement input = null;
        if (this.fMemento != null) {
            this.restoreState(this.fMemento, input);
        } else if (input != null) {
            this.setInputElement(input);
        } else {
            this.setViewerVisibility(false);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.rubypeople.rdt.ui.type_hierarchy_view_context");
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new NewWizardsActionGroup((IWorkbenchSite)this.getSite()), new OpenEditorActionGroup(this), new OpenViewActionGroup(this), new RubySearchActionGroup(this)});
        this.fActionGroups.fillActionBars(actionBars);
        this.fSelectAllAction = new SelectAllAction(this.fMethodsViewer);
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TypeHierarchyViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fInComputeOrientation) {
            return;
        }
        this.fInComputeOrientation = true;
        try {
            if (this.fOrientation != 3) {
                this.setOrientation(this.fOrientation);
            } else {
                if (this.fOrientation == 2) {
                    return;
                }
                Point size = this.fParent.getSize();
                if (size.x != 0 && size.y != 0) {
                    if (size.x > size.y) {
                        this.setOrientation(1);
                    } else {
                        this.setOrientation(0);
                    }
                }
            }
        }
        finally {
            this.fInComputeOrientation = false;
        }
    }

    public void setOrientation(int orientation) {
        if (this.fCurrentOrientation != orientation) {
            boolean methodViewerNeedsUpdate = false;
            if (this.fMethodViewerViewForm != null && !this.fMethodViewerViewForm.isDisposed() && this.fTypeMethodsSplitter != null && !this.fTypeMethodsSplitter.isDisposed()) {
                if (orientation == 2) {
                    this.fMethodViewerViewForm.setVisible(false);
                    this.enableMemberFilter(false);
                    this.updateMethodViewer(null);
                } else {
                    if (this.fCurrentOrientation == 2) {
                        this.fMethodViewerViewForm.setVisible(true);
                        methodViewerNeedsUpdate = true;
                    }
                    boolean horizontal = orientation == 1;
                    this.fTypeMethodsSplitter.setOrientation(horizontal ? 256 : 512);
                }
                this.updateMainToolbar(orientation);
                this.fTypeMethodsSplitter.layout();
            }
            this.updateCheckedState();
            if (methodViewerNeedsUpdate) {
                this.updateMethodViewer(this.fSelectedType);
            }
            this.fDialogSettings.put(DIALOGSTORE_VIEWORIENTATION, orientation);
            this.fCurrentOrientation = orientation;
        }
    }

    private void updateCheckedState() {
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
    }

    private void updateMainToolbar(int orientation) {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbmanager = actionBars.getToolBarManager();
        if (orientation == 1) {
            this.clearMainToolBar(tbmanager);
            ToolBar typeViewerToolBar = new ToolBar((Composite)this.fTypeViewerViewForm, 0x800040);
            this.fillMainToolBar((IToolBarManager)new ToolBarManager(typeViewerToolBar));
            this.fTypeViewerViewForm.setTopLeft((Control)typeViewerToolBar);
        } else {
            this.fTypeViewerViewForm.setTopLeft(null);
            this.fillMainToolBar(tbmanager);
        }
    }

    private void fillMainToolBar(IToolBarManager tbmanager) {
        tbmanager.removeAll();
        int i = 0;
        while (i < this.fViewActions.length) {
            tbmanager.add((IAction)this.fViewActions[i]);
            ++i;
        }
        tbmanager.add((IAction)this.fHistoryDropDownAction);
        tbmanager.update(false);
    }

    private void clearMainToolBar(IToolBarManager tbmanager) {
        tbmanager.removeAll();
        tbmanager.update(false);
    }

    private void fillTypesViewerContextMenu(TypeHierarchyViewer viewer, IMenuManager menu) {
        RubyPlugin.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IContributionItem)new Separator(GROUP_FOCUS));
        viewer.contributeToContextMenu(menu);
        if (this.fFocusOnSelectionAction.canActionBeAdded()) {
            menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnSelectionAction);
        }
        menu.appendToGroup(GROUP_FOCUS, (IAction)this.fFocusOnTypeAction);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void fillMethodsViewerContextMenu(IMenuManager menu) {
        RubyPlugin.createStandardGroups(menu);
        this.fMethodsViewer.contributeToContextMenu(menu);
        this.fActionGroups.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroups.fillContextMenu(menu);
        this.fActionGroups.setContext(null);
    }

    private void setViewerVisibility(boolean showHierarchy) {
        if (showHierarchy) {
            this.fViewerbook.showPage(this.getCurrentViewer().getControl());
        } else {
            this.fViewerbook.showPage((Control)this.fEmptyTypesViewer);
        }
    }

    private void setMemberFilter(IMember[] memberFilter) {
        Assert.isNotNull((Object)this.fAllViewers);
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setMemberFilter(memberFilter);
            ++i;
        }
    }

    private IType getSelectableType(IRubyElement elem) {
        if (elem.getElementType() != 5) {
            return this.getCurrentViewer().getTreeRootType();
        }
        return (IType)elem;
    }

    private void internalSelectType(IMember elem, boolean reveal) {
        TypeHierarchyViewer viewer = this.getCurrentViewer();
        viewer.removePostSelectionChangedListener(this.fSelectionChangedListener);
        viewer.setSelection((ISelection)(elem != null ? new StructuredSelection((Object)elem) : StructuredSelection.EMPTY), reveal);
        viewer.addPostSelectionChangedListener(this.fSelectionChangedListener);
    }

    private void updateHierarchyViewer(final boolean doExpand) {
        if (this.fInputElement == null) {
            this.fNoHierarchyShownLabel.setText(TypeHierarchyMessages.TypeHierarchyViewPart_empty);
            this.fPagebook.showPage((Control)this.fNoHierarchyShownLabel);
        } else if (this.getCurrentViewer().containsElements() != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    TypeHierarchyViewPart.this.getCurrentViewer().updateContent(doExpand);
                }
            };
            BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
            if (!this.isChildVisible((Composite)this.fViewerbook, this.getCurrentViewer().getControl())) {
                this.setViewerVisibility(true);
            }
        } else {
            this.fEmptyTypesViewer.setText(Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_nodecl, (String)this.fInputElement.getElementName()));
            this.setViewerVisibility(false);
        }
    }

    private void updateMethodViewer(final IType input) {
        if (!this.fIsEnableMemberFilter && this.fCurrentOrientation != 2) {
            if (input == this.fMethodsViewer.getInput()) {
                if (input != null) {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            TypeHierarchyViewPart.this.fMethodsViewer.refresh();
                        }
                    };
                    BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
                }
            } else {
                if (input != null) {
                    this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(input));
                    this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(input));
                } else {
                    this.fMethodViewerPaneLabel.setText("");
                    this.fMethodViewerPaneLabel.setImage(null);
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        TypeHierarchyViewPart.this.fMethodsViewer.setInput(input);
                    }
                };
                BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)runnable);
            }
        }
    }

    protected void doSelectionChanged(SelectionChangedEvent e) {
        if (e.getSelectionProvider() == this.fMethodsViewer) {
            this.methodSelectionChanged(e.getSelection());
        } else {
            this.typeSelectionChanged(e.getSelection());
        }
    }

    private void methodSelectionChanged(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            List selected = ((IStructuredSelection)sel).toList();
            int nSelected = selected.size();
            if (this.fIsEnableMemberFilter) {
                IMember[] memberFilter = null;
                if (nSelected > 0) {
                    memberFilter = new IMember[nSelected];
                    selected.toArray(memberFilter);
                }
                this.setMemberFilter(memberFilter);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                this.internalSelectType((IMember)this.fSelectedType, true);
            }
            if (nSelected == 1 && this.fSelectInEditor) {
                this.revealElementInEditor(selected.get(0), (StructuredViewer)this.fMethodsViewer);
            }
        }
    }

    private void typeSelectionChanged(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            List selected = ((IStructuredSelection)sel).toList();
            int nSelected = selected.size();
            if (nSelected != 0) {
                ArrayList types = new ArrayList(nSelected);
                int i = nSelected - 1;
                while (i >= 0) {
                    Object elem = selected.get(i);
                    if (elem instanceof IType && !types.contains(elem)) {
                        types.add(elem);
                    }
                    --i;
                }
                if (types.size() == 1) {
                    this.fSelectedType = (IType)types.get(0);
                    this.updateMethodViewer(this.fSelectedType);
                } else {
                    types.size();
                }
                if (nSelected == 1 && this.fSelectInEditor) {
                    this.revealElementInEditor(selected.get(0), (StructuredViewer)this.getCurrentViewer());
                }
            } else {
                this.fSelectedType = null;
                this.updateMethodViewer(null);
            }
        }
    }

    private void revealElementInEditor(Object elem, StructuredViewer originViewer) {
        if (this.getSite().getPage().getActivePart() != this) {
            return;
        }
        if (this.fSelectionProviderMediator.getViewerInFocus() != originViewer) {
            return;
        }
        IEditorPart editorPart = EditorUtility.isOpenInEditor(elem);
        if (editorPart != null && elem instanceof IRubyElement) {
            this.getSite().getPage().removePartListener(this.fPartListener);
            this.getSite().getPage().bringToTop((IWorkbenchPart)editorPart);
            EditorUtility.revealInEditor(editorPart, (IRubyElement)elem);
            this.getSite().getPage().addPartListener(this.fPartListener);
        }
    }

    private Display getDisplay() {
        if (this.fPagebook != null && !this.fPagebook.isDisposed()) {
            return this.fPagebook.getDisplay();
        }
        return null;
    }

    private boolean isChildVisible(Composite pb, Control child) {
        Control[] children = pb.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] == child && children[i].isVisible()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void updateTitle() {
        String tooltip;
        String title;
        String viewerTitle = this.getCurrentViewer().getTitle();
        if (this.fInputElement != null) {
            IWorkingSet workingSet = this.fWorkingSetActionGroup.getWorkingSet();
            if (workingSet == null) {
                Object[] args = new String[]{viewerTitle, RubyElementLabels.getElementLabel(this.fInputElement, RubyElementLabels.ALL_DEFAULT)};
                title = Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_title, (Object[])args);
                tooltip = Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_tooltip, (Object[])args);
            } else {
                Object[] args = new String[]{viewerTitle, RubyElementLabels.getElementLabel(this.fInputElement, RubyElementLabels.ALL_DEFAULT), workingSet.getLabel()};
                title = Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_ws_title, (Object[])args);
                tooltip = Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_ws_tooltip, (Object[])args);
            }
        } else {
            title = "";
            tooltip = viewerTitle;
        }
        this.setContentDescription(title);
        this.setTitleToolTip(tooltip);
    }

    private void updateToolbarButtons() {
        boolean isType = this.fInputElement instanceof IType;
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action = this.fViewActions[i];
            if (action.getViewerIndex() == 2) {
                action.setEnabled(this.fInputElement != null);
            } else {
                action.setEnabled(isType);
            }
            ++i;
        }
    }

    public void setView(int viewerIndex) {
        Assert.isNotNull((Object)this.fAllViewers);
        if (viewerIndex < this.fAllViewers.length && this.fCurrentViewerIndex != viewerIndex) {
            this.fCurrentViewerIndex = viewerIndex;
            this.updateHierarchyViewer(true);
            if (this.fInputElement != null) {
                ISelection currSelection = this.getCurrentViewer().getSelection();
                if (currSelection == null || currSelection.isEmpty()) {
                    this.internalSelectType((IMember)this.getSelectableType(this.fInputElement), false);
                    currSelection = this.getCurrentViewer().getSelection();
                }
                if (!this.fIsEnableMemberFilter) {
                    this.typeSelectionChanged(currSelection);
                }
            }
            this.updateTitle();
            this.fDialogSettings.put(DIALOGSTORE_HIERARCHYVIEW, viewerIndex);
            this.getCurrentViewer().getTree().setFocus();
        }
        int i = 0;
        while (i < this.fViewActions.length) {
            ToggleViewAction action;
            action.setChecked(this.fCurrentViewerIndex == (action = this.fViewActions[i]).getViewerIndex());
            ++i;
        }
    }

    public int getViewIndex() {
        return this.fCurrentViewerIndex;
    }

    private TypeHierarchyViewer getCurrentViewer() {
        return this.fAllViewers[this.fCurrentViewerIndex];
    }

    public void enableMemberFilter(boolean on) {
        if (on != this.fIsEnableMemberFilter) {
            this.fIsEnableMemberFilter = on;
            if (!on) {
                IType methodViewerInput = (IType)this.fMethodsViewer.getInput();
                this.setMemberFilter(null);
                this.updateHierarchyViewer(true);
                this.updateTitle();
                if (methodViewerInput != null && this.getCurrentViewer().isElementShown(methodViewerInput)) {
                    this.internalSelectType((IMember)methodViewerInput, true);
                } else if (this.fSelectedType != null) {
                    this.internalSelectType((IMember)this.fSelectedType, true);
                    this.updateMethodViewer(this.fSelectedType);
                }
            } else {
                this.methodSelectionChanged(this.fMethodsViewer.getSelection());
            }
        }
        this.fEnableMemberFilterAction.setChecked(on);
    }

    public void showQualifiedTypeNames(boolean on) {
        if (this.fAllViewers == null) {
            return;
        }
        int i = 0;
        while (i < this.fAllViewers.length) {
            this.fAllViewers[i].setQualifiedTypeName(on);
            ++i;
        }
    }

    private boolean isShowQualifiedTypeNames() {
        return this.fShowQualifiedTypeNamesAction.isChecked();
    }

    protected void doTypeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchy, final IType[] changedTypes) {
        if (!this.fIsVisible) {
            this.fNeedRefresh = true;
            return;
        }
        if (this.fIsRefreshRunnablePosted) {
            return;
        }
        Display display = this.getDisplay();
        if (display != null) {
            this.fIsRefreshRunnablePosted = true;
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                            TypeHierarchyViewPart.this.doTypeHierarchyChangedOnViewers(changedTypes);
                        }
                    }
                    finally {
                        TypeHierarchyViewPart.this.fIsRefreshRunnablePosted = false;
                    }
                }
            });
        }
    }

    protected void doTypeHierarchyChangedOnViewers(IType[] changedTypes) {
        if (this.fHierarchyLifeCycle.getHierarchy() == null || !this.fHierarchyLifeCycle.getHierarchy().exists()) {
            this.clearInput();
        } else if (changedTypes == null) {
            try {
                this.fHierarchyLifeCycle.ensureRefreshedTypeHierarchy(this.fInputElement, (IRunnableContext)this.getSite().getWorkbenchWindow());
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), TypeHierarchyMessages.TypeHierarchyViewPart_exception_title, TypeHierarchyMessages.TypeHierarchyViewPart_exception_message);
                this.clearInput();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.fMethodsViewer.refresh();
            this.updateHierarchyViewer(false);
        } else {
            Object methodViewerInput = this.fMethodsViewer.getInput();
            this.fMethodsViewer.refresh();
            this.fMethodViewerPaneLabel.setText(this.fPaneLabelProvider.getText(methodViewerInput));
            this.fMethodViewerPaneLabel.setImage(this.fPaneLabelProvider.getImage(methodViewerInput));
            if (this.getCurrentViewer().isMethodFiltering()) {
                if (changedTypes.length == 1) {
                    this.getCurrentViewer().refresh(changedTypes[0]);
                } else {
                    this.updateHierarchyViewer(false);
                }
            } else {
                this.getCurrentViewer().update(changedTypes, new String[]{"org.eclipse.jface.text", "org.eclipse.jface.image"});
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
    }

    public void saveState(IMemento memento) {
        if (this.fPagebook == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        if (this.fInputElement != null) {
            String handleIndentifier = this.fInputElement.getHandleIdentifier();
            memento.putString(TAG_INPUT, handleIndentifier);
        }
        memento.putInteger(TAG_VIEW, this.getViewIndex());
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        int[] weigths = this.fTypeMethodsSplitter.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        ScrollBar bar = this.getCurrentViewer().getTree().getVerticalBar();
        int position = bar != null ? bar.getSelection() : 0;
        memento.putInteger(TAG_VERTICAL_SCROLL, position);
        IRubyElement selection = (IRubyElement)((IStructuredSelection)this.getCurrentViewer().getSelection()).getFirstElement();
        if (selection != null) {
            memento.putString(TAG_SELECTION, selection.getHandleIdentifier());
        }
        this.fWorkingSetActionGroup.saveState(memento);
        this.fMethodsViewer.saveState(memento);
        this.saveLinkingEnabled(memento);
    }

    private void saveLinkingEnabled(IMemento memento) {
        memento.putInteger("org.rubypeople.rdt.ui.packages.linktypehierarchytoeditor", this.fLinkingEnabled ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreState(final IMemento memento, IRubyElement defaultInput) {
        IRubyElement input = defaultInput;
        String elementId = memento.getString(TAG_INPUT);
        if (elementId != null && (input = RubyCore.create((String)elementId)) != null && !input.exists()) {
            input = null;
        }
        if (input == null) {
            this.doRestoreState(memento, input);
        } else {
            final IRubyElement hierarchyInput = input;
            TypeHierarchyViewPart typeHierarchyViewPart = this;
            synchronized (typeHierarchyViewPart) {
                String label = Messages.format((String)TypeHierarchyMessages.TypeHierarchyViewPart_restoreinput, (String)hierarchyInput.getElementName());
                this.fNoHierarchyShownLabel.setText(label);
                this.fRestoreStateJob = new Job(label){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            TypeHierarchyViewPart.this.doRestoreInBackground(memento, hierarchyInput, monitor);
                        }
                        catch (RubyModelException e) {
                            return e.getStatus();
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fRestoreStateJob.schedule();
            }
        }
    }

    private void doRestoreInBackground(final IMemento memento, final IRubyElement hierarchyInput, IProgressMonitor monitor) throws RubyModelException {
        this.fHierarchyLifeCycle.doHierarchyRefresh(hierarchyInput, monitor);
        if (!monitor.isCanceled()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (TypeHierarchyViewPart.this.fPagebook != null && !TypeHierarchyViewPart.this.fPagebook.isDisposed()) {
                        TypeHierarchyViewPart.this.doRestoreState(memento, hierarchyInput);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doRestoreState(IMemento memento, IRubyElement input) {
        Integer vScroll;
        ScrollBar bar;
        Integer orientation;
        TypeHierarchyViewPart typeHierarchyViewPart = this;
        synchronized (typeHierarchyViewPart) {
            if (this.fRestoreStateJob == null) {
                return;
            }
            this.fRestoreStateJob = null;
        }
        this.fWorkingSetActionGroup.restoreState(memento);
        this.setInputElement(input);
        Integer viewerIndex = memento.getInteger(TAG_VIEW);
        if (viewerIndex != null) {
            this.setView(viewerIndex);
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        this.updateCheckedState();
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fTypeMethodsSplitter.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((bar = this.getCurrentViewer().getTree().getVerticalBar()) != null && (vScroll = memento.getInteger(TAG_VERTICAL_SCROLL)) != null) {
            bar.setSelection(vScroll.intValue());
        }
        this.fMethodsViewer.restoreState(memento);
    }

    private void restoreLinkingEnabled(IMemento memento) {
        Integer val = memento.getInteger("org.rubypeople.rdt.ui.packages.linktypehierarchytoeditor");
        if (val != null) {
            this.fLinkingEnabled = val != 0;
        }
    }

    protected void visibilityChanged(boolean isVisible) {
        this.fIsVisible = isVisible;
        if (isVisible && this.fNeedRefresh) {
            this.doTypeHierarchyChangedOnViewers(null);
        }
        this.fNeedRefresh = false;
    }

    protected void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        if (this.fInputElement == null) {
            return;
        }
        IRubyElement elem = (IRubyElement)editor.getEditorInput().getAdapter(IRubyElement.class);
        IType type = null;
        if (elem instanceof IRubyScript) {
            type = ((IRubyScript)elem).findPrimaryType();
        }
        if (type != null) {
            this.internalSelectType((IMember)type, true);
            if (this.getCurrentViewer().getSelection().isEmpty()) {
                this.updateMethodViewer(null);
            } else {
                this.updateMethodViewer(type);
            }
        }
    }

    public Object getViewPartInput() {
        return this.fInputElement;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, TypeHierarchyViewPart.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        IEditorPart editor;
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("org.rubypeople.rdt.ui.packages.linktypehierarchytoeditor", enabled);
        if (enabled && (editor = this.getSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
    }

    public void clearNeededRefresh() {
        this.fNeedRefresh = false;
    }
}

