/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.util.LineBasedEditorOpener;

public class StackTraceLine {
    private static Pattern OPEN_TRACE_LINE_PATTERN = Pattern.compile("\\s*(\\S.*?):(\\d+)(:|$)");
    private static Pattern BRACKETED_TRACE_LINE_PATTERN = Pattern.compile("\\[(.*):(\\d+)\\]:");
    private static Pattern OPTIONAL_PREFIX = Pattern.compile("^[ \\t^]*from ");
    private String fFilename;
    private int fLineNumber;
    private int length;
    private int offset;

    public static boolean isTraceLine(String line) {
        Matcher bracketedMatcher = BRACKETED_TRACE_LINE_PATTERN.matcher(line);
        Matcher openMatcher = OPEN_TRACE_LINE_PATTERN.matcher(line);
        return bracketedMatcher.find() || openMatcher.find();
    }

    public StackTraceLine(String traceLine) {
        this(traceLine, (IProject)null);
    }

    public StackTraceLine(String traceLine, IRubyProject launchedProject) {
        this(traceLine, launchedProject.getProject());
    }

    public StackTraceLine(String traceLine, IProject launchedProject) {
        int prefix = 0;
        Matcher matcher = OPTIONAL_PREFIX.matcher(traceLine);
        if (matcher.find()) {
            traceLine = traceLine.substring(matcher.group(0).length());
            prefix = matcher.group(0).length();
        }
        if (!(matcher = BRACKETED_TRACE_LINE_PATTERN.matcher(traceLine)).find() && !(matcher = OPEN_TRACE_LINE_PATTERN.matcher(traceLine)).find()) {
            return;
        }
        this.fFilename = matcher.group(1);
        this.offset = matcher.start(1) + prefix;
        if (this.fFilename.startsWith("[")) {
            this.fFilename = this.fFilename.substring(1);
            ++this.offset;
        }
        String lineNumber = matcher.group(2);
        this.fLineNumber = Integer.parseInt(lineNumber);
        this.length = this.fFilename.length() + lineNumber.length() + 1;
        if (this.isRelativePath() && launchedProject != null) {
            this.makeRelativeToWorkspace(launchedProject);
        }
    }

    private void makeRelativeToWorkspace(IProject launchedProject) {
        this.fFilename = this.fFilename.startsWith("./") ? String.valueOf(launchedProject.getFullPath().toPortableString()) + this.fFilename.substring(1) : (this.fFilename.startsWith("/") ? String.valueOf(launchedProject.getFullPath().toPortableString()) + this.fFilename : String.valueOf(launchedProject.getFullPath().toPortableString()) + '/' + this.fFilename);
    }

    private boolean isRelativePath() {
        if (this.fFilename.startsWith("./")) {
            return true;
        }
        if (this.fFilename.startsWith("/")) {
            File file = new File(this.fFilename);
            return !file.exists();
        }
        if (this.fFilename.contains(":")) {
            return false;
        }
        return false;
    }

    public void openEditor() {
        if (this.fFilename == null) {
            return;
        }
        new LineBasedEditorOpener(this.fFilename, this.fLineNumber).open();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public String getFilename() {
        return this.fFilename;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }
}

