/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.viewsupport;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.ILocalVariable;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.packageview.LoadPathContainer;
import org.rubypeople.rdt.internal.ui.viewsupport.ColoredString;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.ui.RubyElementLabels;

public class ColoredRubyElementLabels {
    public static final ColoredString.Style QUALIFIER_STYLE = new ColoredString.Style("org.rubypeople.rdt.ui.ColoredLabels.qualifier");
    public static final ColoredString.Style COUNTER_STYLE = new ColoredString.Style("org.rubypeople.rdt.ui.ColoredLabels.counter");
    public static final ColoredString.Style DECORATIONS_STYLE;
    private static final ColoredString.Style APPENDED_TYPE_STYLE;
    public static final long COLORIZE = 0x80000000000000L;
    private static final long QUALIFIER_FLAGS = 0x1002000000000L;

    static {
        APPENDED_TYPE_STYLE = DECORATIONS_STYLE = new ColoredString.Style("org.rubypeople.rdt.ui.ColoredLabels.decorations");
    }

    private static final boolean getFlag(long flags, long flag) {
        return (flags & flag) != 0L;
    }

    public static ColoredString getTextLabel(Object obj, long flags) {
        if (obj instanceof IRubyElement) {
            return ColoredRubyElementLabels.getElementLabel((IRubyElement)obj, flags);
        }
        if (obj instanceof IResource) {
            return new ColoredString(((IResource)obj).getName());
        }
        if (obj instanceof LoadPathContainer) {
            LoadPathContainer container = (LoadPathContainer)obj;
            return ColoredRubyElementLabels.getContainerEntryLabel(container.getLoadpathEntry().getPath(), container.getRubyProject());
        }
        return new ColoredString(RubyElementLabels.getTextLabel(obj, flags));
    }

    public static ColoredString getElementLabel(IRubyElement element, long flags) {
        ColoredString result = new ColoredString();
        ColoredRubyElementLabels.getElementLabel(element, flags, result);
        return result;
    }

    public static void getElementLabel(IRubyElement element, long flags, ColoredString result) {
        int type = element.getElementType();
        ISourceFolderRoot root = null;
        if (type != 0 && type != 1 && type != 2) {
            root = RubyModelUtil.getSourceFolderRoot(element);
        }
        if (root != null && ColoredRubyElementLabels.getFlag(flags, 0x100000000000L)) {
            ColoredRubyElementLabels.getSourceFolderRootLabel(root, 0x20000000000L, result);
            result.append(RubyElementLabels.CONCAT_STRING);
        }
        switch (type) {
            case 6: {
                ColoredRubyElementLabels.getMethodLabel((IMethod)element, flags, result);
                break;
            }
            case 15: {
                ColoredRubyElementLabels.getFieldLabel((IField)element, flags, result);
                break;
            }
            case 12: {
                ColoredRubyElementLabels.getLocalVariableLabel((ILocalVariable)element, flags, result);
                break;
            }
            case 5: {
                ColoredRubyElementLabels.getTypeLabel((IType)element, flags, result);
                break;
            }
            case 4: {
                ColoredRubyElementLabels.getCompilationUnitLabel((IRubyScript)element, flags, result);
                break;
            }
            case 3: {
                ColoredRubyElementLabels.getSourceFolderLabel((ISourceFolder)element, flags, result);
                break;
            }
            case 2: {
                ColoredRubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)element, flags, result);
                break;
            }
            case 8: 
            case 16: {
                ColoredRubyElementLabels.getDeclarationLabel(element, flags, result);
                break;
            }
            case 0: 
            case 1: {
                result.append(element.getElementName());
                break;
            }
            default: {
                result.append(element.getElementName());
            }
        }
        if (root != null && ColoredRubyElementLabels.getFlag(flags, 0x80000000000L)) {
            int offset = result.length();
            result.append(RubyElementLabels.CONCAT_STRING);
            ColoredRubyElementLabels.getSourceFolderRootLabel(root, 0x20000000000L, result);
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getMethodLabel(IMethod method, long flags, ColoredString result) {
        try {
            if (ColoredRubyElementLabels.getFlag(flags, 128L)) {
                ColoredRubyElementLabels.getTypeLabel(method.getDeclaringType(), 0x80000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(method.getElementName());
            result.append('(');
            if (ColoredRubyElementLabels.getFlag(flags, 2L)) {
                int nParams = 0;
                String[] names = null;
                if (ColoredRubyElementLabels.getFlag(flags, 2L) && method.exists()) {
                    names = method.getParameterNames();
                    nParams = names.length;
                }
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        result.append(RubyElementLabels.COMMA_STRING);
                    }
                    if (names != null) {
                        result.append(names[i]);
                    }
                    ++i;
                }
            }
            result.append(')');
            if (ColoredRubyElementLabels.getFlag(flags, 0x4000000000000L) && method.exists()) {
                ColoredRubyElementLabels.getCategoryLabel((IMember)method, result);
            }
            if (ColoredRubyElementLabels.getFlag(flags, 256L)) {
                int offset = result.length();
                result.append(RubyElementLabels.CONCAT_STRING);
                ColoredRubyElementLabels.getTypeLabel(method.getDeclaringType(), 0x80000L | flags & 0x1002000000000L, result);
                if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    private static void getCategoryLabel(IMember member, ColoredString result) throws RubyModelException {
    }

    public static void getFieldLabel(IField field, long flags, ColoredString result) {
        try {
            if (ColoredRubyElementLabels.getFlag(flags, 65536L)) {
                ColoredRubyElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                result.append('.');
            }
            result.append(field.getElementName());
            if (ColoredRubyElementLabels.getFlag(flags, 0x2000000000000L) && field.exists()) {
                ColoredRubyElementLabels.getCategoryLabel((IMember)field, result);
            }
            if (ColoredRubyElementLabels.getFlag(flags, 131072L)) {
                int offset = result.length();
                result.append(RubyElementLabels.CONCAT_STRING);
                ColoredRubyElementLabels.getTypeLabel(field.getDeclaringType(), 0x40000L | flags & 0x1002000000000L, result);
                if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    public static void getLocalVariableLabel(ILocalVariable localVariable, long flags, ColoredString result) {
        if (ColoredRubyElementLabels.getFlag(flags, 65536L)) {
            ColoredRubyElementLabels.getElementLabel(localVariable.getParent(), 0x40080L | flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(localVariable.getElementName());
        if (ColoredRubyElementLabels.getFlag(flags, 131072L)) {
            result.append(RubyElementLabels.CONCAT_STRING);
            ColoredRubyElementLabels.getElementLabel(localVariable.getParent(), 0x40080L | flags & 0x1002000000000L, result);
        }
    }

    public static void getTypeLabel(IType type, long flags, ColoredString result) {
        String typeName;
        if (ColoredRubyElementLabels.getFlag(flags, 262144L)) {
            ISourceFolder folder = type.getSourceFolder();
            if (!folder.isDefaultPackage()) {
                ColoredRubyElementLabels.getSourceFolderLabel(folder, flags & 0x1002000000000L, result);
                result.append('/');
            }
            ColoredRubyElementLabels.getCompilationUnitLabel(type.getRubyScript(), flags & 0x1002000000000L, result);
            result.append(':');
        }
        if (ColoredRubyElementLabels.getFlag(flags, 786432L)) {
            int parentType;
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                ColoredRubyElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, result);
                result.append("::");
            }
            if ((parentType = type.getParent().getElementType()) == 6 || parentType == 15) {
                ColoredRubyElementLabels.getElementLabel(type.getParent(), 0L, result);
                result.append('.');
            }
        }
        if ((typeName = type.getElementName()).length() == 0) {
            try {
                String supertypeName = type.getSuperclassName();
                typeName = Messages.format((String)RubyUIMessages.RubyElementLabels_anonym_type, (String)supertypeName);
            }
            catch (RubyModelException rubyModelException) {
                typeName = RubyUIMessages.RubyElementLabels_anonym;
            }
        }
        result.append(typeName);
        if (ColoredRubyElementLabels.getFlag(flags, 0x8000000000000L) && type.exists()) {
            try {
                ColoredRubyElementLabels.getCategoryLabel((IMember)type, result);
            }
            catch (RubyModelException rubyModelException) {}
        }
        if (ColoredRubyElementLabels.getFlag(flags, 0x100000L)) {
            int offset = result.length();
            result.append(RubyElementLabels.CONCAT_STRING);
            IType declaringType = type.getDeclaringType();
            if (declaringType != null) {
                ISourceFolder folder;
                ColoredRubyElementLabels.getTypeLabel(declaringType, 0x80000L | flags & 0x1002000000000L, result);
                int parentType = type.getParent().getElementType();
                if (parentType == 6 || parentType == 15) {
                    result.append('.');
                    ColoredRubyElementLabels.getElementLabel(type.getParent(), 0L, result);
                }
                if (!(folder = type.getSourceFolder()).isDefaultPackage()) {
                    ColoredRubyElementLabels.getSourceFolderLabel(folder, flags & 0x1002000000000L, result);
                    result.append('/');
                }
                ColoredRubyElementLabels.getCompilationUnitLabel(type.getRubyScript(), flags & 0x1002000000000L, result);
                try {
                    int other = type.getNameRange().getOffset();
                    result.append(", offset: " + other);
                }
                catch (RubyModelException e) {
                    RubyPlugin.log(e);
                }
            } else {
                ColoredRubyElementLabels.getSourceFolderLabel(type.getSourceFolder(), flags & 0x1002000000000L, result);
            }
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getDeclarationLabel(IRubyElement declaration, long flags, ColoredString result) {
        IRubyElement openable;
        if (ColoredRubyElementLabels.getFlag(flags, 0x1000000L) && (openable = (IRubyElement)declaration.getOpenable()) != null) {
            result.append(ColoredRubyElementLabels.getElementLabel(openable, 0x88000000L | flags & 0x1002000000000L));
            result.append('/');
        }
        if (declaration.getElementType() == 16) {
            result.append(RubyUIMessages.RubyElementLabels_import_container);
        } else {
            result.append(declaration.getElementName());
        }
        if (ColoredRubyElementLabels.getFlag(flags, 0x2000000L)) {
            int offset = result.length();
            IRubyElement openable2 = (IRubyElement)declaration.getOpenable();
            if (openable2 != null) {
                result.append(RubyElementLabels.CONCAT_STRING);
                result.append(ColoredRubyElementLabels.getElementLabel(openable2, 0x88000000L | flags & 0x1002000000000L));
            }
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getCompilationUnitLabel(IRubyScript cu, long flags, ColoredString result) {
        ISourceFolder pack;
        if (ColoredRubyElementLabels.getFlag(flags, 0x80000000L) && !(pack = (ISourceFolder)cu.getParent()).isDefaultPackage()) {
            ColoredRubyElementLabels.getSourceFolderLabel(pack, flags & 0x1002000000000L, result);
            result.append('.');
        }
        result.append(cu.getElementName());
        if (ColoredRubyElementLabels.getFlag(flags, 0x100000000L)) {
            int offset = result.length();
            result.append(RubyElementLabels.CONCAT_STRING);
            ColoredRubyElementLabels.getSourceFolderLabel((ISourceFolder)cu.getParent(), flags & 0x1002000000000L, result);
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getSourceFolderLabel(ISourceFolder pack, long flags, ColoredString result) {
        if (ColoredRubyElementLabels.getFlag(flags, 0x800000000L)) {
            ColoredRubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)pack.getParent(), 0x20000000000L, result);
            result.append('/');
        }
        if (pack.isDefaultPackage()) {
            result.append(RubyElementLabels.DEFAULT_PACKAGE);
        } else if (ColoredRubyElementLabels.getFlag(flags, 0x2000000000L)) {
            StringBuffer buf = new StringBuffer();
            RubyElementLabels.getSourceFolderLabel(pack, 0x2000000000L, buf);
            result.append(buf.toString());
        } else {
            result.append(pack.getElementName());
        }
        if (ColoredRubyElementLabels.getFlag(flags, 0x1000000000L)) {
            int offset = result.length();
            result.append(RubyElementLabels.CONCAT_STRING);
            ColoredRubyElementLabels.getSourceFolderRootLabel((ISourceFolderRoot)pack.getParent(), 0x20000000000L, result);
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    public static void getSourceFolderRootLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        if (root.isArchive()) {
            ColoredRubyElementLabels.getArchiveLabel(root, flags, result);
        } else {
            ColoredRubyElementLabels.getFolderLabel(root, flags, result);
        }
    }

    private static void getArchiveLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        if (ColoredRubyElementLabels.getFlag(flags, 0x10000000000L) && ColoredRubyElementLabels.getVariableLabel(root, flags, result)) {
            return;
        }
        boolean external = root.isExternal();
        if (external) {
            ColoredRubyElementLabels.getExternalArchiveLabel(root, flags, result);
        } else {
            ColoredRubyElementLabels.getInternalArchiveLabel(root, flags, result);
        }
    }

    private static boolean getVariableLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        try {
            ILoadpathEntry rawEntry = root.getRawLoadpathEntry();
            if (rawEntry != null && rawEntry.getEntryKind() == 4) {
                IPath path = rawEntry.getPath().makeRelative();
                int offset = result.length();
                if (ColoredRubyElementLabels.getFlag(flags, 0x200000000000L)) {
                    int segements = path.segmentCount();
                    if (segements > 0) {
                        result.append(path.segment(segements - 1));
                        if (segements > 1) {
                            result.append(RubyElementLabels.CONCAT_STRING);
                            result.append(path.removeLastSegments(1).toOSString());
                        }
                    } else {
                        result.append(path.toString());
                    }
                } else {
                    result.append(path.toString());
                }
                result.append(RubyElementLabels.CONCAT_STRING);
                if (root.isExternal()) {
                    result.append(root.getPath().toOSString());
                } else {
                    result.append(root.getPath().makeRelative().toString());
                }
                if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
                return true;
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
        return false;
    }

    private static void getExternalArchiveLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        IPath path = root.getPath();
        if (ColoredRubyElementLabels.getFlag(flags, 0x200000000000L)) {
            int segements = path.segmentCount();
            if (segements > 0) {
                result.append(path.segment(segements - 1));
                int offset = result.length();
                if (segements > 1 || path.getDevice() != null) {
                    result.append(RubyElementLabels.CONCAT_STRING);
                    result.append(path.removeLastSegments(1).toOSString());
                }
                if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                    result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
                }
            } else {
                result.append(path.toOSString());
            }
        } else {
            result.append(path.toOSString());
        }
    }

    private static void getInternalArchiveLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ColoredRubyElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ColoredRubyElementLabels.getFlag(flags, 0x200000000000L) && ColoredRubyElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            result.append(root.getElementName());
            int offset = result.length();
            if (referencedQualified) {
                result.append(RubyElementLabels.CONCAT_STRING);
                result.append(resource.getParent().getFullPath().makeRelative().toString());
            } else if (ColoredRubyElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(RubyElementLabels.CONCAT_STRING);
                result.append(root.getParent().getPath().makeRelative().toString());
            } else {
                return;
            }
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static void getFolderLabel(ISourceFolderRoot root, long flags, ColoredString result) {
        boolean referencedQualified;
        IResource resource = root.getResource();
        boolean rootQualified = ColoredRubyElementLabels.getFlag(flags, 0x20000000000L);
        boolean bl = referencedQualified = ColoredRubyElementLabels.getFlag(flags, 0x200000000000L) && ColoredRubyElementLabels.isReferenced(root);
        if (rootQualified) {
            result.append(root.getPath().makeRelative().toString());
        } else {
            if (resource != null) {
                IPath projectRelativePath = resource.getProjectRelativePath();
                if (projectRelativePath.segmentCount() == 0) {
                    result.append(resource.getName());
                    referencedQualified = false;
                } else {
                    result.append(projectRelativePath.toString());
                }
            } else {
                result.append(root.getElementName());
            }
            int offset = result.length();
            if (referencedQualified) {
                result.append(RubyElementLabels.CONCAT_STRING);
                result.append(resource.getProject().getName());
            } else if (ColoredRubyElementLabels.getFlag(flags, 0x40000000000L)) {
                result.append(RubyElementLabels.CONCAT_STRING);
                result.append(root.getParent().getElementName());
            } else {
                return;
            }
            if (ColoredRubyElementLabels.getFlag(flags, 0x80000000000000L)) {
                result.colorize(offset, result.length() - offset, QUALIFIER_STYLE);
            }
        }
    }

    private static boolean isReferenced(ISourceFolderRoot root) {
        IResource resource = root.getResource();
        if (resource != null) {
            IProject jarProject = resource.getProject();
            IProject container = root.getRubyProject().getProject();
            return !container.equals((Object)jarProject);
        }
        return false;
    }

    public static ColoredString getContainerEntryLabel(IPath containerPath, IRubyProject project) {
        try {
            LoadpathContainerInitializer initializer;
            ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)containerPath, (IRubyProject)project);
            String description = null;
            if (container != null) {
                description = container.getDescription();
            }
            if (description == null && (initializer = RubyCore.getLoadpathContainerInitializer((String)containerPath.segment(0))) != null) {
                description = initializer.getDescription(containerPath, project);
            }
            if (description != null) {
                int index;
                ColoredString str = new ColoredString(description);
                if (containerPath.segmentCount() > 0 && RubyRuntime.RUBY_CONTAINER.equals(containerPath.segment(0)) && (index = description.indexOf(91)) != -1) {
                    str.colorize(index, description.length() - index, DECORATIONS_STYLE);
                }
                return str;
            }
        }
        catch (RubyModelException rubyModelException) {}
        return new ColoredString(containerPath.toString());
    }

    public static ColoredString decorateColoredString(ColoredString string, String decorated, ColoredString.Style color) {
        String label = string.getString();
        int originalStart = decorated.indexOf(label);
        if (originalStart == -1) {
            return new ColoredString(decorated);
        }
        if (originalStart > 0) {
            ColoredString newString = new ColoredString(decorated.substring(0, originalStart), color);
            newString.append(string);
            string = newString;
        }
        if (decorated.length() > originalStart + label.length()) {
            return string.append(decorated.substring(originalStart + label.length()), color);
        }
        return string;
    }
}

