/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.corext.util.TypeInfo;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.ui.wizards.NewTypeWizardPage;

public class SuperModuleSelectionDialog
extends TypeSelectionDialog2 {
    private static final int ADD_ID = 1025;
    private NewTypeWizardPage fTypeWizardPage;
    private List fOldContent;

    public SuperModuleSelectionDialog(Shell parent, IRunnableContext context, NewTypeWizardPage page, IRubyProject p) {
        super(parent, true, context, SuperModuleSelectionDialog.createSearchScope(p), 5);
        this.fTypeWizardPage = page;
        this.fOldContent = this.fTypeWizardPage.getSuperModules();
        this.setStatusLineAboveButtons(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewWizardMessages.SuperModuleSelectionDialog_addButton_label, true);
        super.createButtonsForButtonBar(parent);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return RubyPlugin.getDefault().getDialogSettingsSection("DialogBounds_SuperModuleSelectionDialog");
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        Button addButton = this.getButton(1025);
        if (addButton != null && !addButton.isDisposed()) {
            addButton.setEnabled(!status.matches(4));
        }
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.fTypeWizardPage.setSuperModules(this.fOldContent, true);
    }

    protected void cancelPressed() {
        this.fTypeWizardPage.setSuperModules(this.fOldContent, true);
        super.cancelPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addSelectedInterface();
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addSelectedInterface();
        super.okPressed();
    }

    private void addSelectedInterface() {
        TypeInfo[] selection = this.getSelectedTypes();
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            TypeInfo type = selection[i];
            String qualifiedName = type.getFullyQualifiedName();
            String message = this.fTypeWizardPage.addSuperModule(qualifiedName) ? Messages.format(NewWizardMessages.SuperModuleSelectionDialog_interfaceadded_info, qualifiedName) : Messages.format(NewWizardMessages.SuperModuleSelectionDialog_interfacealreadyadded_info, qualifiedName);
            this.updateStatus(new StatusInfo(1, message));
            ++i;
        }
    }

    private static IRubySearchScope createSearchScope(IRubyProject p) {
        return SearchEngine.createRubySearchScope((IRubyElement[])new IRubyProject[]{p});
    }

    protected void handleDefaultSelected(TypeInfo[] selection) {
        if (selection.length > 0) {
            this.buttonPressed(1025);
        }
    }

    protected void handleWidgetSelected(TypeInfo[] selection) {
        super.handleWidgetSelected(selection);
        this.getButton(1025).setEnabled(selection.length > 0);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.rubypeople.rdt.ui.super_interface_selection_dialog_context");
    }
}

