/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.NewElementWizard;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathsBlock;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;

public abstract class BuildPathWizard
extends NewElementWizard {
    private boolean fDoFlushChange;
    private final CPListElement fEntryToEdit;
    private ISourceFolderRoot fSourceFolderRoot;
    private final ArrayList fExistingEntries;

    public BuildPathWizard(CPListElement[] existingEntries, CPListElement newEntry, String titel, ImageDescriptor image) {
        if (image != null) {
            this.setDefaultPageImageDescriptor(image);
        }
        this.setDialogSettings(RubyPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(titel);
        this.fEntryToEdit = newEntry;
        this.fExistingEntries = new ArrayList(Arrays.asList(existingEntries));
        this.fDoFlushChange = true;
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (this.fDoFlushChange) {
            IRubyProject rubyProject = this.getEntryToEdit().getRubyProject();
            BuildPathsBlock.flush(this.getExistingEntries(), rubyProject, monitor);
            IProject project = rubyProject.getProject();
            IPath projPath = project.getFullPath();
            IPath path = this.getEntryToEdit().getPath();
            if (!projPath.equals((Object)path) && projPath.isPrefixOf(path)) {
                path = path.removeFirstSegments(projPath.segmentCount());
            }
            IFolder folder = project.getFolder(path);
            this.fSourceFolderRoot = rubyProject.getSourceFolderRoot((IResource)folder);
        }
    }

    public IRubyElement getCreatedElement() {
        return this.fSourceFolderRoot;
    }

    public void setDoFlushChange(boolean b) {
        this.fDoFlushChange = b;
    }

    public ArrayList getExistingEntries() {
        return this.fExistingEntries;
    }

    protected CPListElement getEntryToEdit() {
        return this.fEntryToEdit;
    }

    public List getInsertedElements() {
        return new ArrayList();
    }

    public List getRemovedElements() {
        return new ArrayList();
    }

    public List getModifiedElements() {
        ArrayList<CPListElement> result = new ArrayList<CPListElement>(1);
        result.add(this.fEntryToEdit);
        return result;
    }

    public abstract void cancel();
}

