/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.rubypeople.rdt.core.ILoadpathAttribute;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.util.RubyModelUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.launching.RubyRuntime;

public class CPListElement {
    public static final String EXCLUSION = "exclusion";
    public static final String INCLUSION = "inclusion";
    private IRubyProject fProject;
    private int fEntryKind;
    private IPath fPath;
    private IPath fOrginalPath;
    private IResource fResource;
    private boolean fIsExported;
    private boolean fIsMissing;
    private Object fParentContainer;
    private ILoadpathEntry fCachedEntry;
    private ArrayList fChildren;
    private IPath fLinkTarget;
    private IPath fOrginalLinkTarget;

    public CPListElement(IRubyProject project, int entryKind, IPath path, IResource res) {
        this(null, project, entryKind, path, res);
    }

    public CPListElement(Object parent, IRubyProject project, int entryKind, IPath path, IResource res) {
        this(parent, project, entryKind, path, res, null);
    }

    public CPListElement(IRubyProject project, int entryKind) {
        this(null, project, entryKind, null, null);
    }

    public CPListElement(Object parent, IRubyProject project, int entryKind, IPath path, IResource res, IPath linkTarget) {
        this.fProject = project;
        this.fEntryKind = entryKind;
        this.fPath = path;
        this.fOrginalPath = path;
        this.fLinkTarget = linkTarget;
        this.fOrginalLinkTarget = linkTarget;
        this.fChildren = new ArrayList();
        this.fResource = res;
        this.fIsExported = false;
        this.fIsMissing = false;
        this.fCachedEntry = null;
        this.fParentContainer = parent;
        switch (entryKind) {
            case 3: {
                this.createAttributeElement(INCLUSION, new Path[0], true);
                this.createAttributeElement(EXCLUSION, new Path[0], true);
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                break;
            }
            case 5: {
                try {
                    ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)this.fPath, (IRubyProject)this.fProject);
                    if (container == null) break;
                    ILoadpathEntry[] entries = container.getLoadpathEntries();
                    int i = 0;
                    while (i < entries.length) {
                        ILoadpathEntry entry = entries[i];
                        if (entry != null) {
                            CPListElement curr = CPListElement.createFromExisting(this, entry, this.fProject);
                            this.fChildren.add(curr);
                        } else {
                            RubyPlugin.logErrorMessage("Null entry in container '" + this.fPath + "'");
                        }
                        ++i;
                    }
                    break;
                }
                catch (RubyModelException rubyModelException) {}
            }
        }
    }

    public ILoadpathEntry getLoadpathEntry() {
        if (this.fCachedEntry == null) {
            this.fCachedEntry = this.newLoadpathEntry();
        }
        return this.fCachedEntry;
    }

    private ILoadpathAttribute[] getLoadpathAttributes() {
        ArrayList<ILoadpathAttribute> res = new ArrayList<ILoadpathAttribute>();
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && !(elem = (CPListElementAttribute)curr).isBuiltIn() && elem.getValue() != null) {
                res.add(elem.newLoadpathAttribute());
            }
            ++i;
        }
        return res.toArray(new ILoadpathAttribute[res.size()]);
    }

    private ILoadpathEntry newLoadpathEntry() {
        ILoadpathAttribute[] extraAttributes = this.getLoadpathAttributes();
        switch (this.fEntryKind) {
            case 3: {
                IPath[] inclusionPattern = (IPath[])this.getAttribute(INCLUSION);
                IPath[] exclusionPattern = (IPath[])this.getAttribute(EXCLUSION);
                return RubyCore.newSourceEntry((IPath)this.fPath, (IPath[])inclusionPattern, (IPath[])exclusionPattern, (ILoadpathAttribute[])extraAttributes);
            }
            case 1: {
                return RubyCore.newLibraryEntry((IPath)this.fPath, (ILoadpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 2: {
                return RubyCore.newProjectEntry((IPath)this.fPath, (ILoadpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 5: {
                return RubyCore.newContainerEntry((IPath)this.fPath, (ILoadpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
            case 4: {
                return RubyCore.newVariableEntry((IPath)this.fPath, (ILoadpathAttribute[])extraAttributes, (boolean)this.isExported());
            }
        }
        return null;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public int getEntryKind() {
        return this.fEntryKind;
    }

    public IResource getResource() {
        return this.fResource;
    }

    public CPListElementAttribute setAttribute(String key, Object value) {
        CPListElementAttribute attribute = this.findAttributeElement(key);
        if (attribute == null) {
            return null;
        }
        if (key.equals(EXCLUSION) || key.equals(INCLUSION)) {
            Assert.isTrue((value != null || this.fEntryKind != 3 ? 1 : 0) != 0);
        }
        attribute.setValue(value);
        this.attributeChanged(key);
        return attribute;
    }

    public boolean addToExclusions(IPath path) {
        String key = EXCLUSION;
        return this.addFilter(path, key);
    }

    public boolean addToInclusion(IPath path) {
        String key = INCLUSION;
        return this.addFilter(path, key);
    }

    public boolean removeFromExclusions(IPath path) {
        String key = EXCLUSION;
        return this.removeFilter(path, key);
    }

    public boolean removeFromInclusion(IPath path) {
        String key = INCLUSION;
        return this.removeFilter(path, key);
    }

    private boolean addFilter(IPath path, String key) {
        IPath[] exclusionFilters = (IPath[])this.getAttribute(key);
        if (!RubyModelUtil.isExcludedPath(path, exclusionFilters)) {
            IPath pathToExclude = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
            IPath[] newExclusionFilters = new IPath[exclusionFilters.length + 1];
            System.arraycopy(exclusionFilters, 0, newExclusionFilters, 0, exclusionFilters.length);
            newExclusionFilters[exclusionFilters.length] = pathToExclude;
            this.setAttribute(key, newExclusionFilters);
            return true;
        }
        return false;
    }

    private boolean removeFilter(IPath path, String key) {
        IPath[] exclusionFilters = (IPath[])this.getAttribute(key);
        IPath pathToExclude = path.removeFirstSegments(this.getPath().segmentCount()).addTrailingSeparator();
        if (RubyModelUtil.isExcludedPath(pathToExclude, exclusionFilters)) {
            ArrayList l = new ArrayList(Arrays.asList(exclusionFilters));
            l.remove(pathToExclude);
            IPath[] newExclusionFilters = l.toArray(new IPath[l.size()]);
            this.setAttribute(key, newExclusionFilters);
            return true;
        }
        return false;
    }

    public CPListElementAttribute findAttributeElement(String key) {
        int i = 0;
        while (i < this.fChildren.size()) {
            CPListElementAttribute elem;
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute && key.equals((elem = (CPListElementAttribute)curr).getKey())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public Object getAttribute(String key) {
        CPListElementAttribute attrib = this.findAttributeElement(key);
        if (attrib != null) {
            return attrib.getValue();
        }
        return null;
    }

    private void createAttributeElement(String key, Object value, boolean builtIn) {
        this.fChildren.add(new CPListElementAttribute(this, key, value, builtIn));
    }

    private static boolean isFiltered(Object entry, String[] filteredKeys) {
        if (entry instanceof CPListElementAttribute) {
            String key = ((CPListElementAttribute)entry).getKey();
            int i = 0;
            while (i < filteredKeys.length) {
                if (key.equals(filteredKeys[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private Object[] getFilteredChildren(String[] filteredKeys) {
        int nChildren = this.fChildren.size();
        ArrayList res = new ArrayList(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object curr = this.fChildren.get(i);
            if (!CPListElement.isFiltered(curr, filteredKeys)) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray();
    }

    public Object[] getChildren(boolean hideOutputFolder) {
        Path jreContainerPath;
        if (hideOutputFolder && this.fEntryKind == 3) {
            return this.getFilteredChildren(new String[0]);
        }
        if (this.fParentContainer instanceof CPListElement && (jreContainerPath = new Path(RubyRuntime.RUBY_CONTAINER)).isPrefixOf(((CPListElement)this.fParentContainer).getPath())) {
            return this.getFilteredChildren(new String[0]);
        }
        if (this.fEntryKind == 2) {
            return this.getFilteredChildren(new String[0]);
        }
        return this.fChildren.toArray();
    }

    public Object getParentContainer() {
        return this.fParentContainer;
    }

    private void attributeChanged(String key) {
        this.fCachedEntry = null;
    }

    private boolean canUpdateContainer() {
        if (this.fEntryKind == 5 && this.fProject != null) {
            LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)this.fPath.segment(0));
            return initializer != null && initializer.canUpdateLoadpathContainer(this.fPath, this.fProject);
        }
        return false;
    }

    public boolean isInNonModifiableContainer() {
        if (this.fParentContainer instanceof CPListElement) {
            return !((CPListElement)this.fParentContainer).canUpdateContainer();
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPListElement elem = (CPListElement)other;
            return this.getLoadpathEntry().equals(elem.getLoadpathEntry());
        }
        return false;
    }

    public int hashCode() {
        return this.fPath.hashCode() + this.fEntryKind;
    }

    public String toString() {
        return this.getLoadpathEntry().toString();
    }

    public boolean isMissing() {
        return this.fIsMissing;
    }

    public void setIsMissing(boolean isMissing) {
        this.fIsMissing = isMissing;
    }

    public boolean isExported() {
        return this.fIsExported;
    }

    public void setExported(boolean isExported) {
        if (isExported != this.fIsExported) {
            this.fIsExported = isExported;
            this.attributeChanged(null);
        }
    }

    public IRubyProject getRubyProject() {
        return this.fProject;
    }

    public static CPListElement createFromExisting(ILoadpathEntry curr, IRubyProject project) {
        return CPListElement.createFromExisting(null, curr, project);
    }

    public static CPListElement createFromExisting(Object parent, ILoadpathEntry curr, IRubyProject project) {
        IPath path = curr.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = null;
        boolean isMissing = false;
        IPath linkTarget = null;
        switch (curr.getEntryKind()) {
            case 5: {
                res = null;
                try {
                    isMissing = project != null && RubyCore.getLoadpathContainer((IPath)path, (IRubyProject)project) == null;
                }
                catch (RubyModelException rubyModelException) {
                    isMissing = true;
                }
                break;
            }
            case 4: {
                IPath resolvedPath = RubyCore.getResolvedVariablePath((IPath)path);
                res = null;
                if (resolvedPath == null) {
                    isMissing = true;
                    break;
                }
                isMissing = !resolvedPath.toFile().isDirectory();
                break;
            }
            case 1: {
                res = root.findMember(path);
                if (res == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK() && root.getProject(path.segment(0)).exists()) {
                        res = root.getFolder(path);
                    }
                    isMissing = !path.toFile().isDirectory();
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 3: {
                path = path.removeTrailingSeparator();
                res = root.findMember(path);
                if (res == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        res = root.getFolder(path);
                    }
                    isMissing = true;
                    break;
                }
                if (!res.isLinked()) break;
                linkTarget = res.getLocation();
                break;
            }
            case 2: {
                res = root.findMember(path);
                isMissing = res == null;
            }
        }
        CPListElement elem = new CPListElement(parent, project, curr.getEntryKind(), path, res, linkTarget);
        elem.setExported(curr.isExported());
        elem.setAttribute(EXCLUSION, curr.getExclusionPatterns());
        elem.setAttribute(INCLUSION, curr.getInclusionPatterns());
        ILoadpathAttribute[] extraAttributes = curr.getExtraAttributes();
        int i = 0;
        while (i < extraAttributes.length) {
            ILoadpathAttribute attrib = extraAttributes[i];
            elem.setAttribute(attrib.getName(), attrib.getValue());
            ++i;
        }
        if (project != null && project.exists()) {
            elem.setIsMissing(isMissing);
        }
        return elem;
    }

    public static StringBuffer appendEncodePath(IPath path, StringBuffer buf) {
        if (path != null) {
            String str = path.toString();
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedString(String str, StringBuffer buf) {
        if (str != null) {
            buf.append('[').append(str.length()).append(']').append(str);
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public static StringBuffer appendEncodedFilter(IPath[] filters, StringBuffer buf) {
        if (filters != null) {
            buf.append('[').append(filters.length).append(']');
            int i = 0;
            while (i < filters.length) {
                CPListElement.appendEncodePath(filters[i], buf).append(';');
                ++i;
            }
        } else {
            buf.append('[').append(']');
        }
        return buf;
    }

    public StringBuffer appendEncodedSettings(StringBuffer buf) {
        buf.append(this.fEntryKind).append(';');
        if (this.getLinkTarget() == null) {
            CPListElement.appendEncodePath(this.fPath, buf).append(';');
        } else {
            CPListElement.appendEncodePath(this.fPath, buf).append('-').append('>');
            CPListElement.appendEncodePath(this.getLinkTarget(), buf).append(';');
        }
        buf.append((Object)this.fIsExported).append(';');
        int i = 0;
        while (i < this.fChildren.size()) {
            Object curr = this.fChildren.get(i);
            if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute elem = (CPListElementAttribute)curr;
                if (elem.isBuiltIn()) {
                    String key = elem.getKey();
                    if (EXCLUSION.equals(key) || INCLUSION.equals(key)) {
                        CPListElement.appendEncodedFilter((IPath[])elem.getValue(), buf).append(';');
                    }
                } else {
                    CPListElement.appendEncodedString((String)elem.getValue(), buf);
                }
            }
            ++i;
        }
        return buf;
    }

    public IPath getLinkTarget() {
        return this.fLinkTarget;
    }

    public void setPath(IPath path) {
        this.fCachedEntry = null;
        this.fPath = path;
    }

    public void setLinkTarget(IPath linkTarget) {
        this.fCachedEntry = null;
        this.fLinkTarget = linkTarget;
    }

    public static void insert(CPListElement element, List cpList) {
        int length = cpList.size();
        CPListElement[] elements = cpList.toArray(new CPListElement[length]);
        int i = 0;
        while (i < length && elements[i].getEntryKind() != element.getEntryKind()) {
            ++i;
        }
        if (i < length) {
            ++i;
            while (i < length && elements[i].getEntryKind() == element.getEntryKind()) {
                ++i;
            }
            cpList.add(i, element);
            return;
        }
        switch (element.getEntryKind()) {
            case 3: {
                cpList.add(0, element);
                break;
            }
            default: {
                cpList.add(element);
            }
        }
    }

    public static ILoadpathEntry[] convertToLoadpathEntries(List cpList) {
        ILoadpathEntry[] result = new ILoadpathEntry[cpList.size()];
        int i = 0;
        for (CPListElement cur : cpList) {
            result[i] = cur.getLoadpathEntry();
            ++i;
        }
        return result;
    }

    public static CPListElement[] createFromExisting(IRubyProject project) throws RubyModelException {
        ILoadpathEntry[] rawLoadpath = project.getRawLoadpath();
        CPListElement[] result = new CPListElement[rawLoadpath.length];
        int i = 0;
        while (i < rawLoadpath.length) {
            result[i] = CPListElement.createFromExisting(rawLoadpath[i], project);
            ++i;
        }
        return result;
    }

    public static boolean isProjectSourceFolder(CPListElement[] existing, IRubyProject project) {
        IPath projPath = project.getProject().getFullPath();
        int i = 0;
        while (i < existing.length) {
            ILoadpathEntry curr = existing[i].getLoadpathEntry();
            if (curr.getEntryKind() == 3 && projPath.equals((Object)curr.getPath())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IPath getOrginalPath() {
        return this.fOrginalPath;
    }

    public IPath getOrginalLinkTarget() {
        return this.fOrginalLinkTarget;
    }
}

