/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.rubypeople.rdt.core.ILoadpathContainer;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.LoadpathContainerInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyElementImageProvider;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.rubypeople.rdt.ui.ISharedImages;
import org.rubypeople.rdt.ui.RubyElementImageDescriptor;
import org.rubypeople.rdt.ui.RubyElementLabels;
import org.rubypeople.rdt.ui.RubyUI;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

public class CPListLabelProvider
extends LabelProvider {
    private String fNewLabel = NewWizardMessages.CPListLabelProvider_new;
    private String fClassLabel = NewWizardMessages.CPListLabelProvider_classcontainer;
    private String fCreateLabel = NewWizardMessages.CPListLabelProvider_willbecreated;
    private ImageDescriptorRegistry fRegistry = RubyPlugin.getImageDescriptorRegistry();
    private ISharedImages fSharedImages = RubyUI.getSharedImages();
    private ImageDescriptor fProjectImage;

    public CPListLabelProvider() {
        IWorkbench workbench = RubyPlugin.getDefault().getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public String getText(Object element) {
        if (element instanceof CPListElement) {
            return this.getCPListElementText((CPListElement)element);
        }
        if (element instanceof CPListElementAttribute) {
            CPListElementAttribute attribute = (CPListElementAttribute)element;
            String text = this.getCPListElementAttributeText(attribute);
            if (attribute.isInNonModifiableContainer()) {
                return Messages.format((String)NewWizardMessages.CPListLabelProvider_non_modifiable_attribute, (String)text);
            }
            return text;
        }
        if (element instanceof CPUserLibraryElement) {
            return this.getCPUserLibraryText((CPUserLibraryElement)element);
        }
        return super.getText(element);
    }

    public String getCPUserLibraryText(CPUserLibraryElement element) {
        String name = element.getName();
        if (element.isSystemLibrary()) {
            name = Messages.format((String)NewWizardMessages.CPListLabelProvider_systemlibrary, (String)name);
        }
        return name;
    }

    public String getCPListElementAttributeText(CPListElementAttribute attrib) {
        String notAvailable = NewWizardMessages.CPListLabelProvider_none;
        String key = attrib.getKey();
        if (key.equals("exclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_exclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = notAvailable;
            }
            return Messages.format((String)NewWizardMessages.CPListLabelProvider_exclusion_filter_label, (Object[])new String[]{arg});
        }
        if (key.equals("inclusion")) {
            String arg = null;
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int patternsCount = 0;
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < patterns.length) {
                    String pattern = patterns[i].toString();
                    if (pattern.length() > 0) {
                        if (patternsCount > 0) {
                            buf.append(NewWizardMessages.CPListLabelProvider_inclusion_filter_separator);
                        }
                        buf.append(pattern);
                        ++patternsCount;
                    }
                    ++i;
                }
                arg = patternsCount > 0 ? buf.toString() : notAvailable;
            } else {
                arg = NewWizardMessages.CPListLabelProvider_all;
            }
            return Messages.format((String)NewWizardMessages.CPListLabelProvider_inclusion_filter_label, (Object[])new String[]{arg});
        }
        return notAvailable;
    }

    public String getCPListElementText(CPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                    IPath linkTarget = cpentry.getLinkTarget();
                    if (linkTarget != null) {
                        buf.append(RubyElementLabels.CONCAT_STRING);
                        buf.append(linkTarget.toOSString());
                    }
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fCreateLabel);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                return path.makeRelative().toString();
            }
            case 4: {
                return this.getVariableString(path);
            }
            case 2: {
                return path.lastSegment();
            }
            case 5: {
                try {
                    ILoadpathContainer container = RubyCore.getLoadpathContainer((IPath)path, (IRubyProject)cpentry.getRubyProject());
                    if (container != null) {
                        return container.getDescription();
                    }
                    LoadpathContainerInitializer initializer = RubyCore.getLoadpathContainerInitializer((String)path.segment(0));
                    if (initializer != null) {
                        String description = initializer.getDescription(path, cpentry.getRubyProject());
                        return Messages.format((String)NewWizardMessages.CPListLabelProvider_unbound_library, (String)description);
                    }
                }
                catch (RubyModelException rubyModelException) {}
                return path.toString();
            }
            case 3: {
                IResource resource;
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IPath linkTarget = cpentry.getLinkTarget();
                if (linkTarget != null) {
                    buf.append(RubyElementLabels.CONCAT_STRING);
                    buf.append(linkTarget.toOSString());
                }
                if ((resource = cpentry.getResource()) != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                } else if (cpentry.getOrginalPath() == null) {
                    buf.append(' ');
                    buf.append(this.fNewLabel);
                }
                return buf.toString();
            }
        }
        return NewWizardMessages.CPListLabelProvider_unknown_element_label;
    }

    private String getPathString(IPath path, boolean isExternal) {
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private String getVariableString(IPath path) {
        String name = path.makeRelative().toString();
        IPath[] entryPath = RubyCore.getLoadpathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = entryPath[0].append(path.removeFirstSegments(1)).toOSString();
            return Messages.format((String)NewWizardMessages.CPListLabelProvider_twopart, (Object[])new String[]{name, appended});
        }
        return name;
    }

    private ImageDescriptor getCPListElementBaseImage(CPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fSharedImages.getImageDescriptor("org.rubypeople.rdt.ui.fldr_root_obj.gif");
            }
            case 1: {
                IResource res = cpentry.getResource();
                if (res == null) {
                    return this.fSharedImages.getImageDescriptor("org.rubypeople.rdt.ui.jar_lsrc_obj.gif");
                }
                return this.fSharedImages.getImageDescriptor("org.rubypeople.rdt.ui.fldr_root_obj.gif");
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                return this.fSharedImages.getImageDescriptor("org.rubypeople.rdt.ui.envvar_obj.gif");
            }
            case 5: {
                return this.fSharedImages.getImageDescriptor("org.rubypeople.rdt.ui.library_obj.gif");
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPListElement) {
            CPListElement cpentry = (CPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new RubyElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, RubyElementImageProvider.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else {
            if (element instanceof CPListElementAttribute) {
                String key = ((CPListElementAttribute)element).getKey();
                if (key.equals("exclusion")) {
                    return this.fRegistry.get(RubyPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB);
                }
                if (key.equals("inclusion")) {
                    return this.fRegistry.get(RubyPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB);
                }
                return this.fSharedImages.getImage("org.rubypeople.rdt.ui.envvar_obj.gif");
            }
            if (element instanceof CPUserLibraryElement) {
                return this.fSharedImages.getImage("org.rubypeople.rdt.ui.library_obj.gif");
            }
        }
        return null;
    }
}

