/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.NewContainerDialog;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.rubypeople.rdt.ui.wizards.BuildPathDialogAccess;

public class LibrariesWorkbookPage
extends BuildPathBasePage {
    private ListDialogField fClassPathList;
    private IRubyProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final int IDX_ADDEXT = 0;
    private final int IDX_ADDVAR = 1;
    private final int IDX_EDIT = 3;
    private final int IDX_REMOVE = 4;

    public LibrariesWorkbookPage(CheckedListDialogField classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fSWTControl = null;
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.LibrariesWorkbookPage_libraries_addextjar_button;
        stringArray[1] = NewWizardMessages.LibrariesWorkbookPage_libraries_addvariable_button;
        stringArray[3] = NewWizardMessages.LibrariesWorkbookPage_libraries_edit_button;
        stringArray[4] = NewWizardMessages.LibrariesWorkbookPage_libraries_remove_button;
        String[] buttonLabels = stringArray;
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(NewWizardMessages.LibrariesWorkbookPage_libraries_label);
        this.fLibrariesList.enableButton(4, false);
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.setViewerSorter(new CPListElementSorter());
    }

    public void init(IRubyProject jproject) {
        this.fCurrJProject = jproject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> libelements = new ArrayList<CPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new CPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return RubyPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                libentries = this.openExtFolderDialog(null);
                break;
            }
            case 1: {
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 3: {
                this.editEntry();
                return;
            }
            case 4: {
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private CPListElement[] openExtFolderDialog(CPListElement existing) {
        if (existing == null) {
            IPath[] selected = BuildPathDialogAccess.chooseExternalFolderEntries(this.getShell());
            if (selected != null) {
                ArrayList<CPListElement> res = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new CPListElement(this.fCurrJProject, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new CPListElement[res.size()]);
            }
        } else {
            IPath configured = BuildPathDialogAccess.configureExternalFolderEntry(this.getShell(), existing.getPath());
            if (configured != null) {
                return new CPListElement[]{new CPListElement(this.fCurrJProject, 1, configured, null)};
            }
        }
        return null;
    }

    public void addElement(CPListElement element) {
        this.fLibrariesList.addElement(element);
        this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection((Object)element));
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashMap<CPListElement, HashSet<String>> containerEntriesToUpdate = new HashMap<CPListElement, HashSet<String>>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                Object value = null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof CPListElement) {
                    CPListElement containerEntry = attrib.getParent();
                    HashSet<String> changedAttributes = (HashSet<String>)containerEntriesToUpdate.get(containerEntry);
                    if (changedAttributes == null) {
                        changedAttributes = new HashSet<String>();
                        containerEntriesToUpdate.put(containerEntry, changedAttributes);
                    }
                    changedAttributes.add(key);
                }
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        for (Map.Entry entry : containerEntriesToUpdate.entrySet()) {
            CPListElement curr = (CPListElement)entry.getKey();
            HashSet attribs = (HashSet)entry.getValue();
            String[] changedAttributes = attribs.toArray(new String[attribs.size()]);
            ILoadpathEntry changedEntry = curr.getLoadpathEntry();
            this.updateContainerEntry(changedEntry, changedAttributes, this.fCurrJProject, ((CPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.isInNonModifiableContainer()) {
                    return false;
                }
                if (attrib.getValue() == null) {
                    return false;
                }
            } else if (elem instanceof CPListElement) {
                CPListElement curr = (CPListElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        }
    }

    private void updateContainerEntry(final ILoadpathEntry newEntry, final String[] changedAttributes, final IRubyProject jproject, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    BuildPathSupport.modifyLoadpathEntry(null, newEntry, changedAttributes, jproject, containerPath, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_title;
            String message = NewWizardMessages.LibrariesWorkbookPage_configurecontainer_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    res = this.openExtFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 2) break;
                if (resource.exists()) {
                    res = this.openScriptFolderDialog(elem);
                    break;
                }
                res = this.openNewScriptFolderDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
            if (elem.getEntryKind() == 4) {
                this.fLibrariesList.refresh();
            }
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        this.updateEnabledState();
    }

    private void updateEnabledState() {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(3, this.canEdit(selElements));
        this.fLibrariesList.enableButton(4, this.canRemove(selElements));
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            CPListElement curr = (CPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof CPListElementAttribute) {
            CPListElementAttribute attrib = (CPListElementAttribute)elem;
            return !attrib.isInNonModifiableContainer();
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateLoadpathList();
        }
    }

    private void updateLoadpathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fClassPathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    private CPListElement[] openNewScriptFolderDialog(CPListElement existing) {
        String title = existing == null ? NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_new_title : NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_edit_title;
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(Messages.format(NewWizardMessages.LibrariesWorkbookPage_NewClassFolderDialog_description, projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new CPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private CPListElement[] openScriptFolderDialog(CPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = BuildPathDialogAccess.chooseSourceFolderEntries(this.getShell(), this.fCurrJProject.getPath(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<CPListElement> res = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new CPListElement[res.size()]);
        }
        return null;
    }

    private IPath[] getUsedContainers(CPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            CPListElement elem = (CPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private CPListElement newCPLibraryElement(IResource res) {
        return new CPListElement(this.fCurrJProject, 1, res.getFullPath(), res);
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    private CPListElement[] openVariableSelectionDialog(CPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            CPListElement elem = (CPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = BuildPathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<CPListElement> result = new ArrayList<CPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    CPListElement elem = new CPListElement(this.fCurrJProject, 4, paths[i2], null);
                    IPath resolvedPath = RubyCore.getResolvedVariablePath((IPath)paths[i2]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new CPListElement[result.size()]);
            }
        } else {
            IPath path = BuildPathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                CPListElement elem = new CPListElement(this.fCurrJProject, 4, path, null);
                return new CPListElement[]{elem};
            }
        }
        return null;
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

