/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.CoreUtility;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.LoadpathContainerDefaultPage;
import org.rubypeople.rdt.ui.wizards.ILoadpathContainerPage;

public class LoadpathContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private ILoadpathContainerPage fPage;
    private static final String ATT_EXTENSION = "loadpathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_PAGE_CLASS = "class";

    public LoadpathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        this.fPage = null;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public ILoadpathContainerPage createPage() throws CoreException {
        if (this.fPage == null) {
            Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
            if (elem instanceof ILoadpathContainerPage) {
                this.fPage = (ILoadpathContainerPage)elem;
            } else {
                String id = this.fConfigElement.getAttribute(ATT_ID);
                throw new CoreException((IStatus)new Status(4, "org.rubypeople.rdt.ui", 0, "Invalid extension (page not of type ILoadpathContainerPage): " + id, null));
            }
        }
        return this.fPage;
    }

    public ILoadpathContainerPage getPage() {
        return this.fPage;
    }

    public void setPage(ILoadpathContainerPage page) {
        this.fPage = page;
    }

    public void dispose() {
        if (this.fPage != null) {
            this.fPage.dispose();
            this.fPage = null;
        }
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(ILoadpathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 5) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static LoadpathContainerDescriptor[] getDescriptors() {
        ArrayList<LoadpathContainerDescriptor> containers = new ArrayList<LoadpathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.rubypeople.rdt.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            LoadpathContainerDescriptor defaultPage = null;
            String defaultPageName = LoadpathContainerDefaultPage.class.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    LoadpathContainerDescriptor curr = new LoadpathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    RubyPlugin.log(e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty()) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new LoadpathContainerDescriptor[containers.size()]);
    }
}

