/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPVariableElementLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;

public class NewVariableEntryDialog
extends StatusDialog {
    private final int IDX_EXTEND = 0;
    private ListDialogField fVariablesList;
    private boolean fCanExtend;
    private boolean fIsValidSelection;
    private IPath[] fResultPaths;
    private SelectionButtonDialogField fConfigButton;

    public NewVariableEntryDialog(Shell parent) {
        super(parent);
        this.setTitle(NewWizardMessages.NewVariableEntryDialog_title);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x400 | 0x10);
        this.updateStatus(new StatusInfo(4, ""));
        String[] buttonLabels = new String[]{NewWizardMessages.NewVariableEntryDialog_vars_extend};
        VariablesAdapter adapter = new VariablesAdapter();
        CPVariableElementLabelProvider labelProvider = new CPVariableElementLabelProvider(false);
        this.fVariablesList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)labelProvider);
        this.fVariablesList.setDialogFieldListener(adapter);
        this.fVariablesList.setLabelText(NewWizardMessages.NewVariableEntryDialog_vars_label);
        this.fVariablesList.enableButton(0, false);
        this.fVariablesList.setViewerSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CPVariableElement && e2 instanceof CPVariableElement) {
                    return ((CPVariableElement)e1).getName().compareTo(((CPVariableElement)e2).getName());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.fConfigButton = new SelectionButtonDialogField(8);
        this.fConfigButton.setLabelText(NewWizardMessages.NewVariableEntryDialog_configbutton_label);
        this.fConfigButton.setDialogFieldListener(adapter);
        this.initializeElements();
        this.fCanExtend = false;
        this.fIsValidSelection = false;
        this.fResultPaths = null;
    }

    private void initializeElements() {
        String[] entries = RubyCore.getLoadpathVariableNames();
        ArrayList<CPVariableElement> elements = new ArrayList<CPVariableElement>(entries.length);
        int i = 0;
        while (i < entries.length) {
            String name = entries[i];
            IPath[] entryPath = RubyCore.getLoadpathVariable((String)name);
            if (entryPath != null) {
                elements.add(new CPVariableElement(name, entryPath, false));
            }
            ++i;
        }
        this.fVariablesList.setElements(elements);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.rubypeople.rdt.ui.new_variable_dialog_context");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return RubyPlugin.getDefault().getDialogSettingsSection(((Object)((Object)this)).getClass().getName());
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        this.fVariablesList.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fVariablesList.getLabelControl(null), 2);
        GridData listData = (GridData)this.fVariablesList.getListControl(null).getLayoutData();
        listData.grabExcessHorizontalSpace = true;
        listData.heightHint = this.convertHeightInCharsToPixels(10);
        listData.widthHint = this.convertWidthInCharsToPixels(70);
        Composite lowerComposite = new Composite(composite, 0);
        lowerComposite.setLayoutData((Object)new GridData(256));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        lowerComposite.setLayout((Layout)layout);
        this.fConfigButton.doFillIntoGrid(lowerComposite, 1);
        NewVariableEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public IPath[] getResult() {
        return this.fResultPaths;
    }

    private void doDoubleClick() {
        if (this.fIsValidSelection) {
            this.okPressed();
        } else if (this.fCanExtend) {
            this.extendButtonPressed();
        }
    }

    private void doSelectionChanged() {
        boolean isValidSelection = true;
        boolean canExtend = false;
        StatusInfo status = new StatusInfo();
        List selected = this.fVariablesList.getSelectedElements();
        int nSelected = selected.size();
        if (nSelected > 0) {
            this.fResultPaths = new Path[nSelected];
            int i = 0;
            while (i < nSelected) {
                CPVariableElement curr = (CPVariableElement)selected.get(i);
                this.fResultPaths[i] = new Path(curr.getName());
                File file = curr.getPath()[0].toFile();
                if (!file.exists()) {
                    status.setError(NewWizardMessages.NewVariableEntryDialog_info_notexists);
                    isValidSelection = false;
                    break;
                }
                if (file.isDirectory()) {
                    status.setError(NewWizardMessages.NewVariableEntryDialog_info_isfolder);
                    canExtend = true;
                    isValidSelection = false;
                    break;
                }
                ++i;
            }
        } else {
            isValidSelection = false;
            status.setInfo(NewWizardMessages.NewVariableEntryDialog_info_noselection);
        }
        if (isValidSelection && nSelected > 1) {
            String str = Messages.format(NewWizardMessages.NewVariableEntryDialog_info_selected, String.valueOf(nSelected));
            status.setInfo(str);
        }
        this.fCanExtend = nSelected == 1 && canExtend;
        this.fVariablesList.enableButton(0, this.fCanExtend);
        this.updateStatus(status);
        this.fIsValidSelection = isValidSelection;
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(isValidSelection);
        }
    }

    private IPath[] chooseExtensions(CPVariableElement elem) {
        File file = elem.getPath()[0].toFile();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText(NewWizardMessages.NewVariableEntryDialog_ExtensionDialog_title);
        dialog.setMessage(Messages.format(NewWizardMessages.NewVariableEntryDialog_ExtensionDialog_description, elem.getName()));
        dialog.setFilterPath(file.toString());
        String filename = null;
        filename = dialog.open();
        if (filename != null) {
            File myFile = new File(filename);
            IPath filePath = Path.fromOSString((String)myFile.getPath());
            Path resPath = new Path(elem.getName());
            int k = elem.getPath()[0].segmentCount();
            while (k < filePath.segmentCount()) {
                resPath = resPath.append(filePath.segment(k));
                ++k;
            }
            return new IPath[]{resPath};
        }
        return null;
    }

    protected final void extendButtonPressed() {
        IPath[] extendedPaths;
        List selected = this.fVariablesList.getSelectedElements();
        if (selected.size() == 1 && (extendedPaths = this.chooseExtensions((CPVariableElement)selected.get(0))) != null) {
            this.fResultPaths = extendedPaths;
            super.buttonPressed(0);
        }
    }

    protected final void configButtonPressed() {
        this.initializeElements();
    }

    private class VariablesAdapter
    implements IDialogFieldListener,
    IListAdapter {
        private VariablesAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    NewVariableEntryDialog.this.extendButtonPressed();
                }
            }
        }

        public void selectionChanged(ListDialogField field) {
            NewVariableEntryDialog.this.doSelectionChanged();
        }

        public void doubleClicked(ListDialogField field) {
            NewVariableEntryDialog.this.doDoubleClick();
        }

        public void dialogFieldChanged(DialogField field) {
            if (field == NewVariableEntryDialog.this.fConfigButton) {
                NewVariableEntryDialog.this.configButtonPressed();
            }
        }
    }
}

