/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.viewsupport.RubyUILabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.rubypeople.rdt.ui.RubyElementSorter;

public class ProjectsWorkbookPage
extends BuildPathBasePage {
    private final int IDX_ADDPROJECT = 0;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private ListDialogField fClassPathList;
    private IRubyProject fCurrJProject;
    private TreeListDialogField fProjectsList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public ProjectsWorkbookPage(ListDialogField classPathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fClassPathList = classPathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] stringArray = new String[4];
        stringArray[0] = NewWizardMessages.ProjectsWorkbookPage_projects_add_button;
        stringArray[2] = NewWizardMessages.ProjectsWorkbookPage_projects_edit_button;
        stringArray[3] = NewWizardMessages.ProjectsWorkbookPage_projects_remove_button;
        String[] buttonLabels = stringArray;
        ProjectsAdapter adapter = new ProjectsAdapter();
        this.fProjectsList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fProjectsList.setDialogFieldListener(adapter);
        this.fProjectsList.setLabelText(NewWizardMessages.ProjectsWorkbookPage_projects_label);
        this.fProjectsList.enableButton(3, false);
        this.fProjectsList.enableButton(2, false);
        this.fProjectsList.setViewerSorter(new CPListElementSorter());
    }

    public void init(IRubyProject jproject) {
        this.updateProjectsList(jproject);
    }

    private void updateProjectsList(IRubyProject currJProject) {
        List cpelements = this.fClassPathList.getElements();
        ArrayList<CPListElement> checkedProjects = new ArrayList<CPListElement>(cpelements.size());
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpelem = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpelem.getEntryKind())) {
                checkedProjects.add(cpelem);
            }
            --i;
        }
        this.fProjectsList.setElements(checkedProjects);
        this.fCurrJProject = currJProject;
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fProjectsList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fProjectsList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fProjectsList.setButtonsMinWidth(buttonBarWidth);
        this.fSWTControl = composite;
        return composite;
    }

    private void updateLoadpathList() {
        List projelements = this.fProjectsList.getElements();
        boolean remove = false;
        List cpelements = this.fClassPathList.getElements();
        int i = cpelements.size() - 1;
        while (i >= 0) {
            CPListElement cpe = (CPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind()) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                remove = true;
            }
            --i;
        }
        i = 0;
        while (i < projelements.size()) {
            cpelements.add(projelements.get(i));
            ++i;
        }
        if (remove || projelements.size() > 0) {
            this.fClassPathList.setElements(cpelements);
        }
    }

    public List getSelection() {
        return this.fProjectsList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fProjectsList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fProjectsList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public boolean isEntryKind(int kind) {
        return kind == 2;
    }

    private void projectPageCustomButtonPressed(DialogField field, int index) {
        Object[] entries = null;
        switch (index) {
            case 0: {
                entries = this.openProjectDialog(null);
                break;
            }
            case 2: {
                this.editEntry();
                return;
            }
            case 3: {
                this.removeEntry();
                return;
            }
        }
        if (entries != null) {
            int nElementsChosen = entries.length;
            List cplist = this.fProjectsList.getElements();
            ArrayList<CPListElement> elementsToAdd = new ArrayList<CPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                CPListElement curr = entries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            this.fProjectsList.addElements(elementsToAdd);
            if (index == 0) {
                this.fProjectsList.refresh();
            }
            this.fProjectsList.postSetSelection((ISelection)new StructuredSelection(entries));
        }
    }

    private void removeEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                String key = attrib.getKey();
                Object value = null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fProjectsList.refresh();
            this.fClassPathList.dialogFieldChanged();
        } else {
            this.fProjectsList.removeElements(selElements);
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int elements = 0;
        int attributes = 0;
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.getValue() == null) {
                    return false;
                }
                ++attributes;
            } else if (elem instanceof CPListElement) {
                ++elements;
            }
            ++i;
        }
        return attributes == selElements.size() || elements == selElements.size();
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof CPListElement) {
            return false;
        }
        return elem instanceof CPListElementAttribute;
    }

    private void editEntry() {
        List selElements = this.fProjectsList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fProjectsList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((CPListElement)elem);
        } else {
            boolean cfr_ignored_0 = elem instanceof CPListElementAttribute;
        }
    }

    private void editElementEntry(CPListElement elem) {
        CPListElement[] res = this.openProjectDialog(elem);
        if (res != null && res.length > 0) {
            CPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fProjectsList.replaceElement(elem, curr);
        }
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return RubyPlugin.getActiveWorkbenchShell();
    }

    private CPListElement[] openProjectDialog(CPListElement elem) {
        try {
            ArrayList selectable = new ArrayList();
            selectable.addAll(Arrays.asList(this.fCurrJProject.getRubyModel().getRubyProjects()));
            selectable.remove(this.fCurrJProject);
            List elements = this.fProjectsList.getElements();
            int i = 0;
            while (i < elements.size()) {
                CPListElement curr = (CPListElement)elements.get(0);
                IRubyProject proj = (IRubyProject)RubyCore.create((IResource)curr.getResource());
                selectable.remove(proj);
                ++i;
            }
            Object[] selectArr = selectable.toArray();
            new RubyElementSorter().sort(null, selectArr);
            ListSelectionDialog dialog = new ListSelectionDialog(this.getShell(), Arrays.asList(selectArr), (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new RubyUILabelProvider(), NewWizardMessages.ProjectsWorkbookPage_chooseProjects_message);
            dialog.setTitle(NewWizardMessages.ProjectsWorkbookPage_chooseProjects_title);
            dialog.setHelpAvailable(false);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                CPListElement[] cpElements = new CPListElement[result.length];
                int i2 = 0;
                while (i2 < result.length) {
                    IRubyProject curr = (IRubyProject)result[i2];
                    cpElements[i2] = new CPListElement(this.fCurrJProject, 2, curr.getPath(), curr.getResource());
                    ++i2;
                }
                return cpElements;
            }
        }
        catch (RubyModelException rubyModelException) {
            return null;
        }
        return null;
    }

    protected void projectPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fProjectsList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void projectPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fProjectsList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void projectPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateLoadpathList();
        }
    }

    private void projectPageSelectionChanged(DialogField field) {
        List selElements = this.fProjectsList.getSelectedElements();
        this.fProjectsList.enableButton(2, this.canEdit(selElements));
        this.fProjectsList.enableButton(3, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fProjectsList.enableButton(0, noAttributes);
    }

    private class ProjectsAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private ProjectsAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            ProjectsWorkbookPage.this.projectPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            ProjectsWorkbookPage.this.projectPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            ProjectsWorkbookPage.this.projectPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            ProjectsWorkbookPage.this.projectPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            ProjectsWorkbookPage.this.projectPageDialogFieldChanged(field);
        }
    }
}

