/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyModelStatus;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.ExclusionInclusionEntryDialog;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.DialogField;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;
import org.rubypeople.rdt.ui.wizards.NewElementWizardPage;

public class SetFilterWizardPage
extends NewElementWizardPage {
    private static final String PAGE_NAME = "SetFilterWizardPage";
    private ListDialogField fInclusionPatternList;
    private ListDialogField fExclusionPatternList;
    private CPListElement fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;
    private final ArrayList fExistingEntries;

    public SetFilterWizardPage(CPListElement entryToEdit, ArrayList existingEntries) {
        super(PAGE_NAME);
        this.fExistingEntries = existingEntries;
        this.setTitle(NewWizardMessages.ExclusionInclusionDialog_title);
        this.setDescription(NewWizardMessages.ExclusionInclusionDialog_description2);
        this.fCurrElement = entryToEdit;
        this.fCurrProject = entryToEdit.getRubyProject().getProject();
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        IResource res = root.findMember(entryToEdit.getPath());
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        String excLabel = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_label;
        ImageDescriptor excDescriptor = RubyPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB;
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_add;
        stringArray[1] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_add_multiple;
        stringArray[2] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_edit;
        stringArray[4] = NewWizardMessages.ExclusionInclusionDialog_exclusion_pattern_remove;
        String[] excButtonLabels = stringArray;
        String incLabel = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_label;
        ImageDescriptor incDescriptor = RubyPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB;
        String[] stringArray2 = new String[5];
        stringArray2[0] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_add;
        stringArray2[1] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_add_multiple;
        stringArray2[2] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_edit;
        stringArray2[4] = NewWizardMessages.ExclusionInclusionDialog_inclusion_pattern_remove;
        String[] incButtonLabels = stringArray2;
        this.fExclusionPatternList = this.createListContents(entryToEdit, "exclusion", excLabel, excDescriptor, excButtonLabels);
        this.fInclusionPatternList = this.createListContents(entryToEdit, "inclusion", incLabel, incDescriptor, incButtonLabels);
    }

    public void createControl(Composite parent) {
        Composite inner = new Composite(parent, 0);
        inner.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        this.fInclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fInclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fInclusionPatternList.getListControl(null));
        this.fExclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fExclusionPatternList.getListControl(null));
        this.setControl((Control)inner);
        Dialog.applyDialogFont((Control)inner);
    }

    private ListDialogField createListContents(CPListElement entryToEdit, String key, String label, ImageDescriptor descriptor, String[] buttonLabels) {
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        ListDialogField patternList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ExclusionInclusionLabelProvider(descriptor));
        patternList.setDialogFieldListener(adapter);
        patternList.setLabelText(label);
        patternList.enableButton(2, false);
        IPath[] pattern = (IPath[])entryToEdit.getAttribute(key);
        ArrayList<String> elements = new ArrayList<String>(pattern.length);
        int i = 0;
        while (i < pattern.length) {
            String patternName = pattern[i].toString();
            if (patternName.length() > 0) {
                elements.add(patternName);
            }
            ++i;
        }
        patternList.setElements(elements);
        patternList.selectFirstElement();
        patternList.enableButton(1, this.fCurrSourceFolder != null);
        patternList.setViewerSorter(new ViewerSorter());
        return patternList;
    }

    protected void doCustomButtonPressed(ListDialogField field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 2) {
            this.editEntry(field);
        } else if (index == 1) {
            this.addMultipleEntries(field);
        } else if (index == 4) {
            field.removeElements(field.getSelectedElements());
        }
        this.updateStatus();
    }

    private void updateStatus() {
        this.fCurrElement.setAttribute("inclusion", this.getInclusionPattern());
        this.fCurrElement.setAttribute("exclusion", this.getExclusionPattern());
        IRubyModelStatus status = RubyConventions.validateLoadpath((IRubyProject)this.fCurrElement.getRubyProject(), (ILoadpathEntry[])CPListElement.convertToLoadpathEntries(this.fExistingEntries), null);
        if (!status.isOK()) {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setError(status.getMessage());
            this.updateStatus(statusInfo);
        } else {
            StatusInfo statusInfo = new StatusInfo();
            statusInfo.setOK();
            this.updateStatus(statusInfo);
        }
    }

    protected void doDoubleClicked(ListDialogField field) {
        this.editEntry(field);
        this.updateStatus();
    }

    protected void doSelectionChanged(ListDialogField field) {
        List selected = field.getSelectedElements();
        field.enableButton(2, this.canEdit(selected));
    }

    private boolean canEdit(List selected) {
        return selected.size() == 1;
    }

    private void editEntry(ListDialogField field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        List existing = field.getElements();
        String entry = (String)selElements.get(0);
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), entry, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.replaceElement(entry, dialog.getExclusionPattern());
        }
    }

    private boolean isExclusion(ListDialogField field) {
        return field == this.fExclusionPatternList;
    }

    private void addEntry(ListDialogField field) {
        List existing = field.getElements();
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), null, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.addElement(dialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    private IPath[] getPattern(ListDialogField field) {
        Object[] arr = field.getElements().toArray();
        Arrays.sort(arr);
        IPath[] res = new IPath[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Path((String)arr[i]);
            ++i;
        }
        return res;
    }

    public IPath[] getExclusionPattern() {
        return this.getPattern(this.fExclusionPatternList);
    }

    public IPath[] getInclusionPattern() {
        return this.getPattern(this.fInclusionPatternList);
    }

    protected void configureShell(Shell newShell) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.rubypeople.rdt.ui.exclusion_pattern_dialog_context");
    }

    private void addMultipleEntries(ListDialogField field) {
        String message;
        String title;
        if (this.isExclusion(field)) {
            title = NewWizardMessages.ExclusionInclusionDialog_ChooseExclusionPattern_title;
            message = NewWizardMessages.ExclusionInclusionDialog_ChooseExclusionPattern_description;
        } else {
            title = NewWizardMessages.ExclusionInclusionDialog_ChooseInclusionPattern_title;
            message = NewWizardMessages.ExclusionInclusionDialog_ChooseInclusionPattern_description;
        }
        IPath[] res = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.fCurrSourceFolder, title, message, null, true);
        if (res != null) {
            int i = 0;
            while (i < res.length) {
                field.addElement(res[i].toString());
                ++i;
            }
        }
    }

    private static class ExclusionInclusionLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        public ExclusionInclusionLabelProvider(ImageDescriptor descriptor) {
            ImageDescriptorRegistry registry = RubyPlugin.getImageDescriptorRegistry();
            this.fElementImage = registry.get(descriptor);
        }

        public Image getImage(Object element) {
            return this.fElementImage;
        }

        public String getText(Object element) {
            return (String)element;
        }
    }

    private class ExclusionPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ExclusionPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            SetFilterWizardPage.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
            SetFilterWizardPage.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            SetFilterWizardPage.this.doDoubleClicked(field);
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

