/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPVariableElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.VariableBlock;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.StringButtonDialogField;

public class VariablePathDialogField
extends StringButtonDialogField {
    private Button fBrowseVariableButton;
    private String fVariableButtonLabel;

    public VariablePathDialogField(IStringButtonAdapter adapter) {
        super(adapter);
    }

    public void setVariableButtonLabel(String label) {
        this.fVariableButtonLabel = label;
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)VariablePathDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        text.setLayoutData((Object)VariablePathDialogField.gridDataForText(nColumns - 3));
        Button variableButton = this.getBrowseVariableControl(parent);
        variableButton.setLayoutData((Object)VariablePathDialogField.gridDataForButton(variableButton, 1));
        Button browseButton = this.getChangeControl(parent);
        browseButton.setLayoutData((Object)VariablePathDialogField.gridDataForButton(browseButton, 1));
        return new Control[]{label, text, variableButton, browseButton};
    }

    public int getNumberOfControls() {
        return 4;
    }

    public Button getBrowseVariableControl(Composite parent) {
        if (this.fBrowseVariableButton == null) {
            this.assertCompositeNotNull(parent);
            this.fBrowseVariableButton = new Button(parent, 8);
            this.fBrowseVariableButton.setText(this.fVariableButtonLabel);
            this.fBrowseVariableButton.setEnabled(this.isEnabled());
            this.fBrowseVariableButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    VariablePathDialogField.this.chooseVariablePressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    VariablePathDialogField.this.chooseVariablePressed();
                }
            });
        }
        return this.fBrowseVariableButton;
    }

    public IPath getPath() {
        return new Path(this.getText());
    }

    public String getVariable() {
        IPath path = this.getPath();
        if (!path.isEmpty()) {
            return path.segment(0);
        }
        return null;
    }

    public IPath getPathExtension() {
        return new Path(this.getText()).removeFirstSegments(1).setDevice(null);
    }

    public IPath getResolvedPath() {
        IPath path;
        String variable = this.getVariable();
        if (variable != null && (path = RubyCore.getLoadpathVariable((String)variable)[0]) != null) {
            return path.append(this.getPathExtension());
        }
        return null;
    }

    private Shell getShell() {
        if (this.fBrowseVariableButton != null) {
            return this.fBrowseVariableButton.getShell();
        }
        return RubyPlugin.getActiveWorkbenchShell();
    }

    private void chooseVariablePressed() {
        String variable = this.getVariable();
        ChooseVariableDialog dialog = new ChooseVariableDialog(this.getShell(), variable);
        if (dialog.open() == 0) {
            IPath newPath = new Path(dialog.getSelectedVariable()).append(this.getPathExtension());
            this.setText(newPath.toString());
        }
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fBrowseVariableButton)) {
            this.fBrowseVariableButton.setEnabled(this.isEnabled());
        }
    }

    public static class ChooseVariableDialog
    extends StatusDialog
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private VariableBlock fVariableBlock;

        public ChooseVariableDialog(Shell parent, String variableSelection) {
            super(parent);
            int shellStyle = this.getShellStyle();
            this.setShellStyle(shellStyle | 0x400 | 0x10);
            this.setTitle(NewWizardMessages.VariablePathDialogField_variabledialog_title);
            this.fVariableBlock = new VariableBlock(false, variableSelection);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control control = this.fVariableBlock.createContents(composite);
            GridData data = new GridData(1808);
            data.widthHint = this.convertWidthInCharsToPixels(80);
            data.heightHint = this.convertHeightInCharsToPixels(15);
            control.setLayoutData((Object)data);
            this.fVariableBlock.addDoubleClickListener(this);
            this.fVariableBlock.addSelectionChangedListener(this);
            ChooseVariableDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected void okPressed() {
            this.fVariableBlock.performOk();
            super.okPressed();
        }

        public String getSelectedVariable() {
            List elements = this.fVariableBlock.getSelectedElements();
            return ((CPVariableElement)elements.get(0)).getName();
        }

        public void doubleClick(DoubleClickEvent event) {
            if (this.getStatus().isOK()) {
                this.okPressed();
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            List elements = this.fVariableBlock.getSelectedElements();
            StatusInfo status = new StatusInfo();
            if (elements.size() != 1) {
                status.setError("");
            }
            this.updateStatus(status);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.rubypeople.rdt.ui.choose_variable_dialog_context");
        }
    }
}

