/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;

public class AddSelectedLibraryToBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private IFile[] fSelectedElements;

    public AddSelectedLibraryToBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_label, RubyPluginImages.DESC_OBJS_EXTJAR);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelLibToCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = null;
    }

    public void run() {
        try {
            final IFile[] files = this.fSelectedElements;
            if (files == null) {
                return;
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IRubyProject project = RubyCore.create((IProject)files[0].getProject());
                        List result = AddSelectedLibraryToBuildpathAction.this.addLibraryEntries(files, project, monitor);
                        AddSelectedLibraryToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                RubyPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List addLibraryEntries(IFile[] resources, IRubyProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<CPListElement> addedEntries = new ArrayList<CPListElement>();
        try {
            monitor.beginTask(NewWizardMessages.LoadpathModifier_Monitor_AddToBuildpath, 4);
            int i = 0;
            while (i < resources.length) {
                IFile res = resources[i];
                addedEntries.add(new CPListElement(project, 1, res.getFullPath(), (IResource)res));
                ++i;
            }
            monitor.worked(1);
            List existingEntries = LoadpathModifier.getExistingEntries(project);
            LoadpathModifier.setNewEntry(existingEntries, addedEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LoadpathModifier.commitLoadPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ArrayList<ISourceFolderRoot> result = new ArrayList<ISourceFolderRoot>(addedEntries.size());
            int i2 = 0;
            while (i2 < resources.length) {
                IFile res = resources[i2];
                ISourceFolderRoot elem = project.getSourceFolderRoot((IResource)res);
                if (elem != null) {
                    result.add(elem);
                }
                ++i2;
            }
            monitor.worked(1);
            ArrayList<ISourceFolderRoot> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    private boolean canHandle(IStructuredSelection elements) {
        this.fSelectedElements = this.getSelectedResources(elements);
        return this.fSelectedElements != null;
    }

    private IFile[] getSelectedResources(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return null;
        }
        ArrayList res = new ArrayList();
        Iterator iter = elements.iterator();
        if (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                IRubyProject project = RubyCore.create((IProject)file.getProject());
                if (project == null) {
                    return null;
                }
                return null;
            }
            return null;
        }
        return res.toArray(new IFile[res.size()]);
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.AddSelectedLibraryToBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            IWorkbenchPart part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        for (IWorkbenchPart part : parts) {
            ISetSelectionTarget target = null;
            target = part instanceof ISetSelectionTarget ? (ISetSelectionTarget)part : (ISetSelectionTarget)part.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

