/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.filters.LibraryFilter;
import org.rubypeople.rdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.rubypeople.rdt.internal.ui.viewsupport.DecoratingRubyLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetModel;
import org.rubypeople.rdt.ui.RubyElementSorter;
import org.rubypeople.rdt.ui.StandardRubyElementContentProvider;

public class DialogPackageExplorer
implements IMenuListener,
ISelectionChangedListener {
    private TreeViewer fPackageViewer;
    private Menu fContextMenu;
    private DialogPackageExplorerActionGroup fActionGroup = null;
    private boolean fShowOutputFolders = false;
    private IStructuredSelection fCurrentSelection = new StructuredSelection();
    private IRubyProject fCurrJProject = null;

    public Control createControl(Composite parent) {
        this.fPackageViewer = new TreeViewer(parent, 2);
        this.fPackageViewer.setComparer(WorkingSetModel.COMPARER);
        this.fPackageViewer.addFilter((ViewerFilter)new PackageFilter());
        this.fPackageViewer.setSorter((ViewerSorter)new ExtendedRubyElementSorter());
        this.fPackageViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (DialogPackageExplorer.this.fPackageViewer.isExpandable(element)) {
                    DialogPackageExplorer.this.fPackageViewer.setExpandedState(element, !DialogPackageExplorer.this.fPackageViewer.getExpandedState(element));
                }
            }
        });
        this.fPackageViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fPackageViewer.getTree());
        this.fPackageViewer.getTree().setMenu(this.fContextMenu);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialogPackageExplorer.this.fContextMenu.dispose();
            }
        });
        return this.fPackageViewer.getControl();
    }

    public void setActionGroup(final DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
        this.fPackageViewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (actionGroup != null) {
                    actionGroup.dispose();
                }
            }
        });
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.fActionGroup == null) {
            return;
        }
        RubyPlugin.createStandardGroups(manager);
        this.fActionGroup.fillContextMenu(manager);
    }

    public void setContentProvider() {
        PackageContentProvider contentProvider = new PackageContentProvider();
        PackageLabelProvider labelProvider = new PackageLabelProvider(0x212000000002L, 3);
        this.fPackageViewer.setContentProvider((IContentProvider)contentProvider);
        this.fPackageViewer.setLabelProvider((IBaseLabelProvider)new DecoratingRubyLabelProvider(labelProvider, false));
    }

    public void setInput(IRubyProject project) {
        this.fCurrJProject = project;
        this.fPackageViewer.setInput(new Object());
        StructuredSelection selection = new StructuredSelection((Object)project);
        this.fPackageViewer.setSelection((ISelection)selection);
        this.fPackageViewer.expandToLevel(2);
        this.fCurrentSelection = selection;
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    public void refresh() {
        this.fPackageViewer.refresh(true);
    }

    public void setSelection(List elements) {
        if (elements == null || elements.size() == 0) {
            return;
        }
        this.fPackageViewer.refresh();
        StructuredSelection selection = new StructuredSelection(elements);
        this.fPackageViewer.setSelection((ISelection)selection, true);
        this.fPackageViewer.getTree().setFocus();
        if (elements.size() == 1 && elements.get(0) instanceof IRubyProject) {
            this.fPackageViewer.expandToLevel(elements.get(0), 1);
        }
    }

    public IStructuredSelection getSelection() {
        return this.fCurrentSelection;
    }

    public Control getViewerControl() {
        return this.fPackageViewer.getControl();
    }

    private boolean isSelected() {
        return this.fShowOutputFolders;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fCurrentSelection = (IStructuredSelection)event.getSelection();
        try {
            if (this.fActionGroup != null) {
                this.fActionGroup.setContext(new DialogPackageExplorerActionGroup.DialogExplorerActionContext((ISelection)this.fCurrentSelection, this.fCurrJProject));
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
        }
    }

    private final class ExtendedRubyElementSorter
    extends RubyElementSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof CPListElementAttribute) {
                return -1;
            }
            if (e2 instanceof CPListElementAttribute) {
                return 1;
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private final class PackageContentProvider
    extends StandardRubyElementContentProvider {
        public Object[] getElements(Object element) {
            if (DialogPackageExplorer.this.fCurrJProject == null) {
                return new Object[0];
            }
            return new Object[]{DialogPackageExplorer.this.fCurrJProject};
        }
    }

    private final class PackageFilter
    extends LibraryFilter {
        private PackageFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block4: {
                IFile file;
                if (!(element instanceof IFile) || !(file = (IFile)element).getName().equals(".loadpath") && !file.getName().equals(".project")) break block4;
                return false;
            }
            try {
                ILoadpathEntry cpe;
                if (element instanceof ISourceFolderRoot && ((cpe = ((ISourceFolderRoot)element).getRawLoadpathEntry()) == null || cpe.getEntryKind() == 5)) {
                    return false;
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            return super.select(viewer, parentElement, element);
        }
    }

    private final class PackageLabelProvider
    extends AppearanceAwareLabelProvider {
        private CPListLabelProvider outputFolderLabel;

        public PackageLabelProvider(long textFlags, int imageFlags) {
            super(textFlags, imageFlags);
            this.outputFolderLabel = new CPListLabelProvider();
        }

        public String getText(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getText(element);
            }
            String text = super.getText(element);
            try {
                IResource resource;
                ISourceFolderRoot root;
                IRubyProject project;
                ISourceFolderRoot root2;
                if (element instanceof ISourceFolderRoot && (root2 = (ISourceFolderRoot)element).exists() && LoadpathModifier.filtersSet(root2)) {
                    ILoadpathEntry entry = root2.getRawLoadpathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if (element instanceof IRubyProject && (project = (IRubyProject)element).exists() && project.isOnLoadpath((IRubyElement)project) && LoadpathModifier.filtersSet(root = project.findSourceFolderRoot(project.getPath()))) {
                    ILoadpathEntry entry = root.getRawLoadpathEntry();
                    int excluded = entry.getExclusionPatterns().length;
                    if (excluded == 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_SingleExcluded, text);
                    }
                    if (excluded > 1) {
                        return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_MultiExcluded, new Object[]{text, new Integer(excluded)});
                    }
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && LoadpathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return Messages.format(NewWizardMessages.DialogPackageExplorer_LabelProvider_Excluded, text);
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            return text;
        }

        public Color getForeground(Object element) {
            try {
                IResource resource;
                ISourceFolderRoot root;
                IRubyProject project;
                ISourceFolderRoot root2;
                if (element instanceof ISourceFolderRoot && (root2 = (ISourceFolderRoot)element).exists() && LoadpathModifier.filtersSet(root2)) {
                    return this.getBlueColor();
                }
                if (element instanceof IRubyProject && (project = (IRubyProject)element).exists() && project.isOnLoadpath((IRubyElement)project) && (root = project.findSourceFolderRoot(project.getPath())) != null && LoadpathModifier.filtersSet(root)) {
                    return this.getBlueColor();
                }
                if ((element instanceof IFile || element instanceof IFolder) && (resource = (IResource)element).exists() && LoadpathModifier.isExcluded(resource, DialogPackageExplorer.this.fCurrJProject)) {
                    return this.getBlueColor();
                }
            }
            catch (RubyModelException e) {
                RubyPlugin.log(e);
            }
            return null;
        }

        private Color getBlueColor() {
            return Display.getCurrent().getSystemColor(9);
        }

        public Image getImage(Object element) {
            if (element instanceof CPListElementAttribute) {
                return this.outputFolderLabel.getImage(element);
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.outputFolderLabel.dispose();
            super.dispose();
        }
    }
}

