/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.ISourceFolderRoot;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.CPListElement;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.AddFolderToBuildpathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.AddLibraryToBuildpathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.AddSelectedLibraryToBuildpathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.ConfigureBuildPathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.ExcludeFromBuildpathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.IncludeToBuildpathAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveFromBuildpathAction;
import org.rubypeople.rdt.ui.actions.AbstractOpenWizardAction;

public class GenerateBuildPathActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.jdt.ui.buildpath.menu";
    public static final String GROUP_BUILDPATH = "buildpathGroup";
    public static final String GROUP_FILTER = "filterGroup";
    public static final String GROUP_CUSTOMIZE = "customizeGroup";
    private Action fNoActionAvailable = new NoActionAvailable();
    private IWorkbenchSite fSite;
    private List fActions;
    private String fGroupName = "group.reorganize";

    public GenerateBuildPathActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateBuildPathActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateBuildPathActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fActions = new ArrayList();
        CreateLinkedSourceFolderAction addLinkedSourceFolderAction = new CreateLinkedSourceFolderAction();
        this.fActions.add(addLinkedSourceFolderAction);
        CreateLocalSourceFolderAction addSourceFolderAction = new CreateLocalSourceFolderAction();
        this.fActions.add(addSourceFolderAction);
        AddFolderToBuildpathAction addFolder = new AddFolderToBuildpathAction(site);
        this.fActions.add(addFolder);
        AddSelectedLibraryToBuildpathAction addSelectedLibrary = new AddSelectedLibraryToBuildpathAction(site);
        this.fActions.add(addSelectedLibrary);
        RemoveFromBuildpathAction remove = new RemoveFromBuildpathAction(site);
        this.fActions.add(remove);
        AddLibraryToBuildpathAction addLibrary = new AddLibraryToBuildpathAction(site);
        this.fActions.add(addLibrary);
        ExcludeFromBuildpathAction exclude = new ExcludeFromBuildpathAction(site);
        this.fActions.add(exclude);
        IncludeToBuildpathAction include = new IncludeToBuildpathAction(site);
        this.fActions.add(include);
        EditFilterAction editFilterAction = new EditFilterAction();
        this.fActions.add(editFilterAction);
        ConfigureBuildPathAction configure = new ConfigureBuildPathAction(site);
        this.fActions.add(configure);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        for (Action action : this.fActions) {
            if (!(action instanceof ISelectionChangedListener)) continue;
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.canOperateOnSelection()) {
            return;
        }
        String menuText = ActionMessages.BuildPath_label;
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GenerateBuildPathActionGroup.this.fillViewSubMenu(manager);
            }
        });
        subMenu.setRemoveAllWhenShown(true);
        subMenu.add((IAction)new ConfigureBuildPathAction(this.fSite));
        menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
    }

    private void fillViewSubMenu(IMenuManager source) {
        int added = 0;
        int i = 0;
        for (Action action : this.fActions) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (i == 2) {
                source.add((IContributionItem)new Separator(GROUP_BUILDPATH));
            } else if (i == 8) {
                source.add((IContributionItem)new Separator(GROUP_FILTER));
            } else if (i == 10) {
                source.add((IContributionItem)new Separator(GROUP_CUSTOMIZE));
            }
            added += this.addAction(source, (IAction)action);
            ++i;
        }
        if (added == 0) {
            source.add((IAction)this.fNoActionAvailable);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean canOperateOnSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        for (Object element : selection) {
            if (!(element instanceof IWorkingSet)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.fActions != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            for (Action action : this.fActions) {
                if (!(action instanceof ISelectionChangedListener)) continue;
                provider.removeSelectionChangedListener((ISelectionChangedListener)action);
            }
        }
        this.fActions = null;
        super.dispose();
    }

    public static class CreateLinkedSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLinkedSourceFolderAction() {
            super(true);
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_label);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Link_tooltip);
            this.setImageDescriptor(RubyPluginImages.DESC_ELCL_ADD_LINKED_SOURCE_TO_BUILDPATH);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_createLinkedFolder);
        }
    }

    public static class CreateLocalSourceFolderAction
    extends CreateSourceFolderAction {
        public CreateLocalSourceFolderAction() {
            super(false);
            this.setText(ActionMessages.OpenNewSourceFolderWizardAction_text2);
            this.setDescription(ActionMessages.OpenNewSourceFolderWizardAction_description);
            this.setToolTipText(ActionMessages.OpenNewSourceFolderWizardAction_tooltip);
            this.setImageDescriptor(RubyPluginImages.DESC_TOOL_NEWPACKROOT);
        }
    }

    private static abstract class CreateSourceFolderAction
    extends OpenBuildPathWizardAction {
        private AddSourceFolderWizard fAddSourceFolderWizard;
        private IRubyProject fSelectedProject;
        private final boolean fIsLinked;

        public CreateSourceFolderAction(boolean isLinked) {
            this.fIsLinked = isLinked;
        }

        protected INewWizard createWizard() throws CoreException {
            CPListElement newEntrie = new CPListElement(this.fSelectedProject, 3);
            CPListElement[] existing = CPListElement.createFromExisting(this.fSelectedProject);
            boolean isProjectSrcFolder = CPListElement.isProjectSourceFolder(existing, this.fSelectedProject);
            this.fAddSourceFolderWizard = new AddSourceFolderWizard(existing, newEntrie, this.fIsLinked, false, false, isProjectSrcFolder, isProjectSrcFolder);
            return this.fAddSourceFolderWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IRubyProject) {
                this.fSelectedProject = (IRubyProject)selection.getFirstElement();
                return true;
            }
            return false;
        }

        public List getCPListElements() {
            return this.fAddSourceFolderWizard.getExistingEntries();
        }
    }

    public static class EditFilterAction
    extends OpenBuildPathWizardAction {
        private IRubyProject fSelectedProject;
        private IRubyElement fSelectedElement;
        private EditFilterWizard fEditFilterWizard;

        public EditFilterAction() {
            this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
            this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
            this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
            this.setImageDescriptor(RubyPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
            this.setDisabledImageDescriptor(RubyPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
        }

        protected INewWizard createWizard() throws CoreException {
            CPListElement[] existingEntries = CPListElement.createFromExisting(this.fSelectedProject);
            CPListElement elementToEdit = EditFilterAction.findElement(this.fSelectedElement, existingEntries);
            this.fEditFilterWizard = new EditFilterWizard(existingEntries, elementToEdit);
            return this.fEditFilterWizard;
        }

        public boolean selectionChanged(IStructuredSelection selection) {
            ISourceFolderRoot packageFragmentRoot;
            IRubyProject project;
            Object element;
            block6: {
                if (selection.size() != 1) {
                    return false;
                }
                try {
                    element = selection.getFirstElement();
                    if (!(element instanceof IRubyProject)) break block6;
                    IRubyProject project2 = (IRubyProject)element;
                    if (LoadpathModifier.isSourceFolder(project2)) {
                        this.fSelectedProject = project2;
                        this.fSelectedElement = (IRubyElement)element;
                        return true;
                    }
                }
                catch (RubyModelException rubyModelException) {
                    return false;
                }
            }
            if (element instanceof ISourceFolderRoot && (project = (packageFragmentRoot = (ISourceFolderRoot)element).getRubyProject()) != null) {
                this.fSelectedProject = project;
                this.fSelectedElement = (IRubyElement)element;
                return true;
            }
            return false;
        }

        private static CPListElement findElement(IRubyElement element, CPListElement[] elements) {
            IPath path = element.getPath();
            int i = 0;
            while (i < elements.length) {
                CPListElement cur = elements[i];
                if (cur.getEntryKind() == 3 && cur.getPath().equals((Object)path)) {
                    return cur;
                }
                ++i;
            }
            return null;
        }

        public List getCPListElements() {
            return this.fEditFilterWizard.getExistingEntries();
        }
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(NewWizardMessages.GenerateBuildPathActionGroup_no_action_available);
        }
    }

    private static abstract class OpenBuildPathWizardAction
    extends AbstractOpenWizardAction
    implements ISelectionChangedListener {
        private OpenBuildPathWizardAction() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.setEnabled(this.selectionChanged((IStructuredSelection)selection));
            } else {
                this.setEnabled(this.selectionChanged((IStructuredSelection)StructuredSelection.EMPTY));
            }
        }

        public abstract boolean selectionChanged(IStructuredSelection var1);
    }
}

