/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.IPackageExplorerActionListener;
import org.rubypeople.rdt.internal.corext.buildpath.PackageExplorerActionEvent;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.ScrolledPageContent;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorer;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierAction;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.LoadpathModifierQueries;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;

public final class HintTextGroup
implements ILoadpathInformationProvider,
IPackageExplorerActionListener {
    private static final int[] ACTION_ORDER;
    private Composite fTopComposite;
    private DialogPackageExplorerActionGroup fActionGroup;
    private DialogPackageExplorer fPackageExplorer;
    private IRunnableContext fRunnableContext;
    private IRubyProject fCurrJProject;
    private List fNewFolders;
    private HashMap fImageMap;
    private final NewSourceContainerWorkbookPage fPage;

    static {
        int[] nArray = new int[13];
        nArray[0] = 12;
        nArray[1] = 5;
        nArray[2] = 4;
        nArray[3] = 2;
        nArray[4] = 10;
        nArray[5] = 3;
        nArray[6] = 11;
        nArray[7] = 8;
        nArray[9] = 1;
        nArray[10] = 15;
        nArray[11] = 14;
        nArray[12] = 13;
        ACTION_ORDER = nArray;
    }

    public HintTextGroup(DialogPackageExplorer packageExplorer, IRunnableContext runnableContext, NewSourceContainerWorkbookPage page) {
        this.fPackageExplorer = packageExplorer;
        this.fRunnableContext = runnableContext;
        this.fPage = page;
        this.fCurrJProject = null;
        this.fNewFolders = new ArrayList();
        this.fImageMap = new HashMap();
    }

    public Composite createControl(Composite parent) {
        this.fTopComposite = new Composite(parent, 0);
        this.fTopComposite.setFont(parent.getFont());
        GridData gridData = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)parent);
        gridData.heightHint = converter.convertHeightInCharsToPixels(12);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fTopComposite.setLayout((Layout)gridLayout);
        this.fTopComposite.setLayoutData((Object)gridData);
        this.fTopComposite.setData(null);
        this.fTopComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Collection collection = HintTextGroup.this.fImageMap.values();
                for (Image image : collection) {
                    image.dispose();
                }
            }
        });
        return this.fTopComposite;
    }

    private Shell getShell() {
        return RubyPlugin.getActiveWorkbenchShell();
    }

    public void setRubyProject(IRubyProject jProject) {
        this.fCurrJProject = jProject;
    }

    public void setActionGroup(DialogPackageExplorerActionGroup actionGroup) {
        this.fActionGroup = actionGroup;
    }

    private FormText createFormText(Composite parent, String text) {
        FormToolkit toolkit = new FormToolkit(this.getShell().getDisplay());
        try {
            FormText formText = toolkit.createFormText(parent, true);
            formText.setFont(parent.getFont());
            try {
                formText.setText(text, true, false);
            }
            catch (IllegalArgumentException e) {
                formText.setText(e.getMessage(), false, false);
                RubyPlugin.log(e);
            }
            formText.marginHeight = 2;
            formText.marginWidth = 0;
            formText.setBackground(null);
            formText.setLayoutData((Object)new TableWrapData(256));
            FormText formText2 = formText;
            return formText2;
        }
        finally {
            toolkit.dispose();
        }
    }

    private void createLabel(Composite parent, String text, final LoadpathModifierAction action, final IRunnableContext context) {
        FormText formText = this.createFormText(parent, text);
        Image image = (Image)this.fImageMap.get(action.getId());
        if (image == null) {
            image = action.getImageDescriptor().createImage();
            this.fImageMap.put(action.getId(), image);
        }
        formText.setImage("defaultImage", image);
        formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    context.run(false, false, (IRunnableWithProgress)action.getOperation());
                }
                catch (InvocationTargetException err) {
                    ExceptionHandler.handle(err, HintTextGroup.this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title, action.getName()), err.getMessage());
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    public IStructuredSelection getSelection() {
        return this.fPackageExplorer.getSelection();
    }

    public void setSelection(List elements) {
        this.fPackageExplorer.setSelection(elements);
    }

    public IRubyProject getRubyProject() {
        return this.fCurrJProject;
    }

    public void handleResult(List resultElements, CoreException exception, int actionType) {
        if (exception != null) {
            ExceptionHandler.handle(exception, this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title_refresh, this.fActionGroup.getAction(actionType).getName()), exception.getLocalizedMessage());
            return;
        }
        switch (actionType) {
            case 12: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 5: {
                this.handleFolderCreation(resultElements);
                break;
            }
            case 4: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 0: 
            case 13: 
            case 14: 
            case 15: {
                this.handleAddToCP(resultElements);
                break;
            }
            case 1: {
                this.handleRemoveFromBP(resultElements, false);
                break;
            }
            case 10: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 2: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 11: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 3: {
                this.defaultHandle(resultElements, true);
                break;
            }
            case 9: {
                this.defaultHandle(resultElements, false);
                break;
            }
            case 6: {
                this.handleResetAll();
                break;
            }
        }
    }

    private void defaultHandle(List result, boolean forceRebuild) {
        try {
            this.fPackageExplorer.setSelection(result);
            if (forceRebuild) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (RubyModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleFolderCreation(List result) {
        if (result.size() == 1) {
            this.fNewFolders.add(result.get(0));
            this.fPackageExplorer.setSelection(result);
        }
    }

    private void handleAddToCP(List result) {
        try {
            if (this.containsRubyProject(result)) {
                this.fPackageExplorer.setSelection(result);
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            } else {
                this.fPackageExplorer.setSelection(result);
            }
        }
        catch (RubyModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleRemoveFromBP(List result, boolean forceRebuild) {
        this.fPackageExplorer.setSelection(result);
        try {
            if (forceRebuild || this.containsRubyProject(result)) {
                this.fActionGroup.refresh(new DialogPackageExplorerActionGroup.DialogExplorerActionContext(result, this.fCurrJProject));
            }
        }
        catch (RubyModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), NewWizardMessages.HintTextGroup_Exception_Title_refresh, e.getLocalizedMessage());
        }
    }

    private void handleResetAll() {
        ArrayList<IRubyProject> list = new ArrayList<IRubyProject>();
        list.add(this.fCurrJProject);
        this.setSelection(list);
    }

    private boolean containsRubyProject(List elements) {
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IRubyProject) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public LoadpathModifierQueries.IInclusionExclusionQuery getInclusionExclusionQuery() {
        return LoadpathModifierQueries.getDefaultInclusionExclusionQuery(this.getShell());
    }

    public LoadpathModifierQueries.ILinkToQuery getLinkFolderQuery() throws RubyModelException {
        return LoadpathModifierQueries.getDefaultLinkQuery(this.getShell(), this.fCurrJProject, null);
    }

    public LoadpathModifierQueries.ICreateFolderQuery getCreateFolderQuery() throws RubyModelException {
        return LoadpathModifierQueries.getDefaultCreateFolderQuery(this.getShell(), this.fCurrJProject);
    }

    public LoadpathModifierQueries.IRemoveLinkedFolderQuery getRemoveLinkedFolderQuery() throws RubyModelException {
        return LoadpathModifierQueries.getDefaultRemoveLinkedFolderQuery(this.getShell());
    }

    public void deleteCreatedResources() {
        for (Object element : this.fNewFolders) {
            try {
                IFolder folder;
                if (element instanceof IFolder) {
                    folder = (IFolder)element;
                } else if (element instanceof IRubyElement) {
                    folder = this.fCurrJProject.getProject().getWorkspace().getRoot().getFolder(((IRubyElement)element).getPath());
                } else {
                    ((IFile)element).delete(false, null);
                    continue;
                }
                folder.delete(false, null);
            }
            catch (CoreException coreException) {}
        }
        this.fNewFolders = new ArrayList();
    }

    public void handlePackageExplorerActionEvent(PackageExplorerActionEvent event) {
        Composite childComposite = (Composite)this.fTopComposite.getData();
        if (childComposite != null && childComposite.getParent() != null) {
            childComposite.getParent().dispose();
        }
        ScrolledPageContent spc = new ScrolledPageContent(this.fTopComposite, 512);
        spc.getVerticalBar().setIncrement(5);
        spc.setLayoutData(new GridData(1808));
        childComposite = spc.getBody();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.leftMargin = 0;
        tableWrapLayout.rightMargin = 0;
        childComposite.setLayout((Layout)tableWrapLayout);
        childComposite.setLayoutData((Object)new GridData(768));
        this.fTopComposite.setData((Object)childComposite);
        LoadpathModifierAction[] actions = event.getEnabledActions();
        String[] descriptionText = event.getEnabledActionsText();
        if (this.noContextHelpAvailable(actions)) {
            String noAction = this.fActionGroup.getNoActionDescription();
            this.createFormText(childComposite, Messages.format(NewWizardMessages.HintTextGroup_NoAction, noAction));
            this.fTopComposite.layout(true);
            return;
        }
        int j = 0;
        while (j < ACTION_ORDER.length) {
            int i = 0;
            while (i < actions.length) {
                int id = Integer.parseInt(actions[i].getId());
                if (id == ACTION_ORDER[j]) {
                    this.createLabel(childComposite, descriptionText[i], actions[i], this.fRunnableContext);
                    break;
                }
                ++i;
            }
            ++j;
        }
        this.fTopComposite.layout(true);
    }

    private boolean noContextHelpAvailable(LoadpathModifierAction[] actions) {
        int id;
        if (actions.length == 0) {
            return true;
        }
        if (actions.length == 1 && (id = Integer.parseInt(actions[0].getId())) == 5) {
            return true;
        }
        if (actions.length == 2) {
            int idLink = Integer.parseInt(actions[0].getId());
            int idReset = Integer.parseInt(actions[1].getId());
            if (idReset == 6 && idLink == 5) {
                return true;
            }
        }
        return false;
    }
}

