/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.corext.buildpath.ILoadpathInformationProvider;
import org.rubypeople.rdt.internal.corext.buildpath.LoadpathModifier;
import org.rubypeople.rdt.internal.ui.wizards.buildpaths.newsourcepage.DialogPackageExplorerActionGroup;

public abstract class LoadpathModifierOperation
extends LoadpathModifier
implements IRunnableWithProgress {
    protected ILoadpathInformationProvider fInformationProvider;
    protected CoreException fException;
    private int fType;
    private String fName;

    public LoadpathModifierOperation(LoadpathModifier.ILoadpathModifierListener listener, ILoadpathInformationProvider informationProvider, String name, int type) {
        super(listener);
        this.fInformationProvider = informationProvider;
        this.fException = null;
        this.fName = name;
        this.fType = type;
    }

    protected void handleResult(List result, IProgressMonitor monitor) throws InvocationTargetException {
        if (monitor != null && this.fException != null) {
            throw new InvocationTargetException(this.fException);
        }
        this.fInformationProvider.handleResult(result, this.fException, this.fType);
        this.fException = null;
    }

    public abstract void run(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public String getId() {
        return Integer.toString(this.fType);
    }

    public abstract boolean isValid(List var1, int[] var2) throws RubyModelException;

    public abstract String getDescription(int var1);

    public String getName() {
        return this.fName;
    }

    public List getSelectedElements() {
        return this.fInformationProvider.getSelection().toList();
    }

    public int getTypeId() {
        return this.fType;
    }

    public boolean isValid() throws RubyModelException {
        List selectedElements = this.getSelectedElements();
        int[] types = new int[selectedElements.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = DialogPackageExplorerActionGroup.getType(selectedElements.get(i), this.fInformationProvider.getRubyProject());
            ++i;
        }
        return this.isValid(selectedElements, types);
    }
}

