/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.workingsets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.ui.ILocalWorkingSetManager;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetUpdater;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.workingsets.OthersWorkingSetUpdater;
import org.rubypeople.rdt.internal.ui.workingsets.WorkingSetMessages;

public class WorkingSetModel {
    public static final String CHANGE_WORKING_SET_MODEL_CONTENT = "workingSetModelChanged";
    public static final IElementComparer COMPARER = new WorkingSetComparar();
    private static final String TAG_LOCAL_WORKING_SET_MANAGER = "localWorkingSetManager";
    private static final String TAG_ACTIVE_WORKING_SET = "activeWorkingSet";
    private static final String TAG_WORKING_SET_NAME = "workingSetName";
    private static final String TAG_CONFIGURED = "configured";
    private ILocalWorkingSetManager fLocalWorkingSetManager;
    private List<IWorkingSet> fActiveWorkingSets;
    private ListenerList fListeners;
    private IPropertyChangeListener fWorkingSetManagerListener;
    private OthersWorkingSetUpdater fOthersWorkingSetUpdater;
    private ElementMapper fElementMapper = new ElementMapper();
    private boolean fConfigured;

    public WorkingSetModel() {
        this.fLocalWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
        this.addListenersToWorkingSetManagers();
        this.fActiveWorkingSets = new ArrayList<IWorkingSet>(2);
        IWorkingSet others = this.fLocalWorkingSetManager.createWorkingSet(WorkingSetMessages.WorkingSetModel_others_name, new IAdaptable[0]);
        others.setId("org.rubypeople.rdt.internal.ui.OthersWorkingSet");
        this.fLocalWorkingSetManager.addWorkingSet(others);
        Assert.isNotNull((Object)this.fOthersWorkingSetUpdater);
        this.fActiveWorkingSets.add(others);
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        this.fOthersWorkingSetUpdater.updateElements();
    }

    public WorkingSetModel(IMemento memento) {
        this.fLocalWorkingSetManager = PlatformUI.getWorkbench().createLocalWorkingSetManager();
        this.addListenersToWorkingSetManagers();
        this.fActiveWorkingSets = new ArrayList<IWorkingSet>(2);
        this.restoreState(memento);
        Assert.isNotNull((Object)this.fOthersWorkingSetUpdater);
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        this.fOthersWorkingSetUpdater.updateElements();
    }

    private void addListenersToWorkingSetManagers() {
        this.fListeners = new ListenerList(1);
        this.fWorkingSetManagerListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WorkingSetModel.this.workingSetManagerChanged(event);
            }
        };
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.fWorkingSetManagerListener);
        this.fLocalWorkingSetManager.addPropertyChangeListener(this.fWorkingSetManagerListener);
    }

    public void dispose() {
        if (this.fWorkingSetManagerListener != null) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.removePropertyChangeListener(this.fWorkingSetManagerListener);
            this.fLocalWorkingSetManager.dispose();
            this.fWorkingSetManagerListener = null;
        }
    }

    public IAdaptable[] getChildren(IWorkingSet workingSet) {
        return workingSet.getElements();
    }

    public Object getParent(Object element) {
        if (element instanceof IWorkingSet && this.fActiveWorkingSets.contains(element)) {
            return this;
        }
        return this.fElementMapper.getFirstWorkingSet(element);
    }

    public Object[] getAllParents(Object element) {
        if (element instanceof IWorkingSet && this.fActiveWorkingSets.contains(element)) {
            return new Object[]{this};
        }
        return this.fElementMapper.getAllWorkingSets(element).toArray();
    }

    public Object[] addWorkingSets(Object[] elements) {
        ArrayList result = null;
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            List sets = null;
            sets = element instanceof IResource ? this.fElementMapper.getAllWorkingSetsForResource((IResource)element) : this.fElementMapper.getAllWorkingSets(element);
            if (sets != null && sets.size() > 0) {
                if (result == null) {
                    result = new ArrayList(Arrays.asList(elements));
                }
                result.addAll(sets);
            }
            ++i;
        }
        if (result == null) {
            return elements;
        }
        return result.toArray();
    }

    public boolean needsConfiguration() {
        return !this.fConfigured && this.fActiveWorkingSets.size() == 1 && "org.rubypeople.rdt.internal.ui.OthersWorkingSet".equals(this.fActiveWorkingSets.get(0).getId());
    }

    public void configured() {
        this.fConfigured = true;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public IWorkingSet[] getActiveWorkingSets() {
        return this.fActiveWorkingSets.toArray(new IWorkingSet[this.fActiveWorkingSets.size()]);
    }

    public IWorkingSet[] getAllWorkingSets() {
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        result.addAll(this.fActiveWorkingSets);
        IWorkingSet[] locals = this.fLocalWorkingSetManager.getWorkingSets();
        int i = 0;
        while (i < locals.length) {
            if (!result.contains(locals[i])) {
                result.add(locals[i]);
            }
            ++i;
        }
        IWorkingSet[] globals = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
        int i2 = 0;
        while (i2 < globals.length) {
            if (!result.contains(globals[i2])) {
                result.add(globals[i2]);
            }
            ++i2;
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    public void setActiveWorkingSets(IWorkingSet[] workingSets) {
        this.fActiveWorkingSets = new ArrayList<IWorkingSet>((Collection)Arrays.asList(workingSets));
        this.fElementMapper.rebuild(this.getActiveWorkingSets());
        this.fOthersWorkingSetUpdater.updateElements();
        this.fireEvent(new PropertyChangeEvent((Object)this, CHANGE_WORKING_SET_MODEL_CONTENT, null, null));
    }

    public void saveState(IMemento memento) {
        memento.putString(TAG_CONFIGURED, Boolean.toString(this.fConfigured));
        this.fLocalWorkingSetManager.saveState(memento.createChild(TAG_LOCAL_WORKING_SET_MANAGER));
        Iterator<IWorkingSet> iter = this.fActiveWorkingSets.iterator();
        while (iter.hasNext()) {
            IMemento active = memento.createChild(TAG_ACTIVE_WORKING_SET);
            IWorkingSet workingSet = iter.next();
            active.putString(TAG_WORKING_SET_NAME, workingSet.getName());
        }
    }

    public List getNonProjectTopLevelElements() {
        return this.fElementMapper.getNonProjectTopLevelElements();
    }

    private void restoreState(IMemento memento) {
        String configured = memento.getString(TAG_CONFIGURED);
        this.fConfigured = configured != null && Boolean.valueOf(configured) != false;
        this.fLocalWorkingSetManager.restoreState(memento.getChild(TAG_LOCAL_WORKING_SET_MANAGER));
        IMemento[] actives = memento.getChildren(TAG_ACTIVE_WORKING_SET);
        int i = 0;
        while (i < actives.length) {
            String name = actives[i].getString(TAG_WORKING_SET_NAME);
            if (name != null) {
                IWorkingSet ws = this.fLocalWorkingSetManager.getWorkingSet(name);
                if (ws == null) {
                    ws = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(name);
                }
                if (ws != null) {
                    this.fActiveWorkingSets.add(ws);
                }
            }
            ++i;
        }
    }

    private void workingSetManagerChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("workingSetUpdaterInstalled".equals(property) && event.getSource() == this.fLocalWorkingSetManager) {
            IWorkingSetUpdater updater = (IWorkingSetUpdater)event.getNewValue();
            if (updater instanceof OthersWorkingSetUpdater) {
                this.fOthersWorkingSetUpdater = (OthersWorkingSetUpdater)updater;
                this.fOthersWorkingSetUpdater.init(this);
            }
            return;
        }
        if (!this.isAffected(event)) {
            return;
        }
        if ("workingSetContentChange".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
            IAdaptable[] elements = this.fElementMapper.refresh(workingSet);
            if (elements != null) {
                this.fireEvent(event);
            }
        } else if ("workingSetRemove".equals(property)) {
            IWorkingSet workingSet = (IWorkingSet)event.getOldValue();
            ArrayList<IWorkingSet> elements = new ArrayList<IWorkingSet>(this.fActiveWorkingSets);
            elements.remove(workingSet);
            this.setActiveWorkingSets(elements.toArray(new IWorkingSet[elements.size()]));
        } else if ("workingSetNameChange".equals(property)) {
            this.fireEvent(event);
        }
    }

    private void fireEvent(PropertyChangeEvent event) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyChangeListener)listeners[i]).propertyChange(event);
            ++i;
        }
    }

    private boolean isAffected(PropertyChangeEvent event) {
        if (this.fActiveWorkingSets == null) {
            return false;
        }
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        return oldValue != null && this.fActiveWorkingSets.contains(oldValue) || newValue != null && this.fActiveWorkingSets.contains(newValue);
    }

    public boolean isActiveWorkingSet(IWorkingSet changedWorkingSet) {
        return this.fActiveWorkingSets.contains(changedWorkingSet);
    }

    private static class ElementMapper {
        private Map fElementToWorkingSet = new HashMap();
        private Map<IWorkingSet, IAdaptable[]> fWorkingSetToElement = new IdentityHashMap<IWorkingSet, IAdaptable[]>();
        private Map fResourceToWorkingSet = new HashMap();
        private List fNonProjectTopLevelElements = new ArrayList();

        private ElementMapper() {
        }

        public void clear() {
            this.fElementToWorkingSet.clear();
            this.fWorkingSetToElement.clear();
            this.fResourceToWorkingSet.clear();
            this.fNonProjectTopLevelElements.clear();
        }

        public void rebuild(IWorkingSet[] workingSets) {
            this.clear();
            int i = 0;
            while (i < workingSets.length) {
                this.put(workingSets[i]);
                ++i;
            }
        }

        public IAdaptable[] remove(IWorkingSet ws) {
            IAdaptable[] elements = this.fWorkingSetToElement.remove(ws);
            if (elements != null) {
                int i = 0;
                while (i < elements.length) {
                    this.removeElement(elements[i], ws);
                    ++i;
                }
            }
            return elements;
        }

        public IAdaptable[] refresh(IWorkingSet ws) {
            IAdaptable[] oldElements = this.fWorkingSetToElement.get(ws);
            if (oldElements == null) {
                return null;
            }
            IAdaptable[] newElements = ws.getElements();
            ArrayList toRemove = new ArrayList(Arrays.asList(oldElements));
            ArrayList toAdd = new ArrayList(Arrays.asList(newElements));
            this.computeDelta(toRemove, toAdd, oldElements, newElements);
            Iterator iter = toAdd.iterator();
            while (iter.hasNext()) {
                this.addElement((IAdaptable)iter.next(), ws);
            }
            iter = toRemove.iterator();
            while (iter.hasNext()) {
                this.removeElement((IAdaptable)iter.next(), ws);
            }
            if (toRemove.size() > 0 || toAdd.size() > 0) {
                this.fWorkingSetToElement.put(ws, newElements);
            }
            return oldElements;
        }

        private void computeDelta(List toRemove, List toAdd, IAdaptable[] oldElements, IAdaptable[] newElements) {
            int i = 0;
            while (i < oldElements.length) {
                toAdd.remove(oldElements[i]);
                ++i;
            }
            i = 0;
            while (i < newElements.length) {
                toRemove.remove(newElements[i]);
                ++i;
            }
        }

        public IWorkingSet getFirstWorkingSet(Object element) {
            return (IWorkingSet)this.getFirstElement(this.fElementToWorkingSet, element);
        }

        public List getAllWorkingSets(Object element) {
            return this.getAllElements(this.fElementToWorkingSet, element);
        }

        public IWorkingSet getFirstWorkingSetForResource(IResource resource) {
            return (IWorkingSet)this.getFirstElement(this.fResourceToWorkingSet, resource);
        }

        public List getAllWorkingSetsForResource(IResource resource) {
            return this.getAllElements(this.fResourceToWorkingSet, resource);
        }

        public List getNonProjectTopLevelElements() {
            return this.fNonProjectTopLevelElements;
        }

        private void put(IWorkingSet ws) {
            if (this.fWorkingSetToElement.containsKey(ws)) {
                return;
            }
            IAdaptable[] elements = ws.getElements();
            this.fWorkingSetToElement.put(ws, elements);
            int i = 0;
            while (i < elements.length) {
                IAdaptable element = elements[i];
                this.addElement(element, ws);
                if (!(element instanceof IProject) && !(element instanceof IRubyProject)) {
                    this.fNonProjectTopLevelElements.add(element);
                }
                ++i;
            }
        }

        private void addElement(IAdaptable element, IWorkingSet ws) {
            this.addToMap(this.fElementToWorkingSet, element, ws);
            IResource resource = (IResource)element.getAdapter(IResource.class);
            if (resource != null) {
                this.addToMap(this.fResourceToWorkingSet, (IAdaptable)resource, ws);
            }
        }

        private void removeElement(IAdaptable element, IWorkingSet ws) {
            this.removeFromMap(this.fElementToWorkingSet, element, ws);
            IResource resource = (IResource)element.getAdapter(IResource.class);
            if (resource != null) {
                this.removeFromMap(this.fResourceToWorkingSet, (IAdaptable)resource, ws);
            }
        }

        private void addToMap(Map map, IAdaptable key, IWorkingSet value) {
            Object obj = map.get(key);
            if (obj == null) {
                map.put(key, value);
            } else if (obj instanceof IWorkingSet) {
                ArrayList<Object> l = new ArrayList<Object>(2);
                l.add(obj);
                l.add(value);
                map.put(key, l);
            } else if (obj instanceof List) {
                ((List)obj).add(value);
            }
        }

        private void removeFromMap(Map map, IAdaptable key, IWorkingSet value) {
            Object current = map.get(key);
            if (current == null) {
                return;
            }
            if (current instanceof List) {
                List list = (List)current;
                list.remove(value);
                switch (list.size()) {
                    case 0: {
                        map.remove(key);
                        break;
                    }
                    case 1: {
                        map.put(key, list.get(0));
                    }
                }
            } else if (current == value) {
                map.remove(key);
            }
        }

        private Object getFirstElement(Map map, Object key) {
            Object obj = map.get(key);
            if (obj instanceof List) {
                return ((List)obj).get(0);
            }
            return obj;
        }

        private List getAllElements(Map map, Object key) {
            Object obj = map.get(key);
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList result = new ArrayList(1);
            result.add(obj);
            return result;
        }
    }

    private static class WorkingSetComparar
    implements IElementComparer {
        private WorkingSetComparar() {
        }

        public boolean equals(Object o1, Object o2) {
            IWorkingSet w2;
            IWorkingSet w1 = o1 instanceof IWorkingSet ? (IWorkingSet)o1 : null;
            IWorkingSet iWorkingSet = w2 = o2 instanceof IWorkingSet ? (IWorkingSet)o2 : null;
            if (w1 == null || w2 == null) {
                return o1.equals(o2);
            }
            return w1 == w2;
        }

        public int hashCode(Object element) {
            if (element instanceof IWorkingSet) {
                return System.identityHashCode(element);
            }
            return element.hashCode();
        }
    }
}

