/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesMessages;
import org.rubypeople.rdt.internal.ui.text.spelling.SpellCheckEngine;

public class PreferenceConstants {
    private static String fgDefaultEncoding = System.getProperty("file.encoding");
    public static final String DEBUGGER_USE_RUBY_DEBUG = "useRubyDebug";
    public static final String TEMPLATES_USE_CODEFORMATTER = "templatesUseCodeFormatter";
    private static final String LOADPATH_RUBYVMLIBRARY_INDEX = "org.rubypeople.rdt.ui.wizards.rubyvm.index";
    private static final String LOADPATH_RUBYVMLIBRARY_LIST = "org.rubypeople.rdt.ui.wizards.rubyvm.list";
    public static final String NEWPROJECT_JRELIBRARY_LIST = "org.rubypeople.rdt.ui.wizards.rubyvm.list";
    public static final String NEWPROJECT_JRELIBRARY_INDEX = "org.rubypeople.rdt.ui.wizards.rubyvm.index";
    public static final String APPEARANCE_METHOD_PARAMETER_NAMES = "org.rubypeople.rdt.ui.methodparameternames";
    public static final String EDITOR_FOLDING_ENABLED = "editor_folding_enabled";
    public static final String EDITOR_FOLDING_PROVIDER = "editor_folding_provider";
    public static final String EDITOR_FOLDING_RDOC = "editor_folding_default_rdoc";
    public static final String EDITOR_EVALUTE_TEMPORARY_PROBLEMS = "handleTemporaryProblems";
    public static final String EDITOR_FOLDING_INNERTYPES = "editor_folding_default_innertypes";
    public static final String EDITOR_FOLDING_METHODS = "editor_folding_default_methods";
    public static final String EDITOR_BG_SUFFIX = "_background";
    public static final String EDITOR_BG_ENABLED_SUFFIX = "_background_enabled";
    public static final String EDITOR_BOLD_SUFFIX = "_bold";
    public static final String EDITOR_ITALIC_SUFFIX = "_italic";
    public static final String EDITOR_CORRECTION_INDICATION = "RubyEditor.ShowTemporaryProblem";
    public static final String EDITOR_SHOW_TEXT_HOVER_AFFORDANCE = "PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE";
    public static final String EDITOR_SHOW_SEGMENTS = "org.rubypeople.rdt.ui.editor.showSegments";
    public static final String EDITOR_SYNC_OUTLINE_ON_CURSOR_MOVE = "RubyEditor.SyncOutlineOnCursorMove";
    public static final String EDITOR_SUB_WORD_NAVIGATION = "subWordNavigation";
    public static final String EDITOR_QUICKASSIST_LIGHTBULB = "org.rubypeople.rdt.quickassist.lightbulb";
    public static final String APPEARANCE_MEMBER_SORT_ORDER = "outlinesortoption";
    public static final String APPEARANCE_VISIBILITY_SORT_ORDER = "org.eclipse.jdt.ui.visibility.order";
    public static final String APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER = "org.rubypeople.rdt.ui.enable.visibility.order";
    public static final String APPEARANCE_COMPRESS_PACKAGE_NAMES = "org.rubypeople.rdt.ui.compresspackagenames";
    public static final String APPEARANCE_PKG_NAME_PATTERN_FOR_PKG_VIEW = "PackagesView.pkgNamePatternForPackagesView";
    public static final String EDITOR_TEXT_FONT = "org.rubypeople.rdt.ui.editors.textfont";
    public static final String FORMATTER_PROFILE = "formatter_profile";
    public static final String BROWSING_STACK_VERTICALLY = "org.rubypeople.rdt.ui.browsing.stackVertically";
    public static final String LINK_BROWSING_PROJECTS_TO_EDITOR = "org.rubypeople.rdt.ui.browsing.projectstoeditor";
    public static final String LINK_BROWSING_TYPES_TO_EDITOR = "org.rubypeople.rdt.ui.browsing.typestoeditor";
    public static final String LINK_BROWSING_MEMBERS_TO_EDITOR = "org.rubypeople.rdt.ui.browsing.memberstoeditor";
    public static final String LINK_TYPEHIERARCHY_TO_EDITOR = "org.rubypeople.rdt.ui.packages.linktypehierarchytoeditor";
    public static final String EDITOR_STRIKETHROUGH_SUFFIX = "_strikethrough";
    public static final String EDITOR_UNDERLINE_SUFFIX = "_underline";
    public static final String EDITOR_MATCHING_BRACKETS = "matchingBrackets";
    public static final String EDITOR_MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    public static final String HOVERS_ENABLED = "hovers_enabled";
    public static final String CODEASSIST_AUTOACTIVATION = "content_assist_autoactivation";
    public static final String CODEASSIST_AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    public static final String CODEASSIST_AUTOINSERT = "content_assist_autoinsert";
    public static final String CODEASSIST_INSERT_COMPLETION = "content_assist_insert_completion";
    public static final String CODEASSIST_FILL_ARGUMENT_NAMES = "content_assist_fill_method_arguments";
    public static final String CODEASSIST_FILL_METHOD_BLOCK_ARGUMENTS = "content_assist_fill_method_block_arguments";
    public static final String CODEASSIST_PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    public static final String CODEASSIST_PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    public static final String CODEASSIST_PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    public static final String CODEASSIST_PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    public static final String CODEASSIST_REPLACEMENT_BACKGROUND = "content_assist_completion_replacement_background";
    public static final String CODEASSIST_REPLACEMENT_FOREGROUND = "content_assist_completion_replacement_foreground";
    public static final String CODEASSIST_PREFIX_COMPLETION = "content_assist_prefix_completion";
    public static final String EDITOR_CLOSE_STRINGS = "closeStrings";
    public static final String EDITOR_CLOSE_BRACKETS = "closeBrackets";
    public static final String EDITOR_CLOSE_BRACES = "closeBraces";
    public static final String EDITOR_END_STATEMENTS = "endStatements";
    public static final String EDITOR_SMART_HOME_END = "AbstractTextEditor.Navigation.SmartHomeEnd";
    public static final String EDITOR_MARK_OCCURRENCES = "markOccurrences";
    public static final String EDITOR_STICKY_OCCURRENCES = "stickyOccurrences";
    public static final String EDITOR_MARK_TYPE_OCCURRENCES = "markTypeOccurrences";
    public static final String EDITOR_MARK_METHOD_OCCURRENCES = "markMethodOccurrences";
    public static final String EDITOR_MARK_FIELD_OCCURRENCES = "markFieldOccurrences";
    public static final String EDITOR_MARK_CONSTANT_OCCURRENCES = "markConstantOccurrences";
    public static final String EDITOR_MARK_LOCAL_VARIABLE_OCCURRENCES = "markLocalVariableOccurrences";
    public static final String EDITOR_MARK_METHOD_EXIT_POINTS = "markMethodExitPoints";
    public static final String EDITOR_USER_KEYWORDS = "userDefinedKeywords";
    public static final String SRCBIN_FOLDERS_IN_NEWPROJ = "org.rubypeople.rdt.ui.wizards.srcFoldersInNewProjects";
    public static final String SRCBIN_SRCNAME = "org.rubypeople.rdt.ui.wizards.srcFoldersSrcName";
    public static final String TYPEFILTER_ENABLED = "org.rubypeople.rdt.ui.typefilter.enabled";
    public static final String SHOW_CU_CHILDREN = "org.rubypeople.rdt.ui.packages.cuchildren";
    public static final String LINK_PACKAGES_TO_EDITOR = "org.rubypeople.rdt.ui.packages.linktoeditor";
    public static final String EDITOR_TEXT_HOVER_MODIFIERS = "hoverModifiers";
    public static final String EDITOR_TEXT_HOVER_MODIFIER_MASKS = "hoverModifierMasks";
    public static final String ID_BESTMATCH_HOVER = "org.rubypeople.rdt.ui.BestMatchHover";
    public static final String ID_SOURCE_HOVER = "org.rubypeople.rdt.ui.RubySourceHover";
    public static final String SEARCH_USE_REDUCED_MENU = "Search.usereducemenu";
    public static final String SPELLING_IGNORE_DIGITS = "spelling_ignore_digits";
    public static final String SPELLING_IGNORE_MIXED = "spelling_ignore_mixed";
    public static final String SPELLING_IGNORE_SENTENCE = "spelling_ignore_sentence";
    public static final String SPELLING_IGNORE_UPPER = "spelling_ignore_upper";
    public static final String SPELLING_IGNORE_URLS = "spelling_ignore_urls";
    public static final String SPELLING_LOCALE = "spelling_locale";
    public static final String SPELLING_PROPOSAL_THRESHOLD = "spelling_proposal_threshold";
    public static final String SPELLING_USER_DICTIONARY = "spelling_user_dictionary";
    public static final String SPELLING_ENABLE_CONTENTASSIST = "spelling_enable_contentassist";
    public static final String LINK_BROWSING_PACKAGES_TO_EDITOR = "org.rubypeople.rdt.ui.browsing.packagestoeditor";
    public static final String DOUBLE_CLICK = "rubyexplorer.doubleclick";
    public static final String DOUBLE_CLICK_GOES_INTO = "rubyexplorer.gointo";
    public static final String DOUBLE_CLICK_EXPANDS = "rubyexplorer.doubleclick.expands";
    public static final String CODEASSIST_EXCLUDED_CATEGORIES = "content_assist_disabled_computers";
    public static final String CODEASSIST_CATEGORY_ORDER = "content_assist_category_order";
    public static final String CODEASSIST_SORTER = "content_assist_sorter";
    public static final String CODEASSIST_AUTOACTIVATION_TRIGGERS_RUBY = "content_assist_autoactivation_triggers_ruby";

    private PreferenceConstants() {
    }

    private static String getDefaultRubyVMLibraries() {
        StringBuffer buf = new StringBuffer();
        ILoadpathEntry cntentry = PreferenceConstants.getRubyVMContainerEntry();
        buf.append(PreferenceConstants.encodeRubyVMLibrary(PreferencesMessages.NewRubyProjectPreferencePage_jre_container_description, new ILoadpathEntry[]{cntentry}));
        buf.append(';');
        ILoadpathEntry varentry = PreferenceConstants.getRubyVMVariableEntry();
        buf.append(PreferenceConstants.encodeRubyVMLibrary(PreferencesMessages.NewRubyProjectPreferencePage_jre_variable_description, new ILoadpathEntry[]{varentry}));
        buf.append(';');
        return buf.toString();
    }

    private static ILoadpathEntry getRubyVMVariableEntry() {
        return RubyCore.newVariableEntry((IPath)new Path("RUBY_LIB"));
    }

    public static String encodeRubyVMLibrary(String desc, ILoadpathEntry[] cpentries) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < cpentries.length) {
            ILoadpathEntry entry = cpentries[i];
            buf.append(PreferenceConstants.encode(desc));
            buf.append(' ');
            buf.append(entry.getEntryKind());
            buf.append(' ');
            buf.append(PreferenceConstants.encodePath(entry.getPath()));
            buf.append(' ');
            buf.append(entry.isExported());
            buf.append(' ');
            ++i;
        }
        return buf.toString();
    }

    private static String encodePath(IPath path) {
        if (path == null) {
            return "#";
        }
        if (path.isEmpty()) {
            return "&";
        }
        return PreferenceConstants.encode(path.toPortableString());
    }

    private static String encode(String str) {
        try {
            return URLEncoder.encode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            RubyPlugin.log(e);
            return "";
        }
    }

    public static void initializeDefaultValues(IPreferenceStore store) {
        store.setDefault(EDITOR_SHOW_SEGMENTS, false);
        store.setDefault("org.rubypeople.rdt.ui.wizards.rubyvm.list", PreferenceConstants.getDefaultRubyVMLibraries());
        store.setDefault("org.rubypeople.rdt.ui.wizards.rubyvm.index", 0);
        store.setDefault(DEBUGGER_USE_RUBY_DEBUG, false);
        store.setDefault(LINK_PACKAGES_TO_EDITOR, false);
        store.setDefault(LINK_TYPEHIERARCHY_TO_EDITOR, false);
        store.setDefault(DOUBLE_CLICK, DOUBLE_CLICK_EXPANDS);
        store.setDefault(LINK_BROWSING_PACKAGES_TO_EDITOR, true);
        store.setDefault(LINK_BROWSING_PROJECTS_TO_EDITOR, true);
        store.setDefault(LINK_BROWSING_TYPES_TO_EDITOR, true);
        store.setDefault(LINK_BROWSING_MEMBERS_TO_EDITOR, true);
        store.setDefault(SEARCH_USE_REDUCED_MENU, false);
        store.setDefault(APPEARANCE_MEMBER_SORT_ORDER, "T,SF,SM,F,C,M");
        store.setDefault(APPEARANCE_VISIBILITY_SORT_ORDER, "B,V,R");
        store.setDefault(APPEARANCE_ENABLE_VISIBILITY_SORT_ORDER, false);
        store.setDefault("MemberFilterActionGroup.org.rubypeople.rdt.ui.RubyOutlinePage.4", true);
        store.setDefault(APPEARANCE_COMPRESS_PACKAGE_NAMES, false);
        store.setDefault(APPEARANCE_PKG_NAME_PATTERN_FOR_PKG_VIEW, "");
        store.setDefault(BROWSING_STACK_VERTICALLY, false);
        store.setDefault(SHOW_CU_CHILDREN, true);
        store.setDefault(EDITOR_CORRECTION_INDICATION, true);
        store.setDefault(TYPEFILTER_ENABLED, "");
        store.setDefault(EDITOR_FOLDING_ENABLED, true);
        store.setDefault(EDITOR_FOLDING_PROVIDER, "org.rubypeople.rdt.ui.text.defaultFoldingProvider");
        store.setDefault(EDITOR_FOLDING_RDOC, false);
        store.setDefault(EDITOR_FOLDING_INNERTYPES, false);
        store.setDefault(EDITOR_FOLDING_METHODS, false);
        store.setDefault(SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        store.setDefault(SPELLING_IGNORE_DIGITS, true);
        store.setDefault(SPELLING_IGNORE_MIXED, true);
        store.setDefault(SPELLING_IGNORE_SENTENCE, true);
        store.setDefault(SPELLING_IGNORE_UPPER, true);
        store.setDefault(SPELLING_IGNORE_URLS, true);
        store.setDefault(SPELLING_USER_DICTIONARY, "");
        store.setDefault(SPELLING_PROPOSAL_THRESHOLD, 20);
        store.setDefault(SPELLING_ENABLE_CONTENTASSIST, false);
        store.setDefault(EDITOR_MATCHING_BRACKETS, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)EDITOR_MATCHING_BRACKETS_COLOR, (RGB)new RGB(192, 192, 192));
        store.setDefault(HOVERS_ENABLED, true);
        store.setDefault(CODEASSIST_AUTOACTIVATION, false);
        store.setDefault(CODEASSIST_AUTOACTIVATION_DELAY, 200);
        store.setDefault(CODEASSIST_AUTOACTIVATION_TRIGGERS_RUBY, ".");
        store.setDefault(CODEASSIST_AUTOINSERT, true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_PROPOSALS_BACKGROUND, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_PROPOSALS_FOREGROUND, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_PARAMETERS_BACKGROUND, (RGB)new RGB(255, 255, 255));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_PARAMETERS_FOREGROUND, (RGB)new RGB(0, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_REPLACEMENT_BACKGROUND, (RGB)new RGB(255, 255, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)CODEASSIST_REPLACEMENT_FOREGROUND, (RGB)new RGB(255, 0, 0));
        store.setDefault(CODEASSIST_INSERT_COMPLETION, true);
        store.setDefault(CODEASSIST_FILL_ARGUMENT_NAMES, true);
        store.setDefault(CODEASSIST_FILL_METHOD_BLOCK_ARGUMENTS, true);
        store.setDefault(CODEASSIST_PREFIX_COMPLETION, false);
        store.setDefault(CODEASSIST_EXCLUDED_CATEGORIES, "org.rubypeople.rdt.ui.spellingProposalCategory\u0000org.eclipse.rdt.ui.textProposalCategory\u0000");
        store.setDefault(CODEASSIST_CATEGORY_ORDER, "org.rubypeople.rdt.ui.spellingProposalCategory:65545\u0000org.rubypeople.rdt.ui.rubyTypeProposalCategory:65540\u0000org.rubypeople.rdt.ui.rubyNoTypeProposalCategory:65539\u0000org.rubypeople.rdt.ui.textProposalCategory:65541\u0000org.rubypeople.rdt.ui.templateProposalCategory:2\u0000");
        store.setDefault(CODEASSIST_SORTER, "org.rubypeople.rdt.ui.RelevanceSorter");
        store.setDefault(EDITOR_USER_KEYWORDS, "");
        store.setDefault(EDITOR_SUB_WORD_NAVIGATION, true);
        store.setDefault(EDITOR_CLOSE_STRINGS, true);
        store.setDefault(EDITOR_CLOSE_BRACKETS, true);
        store.setDefault(EDITOR_CLOSE_BRACES, true);
        store.setDefault(EDITOR_END_STATEMENTS, true);
        store.setDefault(FORMATTER_PROFILE, "org.rubypeople.rdt.ui.default.eclipse_profile");
        store.setDefault(EDITOR_SYNC_OUTLINE_ON_CURSOR_MOVE, true);
        store.setDefault(EDITOR_EVALUTE_TEMPORARY_PROBLEMS, true);
        store.setDefault(EDITOR_SHOW_TEXT_HOVER_AFFORDANCE, true);
        store.setDefault(EDITOR_MARK_OCCURRENCES, true);
        store.setDefault(EDITOR_STICKY_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_TYPE_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_METHOD_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_CONSTANT_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_FIELD_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_LOCAL_VARIABLE_OCCURRENCES, true);
        store.setDefault(EDITOR_MARK_METHOD_EXIT_POINTS, true);
        int sourceHoverModifier = SWT.MOD2;
        String sourceHoverModifierName = Action.findModifierString((int)sourceHoverModifier);
        store.setDefault(EDITOR_TEXT_HOVER_MODIFIERS, "org.rubypeople.rdt.ui.BestMatchHover;0;org.rubypeople.rdt.ui.RubySourceHover;" + sourceHoverModifierName);
        store.setDefault(EDITOR_TEXT_HOVER_MODIFIER_MASKS, "org.rubypeople.rdt.ui.BestMatchHover;0;org.rubypeople.rdt.ui.RubySourceHover;" + sourceHoverModifier);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_default", (RGB)new RGB(0, 0, 0));
        store.setDefault("color_ruby_default_bold", false);
        store.setDefault("color_ruby_default_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_keyword", (RGB)new RGB(164, 53, 122));
        store.setDefault("color_ruby_keyword_bold", true);
        store.setDefault("color_ruby_keyword_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_error", (RGB)new RGB(255, 255, 255));
        store.setDefault("color_ruby_error_bold", true);
        store.setDefault("color_ruby_error_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_error_background", (RGB)new RGB(255, 0, 0));
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_string", (RGB)new RGB(42, 0, 255));
        store.setDefault("color_ruby_string_bold", false);
        store.setDefault("color_ruby_string_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_regexp", (RGB)new RGB(90, 30, 160));
        store.setDefault("color_ruby_regexp_bold", false);
        store.setDefault("color_ruby_regexp_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_command", (RGB)new RGB(0, 128, 128));
        store.setDefault("color_ruby_command_bold", false);
        store.setDefault("color_ruby_command_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_fixnum", (RGB)new RGB(0, 128, 255));
        store.setDefault("color_ruby_fixnum_bold", true);
        store.setDefault("color_ruby_fixnum_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_character", (RGB)new RGB(255, 128, 128));
        store.setDefault("color_ruby_character_bold", true);
        store.setDefault("color_ruby_character_italic", true);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_symbol", (RGB)new RGB(255, 64, 64));
        store.setDefault("color_ruby_symbol_bold", true);
        store.setDefault("color_ruby_symbol_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_instance_variable", (RGB)new RGB(0, 64, 128));
        store.setDefault("color_ruby_instance_variable_bold", true);
        store.setDefault("color_ruby_instance_variable_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_global", (RGB)new RGB(255, 0, 0));
        store.setDefault("color_ruby_global_bold", false);
        store.setDefault("color_ruby_global_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_multiline_comment", (RGB)new RGB(63, 127, 95));
        store.setDefault("color_ruby_multiline_comment_bold", false);
        store.setDefault("color_ruby_multiline_comment_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_singleline_comment", (RGB)new RGB(63, 127, 95));
        store.setDefault("color_ruby_singleline_comment_bold", false);
        store.setDefault("color_ruby_singleline_comment_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_task", (RGB)new RGB(127, 159, 191));
        store.setDefault("color_ruby_task_bold", true);
        store.setDefault("color_ruby_task_italic", false);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"color_ruby_content_assistant_background", (RGB)new RGB(150, 150, 0));
    }

    public static IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public static ILoadpathEntry[] getDefaultRubyVMLibrary() {
        ILoadpathEntry[] res;
        IPreferenceStore store = RubyPlugin.getDefault().getPreferenceStore();
        String str = store.getString("org.rubypeople.rdt.ui.wizards.rubyvm.list");
        int index = store.getInt("org.rubypeople.rdt.ui.wizards.rubyvm.index");
        StringTokenizer tok = new StringTokenizer(str, ";");
        while (tok.hasMoreTokens() && index > 0) {
            tok.nextToken();
            --index;
        }
        if (tok.hasMoreTokens() && (res = PreferenceConstants.decodeRubyVMLibraryLoadpathEntries(tok.nextToken())).length > 0) {
            return res;
        }
        return new ILoadpathEntry[]{PreferenceConstants.getRubyVMContainerEntry()};
    }

    private static ILoadpathEntry getRubyVMContainerEntry() {
        return RubyCore.newContainerEntry((IPath)new Path("org.rubypeople.rdt.launching.RUBY_CONTAINER"));
    }

    public static ILoadpathEntry[] decodeRubyVMLibraryLoadpathEntries(String encoded) {
        StringTokenizer tok = new StringTokenizer(encoded, " ");
        ArrayList<ILoadpathEntry> res = new ArrayList<ILoadpathEntry>();
        while (tok.hasMoreTokens()) {
            String message;
            try {
                tok.nextToken();
                int kind = Integer.parseInt(tok.nextToken());
                IPath path = PreferenceConstants.decodePath(tok.nextToken());
                boolean isExported = Boolean.valueOf(tok.nextToken());
                switch (kind) {
                    case 3: {
                        res.add(RubyCore.newSourceEntry((IPath)path));
                        break;
                    }
                    case 1: {
                        res.add(RubyCore.newLibraryEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 4: {
                        res.add(RubyCore.newVariableEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 2: {
                        res.add(RubyCore.newProjectEntry((IPath)path, (boolean)isExported));
                        break;
                    }
                    case 5: {
                        res.add(RubyCore.newContainerEntry((IPath)path, (boolean)isExported));
                    }
                }
            }
            catch (NumberFormatException e) {
                message = PreferencesMessages.NewRubyProjectPreferencePage_error_decode;
                RubyPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, message, (Throwable)e));
            }
            catch (NoSuchElementException e) {
                message = PreferencesMessages.NewRubyProjectPreferencePage_error_decode;
                RubyPlugin.log((IStatus)new Status(4, "org.rubypeople.rdt.ui", 4, message, (Throwable)e));
            }
        }
        return res.toArray(new ILoadpathEntry[res.size()]);
    }

    private static IPath decodePath(String str) {
        if ("#".equals(str)) {
            return null;
        }
        if ("&".equals(str)) {
            return Path.EMPTY;
        }
        return Path.fromPortableString((String)PreferenceConstants.decode(str));
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, fgDefaultEncoding);
        }
        catch (UnsupportedEncodingException e) {
            RubyPlugin.log(e);
            return "";
        }
    }

    public static String getPreference(String key, IRubyProject project) {
        String val;
        if (project != null && (val = new ProjectScope(project.getProject()).getNode("org.rubypeople.rdt.ui").get(key, null)) != null) {
            return val;
        }
        val = new InstanceScope().getNode("org.rubypeople.rdt.ui").get(key, null);
        if (val != null) {
            return val;
        }
        return new DefaultScope().getNode("org.rubypeople.rdt.ui").get(key, null);
    }
}

