/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.SharedImages;
import org.rubypeople.rdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.ui.ISharedImages;
import org.rubypeople.rdt.ui.IWorkingCopyManager;
import org.rubypeople.rdt.ui.dialogs.TypeSelectionExtension;

public final class RubyUI {
    private static ISharedImages fgSharedImages = null;
    public static final String ID_PLUGIN = "org.rubypeople.rdt.ui";
    public static final String ID_ACTION_SET = "org.rubypeople.rdt.ui.rubyActionSet";
    public static final String ID_RUBY_EDITOR = "org.rubypeople.rdt.ui.EditorRubyFile";
    public static final String ID_EXTERNAL_EDITOR = "org.rubypeople.rdt.ui.ExternalRubyEditor";
    public static String ID_PROJECTS_VIEW = "org.rubypeople.rdt.ui.ProjectsView";
    public static String ID_TYPES_VIEW = "org.rubypeople.rdt.ui.TypesView";
    public static String ID_MEMBERS_VIEW = "org.rubypeople.rdt.ui.MembersView";
    public static final String ID_ELEMENT_CREATION_ACTION_SET = "org.rubypeople.rdt.ui.RubyElementCreationActionSet";
    public static final String ID_PERSPECTIVE = "org.rubypeople.rdt.ui.PerspectiveRuby";
    public static final String ID_TYPE_HIERARCHY = "org.rubypeople.rdt.ui.TypeHierarchy";
    public static final String ID_HIERARCHYPERSPECTIVE = "org.rubypeople.rdt.ui.RubyHierarchyPerspective";
    public static final String ID_RUBY_EXPLORER = "org.rubypeople.rdt.ui.RubyExplorer";
    public static final String ID_RUBY_RESOURCE_VIEW = "org.rubypeople.rdt.ui.ViewRubyResources";
    public static final String ID_RULER_CONTEXT_MENU = "org.rubypeople.rdt.ui.rubyeditor.rulerContextMenu";
    public static final String ID_EDITOR_CONTEXT_MENU = "org.rubypeople.rdt.ui.rubyeditor.contextMenu";

    private RubyUI() {
    }

    public static IRubyElement getEditorInputRubyElement(IEditorInput editorInput) {
        Assert.isNotNull((Object)editorInput);
        IRubyScript re = RubyUI.getWorkingCopyManager().getWorkingCopy(editorInput);
        if (re != null) {
            return re;
        }
        re = (IRubyElement)editorInput.getAdapter(IRubyElement.class);
        if (re != null) {
            return re;
        }
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IFile file = fileInput.getFile();
            re = RubyCore.create((IFile)file);
        }
        return re;
    }

    public static ISharedImages getSharedImages() {
        if (fgSharedImages == null) {
            fgSharedImages = new SharedImages();
        }
        return fgSharedImages;
    }

    public static IWorkingCopyManager getWorkingCopyManager() {
        return RubyPlugin.getDefault().getWorkingCopyManager();
    }

    public static IDocumentProvider getDocumentProvider() {
        return RubyPlugin.getDefault().getRubyDocumentProvider();
    }

    public static void revealInEditor(IEditorPart part, IRubyElement element) {
        EditorUtility.revealInEditor(part, element);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IRubySearchScope scope, int elementKinds, boolean multipleSelection) throws RubyModelException {
        return RubyUI.createTypeDialog(parent, context, scope, elementKinds, multipleSelection, "");
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IRubySearchScope scope, int elementKinds, boolean multipleSelection, String filter) throws RubyModelException {
        return RubyUI.createTypeDialog(parent, context, scope, elementKinds, multipleSelection, filter, null);
    }

    public static SelectionDialog createTypeDialog(Shell parent, IRunnableContext context, IRubySearchScope scope, int elementKinds, boolean multipleSelection, String filter, TypeSelectionExtension extension) throws RubyModelException {
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(parent, multipleSelection, context, scope, elementKinds, extension);
        dialog.setMessage(RubyUIMessages.RubyUI_defaultDialogMessage);
        dialog.setFilter(filter);
        return dialog;
    }

    public static IEditorPart openInEditor(IRubyElement element) throws RubyModelException, PartInitException {
        return EditorUtility.openInEditor(element);
    }
}

