/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewElementWizard;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;

public abstract class AbstractOpenWizardAction
extends Action {
    private Shell fShell = null;
    private IStructuredSelection fSelection = null;
    private IRubyElement fCreatedElement = null;

    protected AbstractOpenWizardAction() {
    }

    public void run() {
        Shell shell = this.getShell();
        if (!this.doCreateProjectFirstOnEmptyWorkspace(shell)) {
            return;
        }
        try {
            INewWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), this.getSelection());
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (shell != null) {
                PixelConverter converter = new PixelConverter((Control)shell);
                dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            }
            dialog.create();
            int res = dialog.open();
            if (res == 0 && wizard instanceof NewElementWizard) {
                this.fCreatedElement = ((NewElementWizard)wizard).getCreatedElement();
            }
            this.notifyResult(res == 0);
        }
        catch (CoreException e) {
            String title = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    protected abstract INewWizard createWizard() throws CoreException;

    protected IStructuredSelection getSelection() {
        if (this.fSelection == null) {
            return this.evaluateCurrentSelection();
        }
        return this.fSelection;
    }

    private IStructuredSelection evaluateCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = RubyPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    protected Shell getShell() {
        if (this.fShell == null) {
            return RubyPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }

    public void setShell(Shell shell) {
        this.fShell = shell;
    }

    protected boolean doCreateProjectFirstOnEmptyWorkspace(Shell shell) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (workspaceRoot.getProjects().length == 0) {
            String title = NewWizardMessages.AbstractOpenWizardAction_noproject_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_noproject_message;
            if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) {
                new NewProjectAction().run();
                return workspaceRoot.getProjects().length != 0;
            }
            return false;
        }
        return true;
    }

    public IRubyElement getCreatedElement() {
        return this.fCreatedElement;
    }
}

