/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IField;
import org.rubypeople.rdt.core.IImportDeclaration;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.ISourceFolder;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.RubySearchScopeFactory;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.actions.FindAction;
import org.rubypeople.rdt.ui.search.ElementQuerySpecification;
import org.rubypeople.rdt.ui.search.QuerySpecification;

public class FindReferencesAction
extends FindAction {
    public FindReferencesAction(IWorkbenchSite site) {
        super(site);
    }

    public FindReferencesAction(RubyEditor editor) {
        super(editor);
    }

    Class[] getValidTypes() {
        return new Class[]{IRubyScript.class, IType.class, IMethod.class, IField.class, IImportDeclaration.class, ISourceFolder.class};
    }

    void init() {
        this.setText(SearchMessages.Search_FindReferencesAction_label);
        this.setToolTipText(SearchMessages.Search_FindReferencesAction_tooltip);
        this.setImageDescriptor(RubyPluginImages.DESC_OBJS_SEARCH_REF);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.find_references_in_workspace_action");
    }

    int getLimitTo() {
        return 1;
    }

    QuerySpecification createQuery(IRubyElement element) throws RubyModelException {
        RubySearchScopeFactory factory = RubySearchScopeFactory.getInstance();
        boolean isInsideJRE = factory.isInsideRubyVMLibraries(element);
        IRubySearchScope scope = factory.createWorkspaceScope(isInsideJRE);
        String description = factory.getWorkspaceScopeDescription(isInsideJRE);
        return new ElementQuerySpecification(element, this.getLimitTo(), scope, description);
    }
}

