/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.internal.ui.search.SearchMessages;
import org.rubypeople.rdt.ui.actions.FindOccurrencesInFileAction;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private RubyEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(site);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fOccurrencesInFileAction, provider, selection);
    }

    public OccurrencesSearchGroup(RubyEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.rubypeople.rdt.ui.edit.text.ruby.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fEditor.setAction("SearchOccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private IAction[] getActions() {
        IAction[] actions = new IAction[]{this.fOccurrencesInFileAction};
        return actions;
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = SearchMessages.group_occurrences;
        String shortcut = this.getShortcutString();
        if (shortcut != null) {
            Object[] args = new String[]{menuText, shortcut};
            menuText = Messages.format(ActionMessages.QuickMenuAction_menuTextWithShortcut, args);
        }
        MenuManager javaSearchMM = new MenuManager(menuText, "group.search");
        IAction[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            IAction action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add(action);
            }
            ++i;
        }
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    private String getShortcutString() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.rubypeople.rdt.ui.edit.text.ruby.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fOccurrencesInFileAction, provider);
        }
        super.dispose();
        this.fOccurrencesInFileAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.rubypeople.rdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

