/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.RubyUIMessages;
import org.rubypeople.rdt.internal.ui.dialogs.OpenTypeSelectionDialog2;
import org.rubypeople.rdt.internal.ui.rubyeditor.EditorUtility;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;

public class OpenTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    public OpenTypeAction() {
        this.setText(RubyUIMessages.OpenTypeAction_label);
        this.setDescription(RubyUIMessages.OpenTypeAction_description);
        this.setToolTipText(RubyUIMessages.OpenTypeAction_tooltip);
        this.setImageDescriptor(RubyPluginImages.DESC_TOOL_OPENTYPE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.open_type_action");
    }

    public void run() {
        Shell parent = RubyPlugin.getActiveWorkbenchShell();
        OpenTypeSelectionDialog2 dialog = new OpenTypeSelectionDialog2(parent, false, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), null, 0);
        dialog.setTitle(RubyUIMessages.OpenTypeAction_dialogTitle);
        dialog.setMessage(RubyUIMessages.OpenTypeAction_dialogMessage);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            try {
                IEditorPart part = EditorUtility.openInEditor(type, true);
                EditorUtility.revealInEditor(part, (IRubyElement)type);
            }
            catch (CoreException x) {
                String title = RubyUIMessages.OpenTypeAction_errorTitle;
                String message = RubyUIMessages.OpenTypeAction_errorMessage;
                ExceptionHandler.handle(x, title, message);
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

