/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.rubypeople.rdt.core.IOpenable;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.packageview.PackageExplorerPart;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;
import org.rubypeople.rdt.ui.actions.SelectionDispatchAction;

public class ShowInRubyExplorerViewAction
extends SelectionDispatchAction {
    private RubyEditor fEditor;

    public ShowInRubyExplorerViewAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.ShowInPackageViewAction_label);
        this.setDescription(ActionMessages.ShowInPackageViewAction_description);
        this.setToolTipText(ActionMessages.ShowInPackageViewAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.rubypeople.rdt.ui.show_in_packageview_action_context");
    }

    public ShowInRubyExplorerViewAction(RubyEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn((IEditorPart)this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        return selection.getFirstElement() instanceof IRubyElement;
    }

    public void run(ITextSelection selection) {
        try {
            IRubyElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null) {
                this.run(element);
            }
        }
        catch (RubyModelException e) {
            RubyPlugin.log(e);
            String message = ActionMessages.ShowInPackageViewAction_error_message;
            ErrorDialog.openError((Shell)this.getShell(), (String)ShowInRubyExplorerViewAction.getDialogTitle(), (String)message, (IStatus)e.getStatus());
        }
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run((IRubyElement)selection.getFirstElement());
    }

    private void run(IRubyElement element) {
        if (element == null) {
            return;
        }
        IOpenable openable = element.getOpenable();
        if (openable instanceof IRubyElement) {
            element = (IRubyElement)openable;
        }
        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
        view.tryToReveal(element);
    }

    private static String getDialogTitle() {
        return ActionMessages.ShowInPackageViewAction_dialog_title;
    }
}

