/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.corext.util.CodeFormatterUtil;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.IRubyScriptDocumentProvider;
import org.rubypeople.rdt.internal.ui.text.ContentAssistPreference;
import org.rubypeople.rdt.internal.ui.text.HTMLTextPresenter;
import org.rubypeople.rdt.internal.ui.text.RubyAnnotationHover;
import org.rubypeople.rdt.internal.ui.text.RubyCompositeReconcilingStrategy;
import org.rubypeople.rdt.internal.ui.text.RubyDoubleClickSelector;
import org.rubypeople.rdt.internal.ui.text.RubyElementProvider;
import org.rubypeople.rdt.internal.ui.text.RubyOutlineInformationControl;
import org.rubypeople.rdt.internal.ui.text.RubyPartitionScanner;
import org.rubypeople.rdt.internal.ui.text.RubyPresentationReconciler;
import org.rubypeople.rdt.internal.ui.text.RubyReconciler;
import org.rubypeople.rdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.rubypeople.rdt.internal.ui.text.comment.RubyCommentAutoIndentStrategy;
import org.rubypeople.rdt.internal.ui.text.correction.RubyCorrectionAssistant;
import org.rubypeople.rdt.internal.ui.text.hyperlinks.RubyHyperLinkDetector;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyTokenScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyAutoIndentStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyColoringTokenScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCommentScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCompletionProcessor;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyFormattingStrategy;
import org.rubypeople.rdt.internal.ui.text.ruby.SingleTokenRubyScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyEditorTextHoverDescriptor;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyEditorTextHoverProxy;
import org.rubypeople.rdt.internal.ui.text.ruby.hover.RubyInformationProvider;
import org.rubypeople.rdt.ui.text.IColorManager;
import org.rubypeople.rdt.ui.text.RubyTextTools;

public class RubySourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected RubyTextTools textTools;
    protected ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private IColorManager fColorManager;
    protected AbstractRubyTokenScanner fCodeScanner;
    protected AbstractRubyScanner fMultilineCommentScanner;
    protected AbstractRubyScanner fSinglelineCommentScanner;
    protected AbstractRubyScanner fStringScanner;
    protected AbstractRubyScanner fRegexScanner;
    protected AbstractRubyScanner fCommandScanner;
    private RubyDoubleClickSelector fRubyDoubleClickSelector;

    public RubySourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "__dftl_partition_content_type");
        formatter.setMasterStrategy((IFormattingStrategy)new RubyFormattingStrategy());
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__ruby_singleline_comment");
        formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__ruby_multiline_comment");
        return formatter;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (this.fTextEditor == null) {
            return inheritedDetectors;
        }
        int inheritedDetectorsLength = inheritedDetectors != null ? inheritedDetectors.length : 0;
        IHyperlinkDetector[] detectors = new IHyperlinkDetector[inheritedDetectorsLength + 1];
        detectors[0] = new RubyHyperLinkDetector(this.fTextEditor.getEditorInput());
        int i = 0;
        while (i < inheritedDetectorsLength) {
            detectors[i + 1] = inheritedDetectors[i];
            ++i;
        }
        return detectors;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event) || this.fRegexScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
        if (this.fRegexScanner.affectsBehavior(event)) {
            this.fRegexScanner.adaptToPreferenceChange(event);
        }
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new RubyColoringTokenScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new RubyCommentScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_multiline_comment");
        this.fSinglelineCommentScanner = new RubyCommentScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_singleline_comment");
        this.fStringScanner = new SingleTokenRubyScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_string");
        this.fRegexScanner = new SingleTokenRubyScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_regexp");
        this.fCommandScanner = new SingleTokenRubyScanner(this.getColorManager(), this.fPreferenceStore, "color_ruby_command");
    }

    private boolean isNewSetup() {
        return this.textTools == null;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        RubyPresentationReconciler reconciler = new RubyPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer(this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer(this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_multiline_comment");
        dr = new DefaultDamagerRepairer(this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_singleline_comment");
        dr = new DefaultDamagerRepairer(this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_string");
        dr = new DefaultDamagerRepairer(this.getRegexScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_regular_expression");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_regular_expression");
        dr = new DefaultDamagerRepairer(this.getCommandScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__ruby_command");
        reconciler.setRepairer((IPresentationRepairer)dr, "__ruby_command");
        return reconciler;
    }

    protected ITokenScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected ITokenScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected ITokenScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected ITokenScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected ITokenScanner getRegexScanner() {
        return this.fRegexScanner;
    }

    protected ITokenScanner getCommandScanner() {
        return this.fCommandScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return RubyPartitionScanner.LEGAL_CONTENT_TYPES;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            assistant.setRestoreCompletionProposalSize(this.getSettings("completion_proposal_size"));
            RubyCompletionProcessor rubyProcessor = new RubyCompletionProcessor((IEditorPart)this.getEditor(), assistant, "__dftl_partition_content_type");
            assistant.setContentAssistProcessor((IContentAssistProcessor)rubyProcessor, "__dftl_partition_content_type");
            ContentAssistPreference.configure(assistant, this.fPreferenceStore);
            assistant.setContextInformationPopupOrientation(20);
            assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            return assistant;
        }
        return null;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = RubyPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = RubyPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new RubyAnnotationHover(RubyAnnotationHover.VERTICAL_RULER_HOVER);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        if ("__ruby_singleline_comment".equals(contentType) || "__ruby_multiline_comment".equals(contentType)) {
            return new IAutoEditStrategy[]{new RubyCommentAutoIndentStrategy(this.fTextEditor, partitioning, this.getProject())};
        }
        if ("__dftl_partition_content_type".equals(contentType)) {
            return new IAutoEditStrategy[]{new RubyAutoIndentStrategy(partitioning, this.getProject())};
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        RubyInformationProvider provider = new RubyInformationProvider((IEditorPart)this.getEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            RubyCompositeReconcilingStrategy strategy = new RubyCompositeReconcilingStrategy(editor, this.getConfiguredDocumentPartitioning(sourceViewer));
            RubyReconciler reconciler = new RubyReconciler(editor, strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    private IRubyProject getProject() {
        ITextEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IRubyScript element = null;
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider instanceof IRubyScriptDocumentProvider) {
            IRubyScriptDocumentProvider cudp = (IRubyScriptDocumentProvider)provider;
            element = cudp.getWorkingCopy(input);
        }
        if (element == null) {
            return null;
        }
        return element.getRubyProject();
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        IRubyProject project = this.getProject();
        int tabWidth = CodeFormatterUtil.getTabWidth(project);
        int indentWidth = CodeFormatterUtil.getIndentWidth(project);
        int spaceEquivalents = Math.min(tabWidth, indentWidth);
        boolean useSpaces = project == null ? "space".equals(RubyCore.getOption((String)"org.rubypeople.rdt.core.formatter.tabulation.char")) || tabWidth > indentWidth : "space".equals(project.getOption("org.rubypeople.rdt.core.formatter.tabulation.char", true)) || tabWidth > indentWidth;
        int i = 0;
        while (i <= spaceEquivalents) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < spaceEquivalents) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != spaceEquivalents) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fRubyDoubleClickSelector == null) {
            this.fRubyDoubleClickSelector = new RubyDoubleClickSelector();
        }
        return this.fRubyDoubleClickSelector;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return CodeFormatterUtil.getTabWidth(this.getProject());
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        RubyEditorTextHoverDescriptor[] hoverDescs = RubyPlugin.getDefault().getRubyEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new RubyEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        RubyEditorTextHoverDescriptor[] hoverDescs = RubyPlugin.getDefault().getRubyEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        if (this.getEditor() != null) {
            return new RubyCorrectionAssistant(this.getEditor());
        }
        return null;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.rubypeople.rdt.ui.navigate.ruby.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.rubypeople.rdt.ui.edit.text.ruby.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        RubyElementProvider provider = new RubyElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__ruby_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__ruby_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__ruby_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__ruby_regular_expression");
        presenter.setInformationProvider((IInformationProvider)provider, "__ruby_command");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new RubyOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }
}

