/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditorPreferences;
import org.rubypeople.rdt.internal.ui.text.MergingPartitionScanner;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.internal.ui.text.RubyPartitionScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.AbstractRubyTokenScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyColoringTokenScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.RubyCommentScanner;
import org.rubypeople.rdt.internal.ui.text.ruby.SingleTokenRubyScanner;
import org.rubypeople.rdt.ui.text.IColorManager;

public class RubyTextTools {
    protected static String[] keywords;
    protected RubyColorManager fColorManager;
    protected IPartitionTokenScanner partitionScanner;
    protected AbstractRubyTokenScanner fCodeScanner;
    protected AbstractRubyScanner fMultilineCommentScanner;
    protected AbstractRubyScanner fSinglelineCommentScanner;
    protected AbstractRubyScanner FStringScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public RubyTextTools(IPreferenceStore store) {
        this(store, null, true);
    }

    public RubyTextTools(IPreferenceStore store, Preferences coreStore) {
        this(store, coreStore, true);
    }

    public RubyTextTools(IPreferenceStore store, Preferences coreStore, boolean autoDisposeOnDisplayDispose) {
        this.fColorManager = new RubyColorManager(autoDisposeOnDisplayDispose);
        this.partitionScanner = new MergingPartitionScanner();
        this.fCodeScanner = new RubyColoringTokenScanner(this.fColorManager, store);
        this.fMultilineCommentScanner = new RubyCommentScanner(this.fColorManager, store, coreStore, "color_ruby_multiline_comment");
        this.fSinglelineCommentScanner = new RubyCommentScanner(this.fColorManager, store, coreStore, "color_ruby_singleline_comment");
        this.FStringScanner = new SingleTokenRubyScanner(this.fColorManager, store, "color_ruby_string");
        this.fPreferenceStore = store;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.FStringScanner.affectsBehavior(event)) {
            this.FStringScanner.adaptToPreferenceChange(event);
        }
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), RubyPartitionScanner.LEGAL_CONTENT_TYPES);
    }

    protected IPartitionTokenScanner getPartitionScanner() {
        return this.partitionScanner;
    }

    public IPreferenceStore getPreferenceStore() {
        return RubyPlugin.getDefault().getPreferenceStore();
    }

    public static String[] getKeyWords() {
        if (keywords == null) {
            String csvKeywords = RubyEditorPreferences.getString("keywords");
            ArrayList<String> keywordList = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(csvKeywords, ",");
            while (tokenizer.hasMoreTokens()) {
                keywordList.add(tokenizer.nextToken());
            }
            keywords = new String[keywordList.size()];
            keywordList.toArray(keywords);
        }
        return keywords;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.FStringScanner.affectsBehavior(event);
    }

    public void setupRubyDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.partitionScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public Preferences getCorePreferenceStore() {
        return this.fCorePreferenceStore;
    }

    public void setupRubyDocumentPartitioner(IDocument document) {
        this.setupRubyDocumentPartitioner(document, "__dftl_partitioning");
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            RubyTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            RubyTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

