/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text.ansi;

import java.util.LinkedList;
import java.util.List;
import org.rubypeople.rdt.ui.text.ansi.ANSIToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANSIParser {
    public static final byte ESC = 27;
    private static final byte TEXT = 0;
    private static final byte ANSI_ESC_START = 1;
    private static final byte ANSI = 2;

    public List<ANSIToken> parse(String s) {
        if (s == null) {
            return null;
        }
        LinkedList<ANSIToken> tokens = new LinkedList<ANSIToken>();
        ANSIToken t = new ANSIToken();
        int state = 0;
        char[] c = s.toCharArray();
        StringBuffer ansiBuffer = new StringBuffer();
        int i = 0;
        while (i < c.length) {
            switch (state) {
                case 0: {
                    if (c[i] == '\u001b') {
                        state = 1;
                        break;
                    }
                    t.add(c[i]);
                    break;
                }
                case 1: {
                    if (c[i] == '[') {
                        state = 2;
                        tokens.add(t);
                        t = new ANSIToken();
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (c[i] == 'm') {
                        state = 0;
                    }
                    if (c[i] == 'm' || c[i] == ';') {
                        if (ansiBuffer.length() > 0) {
                            try {
                                int value = Integer.parseInt(ansiBuffer.toString());
                                t.addProperty(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        ansiBuffer = new StringBuffer();
                        break;
                    }
                    ansiBuffer.append(c[i]);
                }
            }
            ++i;
        }
        tokens.add(t);
        return tokens;
    }
}

