/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.ui.text.ansi;

import org.eclipse.swt.graphics.RGB;

public class ANSIToken {
    static final byte BOLD = 1;
    static final byte UNDERSCORE = 4;
    static final byte BLACK = 30;
    static final byte BLUE = 34;
    public static final byte CYAN = 36;
    static final byte GREEN = 32;
    static final byte MAGENTA = 35;
    public static final byte RED = 31;
    public static final byte YELLOW = 33;
    private static final int INITIAL_TOKEN_LENGTH = 300;
    boolean bold = false;
    boolean underscore = false;
    int backgroundColor = 0;
    int foregroundColor = 0;
    char[] text = new char[300];
    int textPos = 0;

    public void add(char c) {
        if (this.textPos >= this.text.length) {
            char[] tmp = new char[this.text.length + 300];
            System.arraycopy(this.text, 0, tmp, 0, this.text.length);
            this.text = tmp;
        }
        this.text[this.textPos++] = c;
    }

    public void addProperty(int ansiProp) {
        if (ansiProp <= 8) {
            this.setTextAttribute(ansiProp);
        } else if (ansiProp <= 37) {
            this.foregroundColor = ansiProp;
        } else if (ansiProp <= 47) {
            this.backgroundColor = ansiProp;
        }
    }

    public boolean hasFontStyle() {
        return this.bold || this.underscore;
    }

    public int getFontStyle() {
        if (this.bold && this.underscore) {
            return 3;
        }
        if (this.underscore) {
            return 2;
        }
        if (this.bold) {
            return 1;
        }
        return 0;
    }

    public RGB getForegroundRGB() {
        switch (this.foregroundColor) {
            case 30: {
                return new RGB(0, 0, 0);
            }
            case 31: {
                return new RGB(255, 0, 0);
            }
            case 32: {
                return new RGB(0, 255, 0);
            }
            case 33: {
                return new RGB(255, 255, 0);
            }
            case 34: {
                return new RGB(0, 0, 255);
            }
            case 35: {
                return new RGB(255, 0, 255);
            }
            case 36: {
                return new RGB(0, 255, 255);
            }
        }
        return new RGB(0, 0, 0);
    }

    public String getAnsi() {
        return "\\e[" + this.bold + ";" + this.underscore + ";" + this.foregroundColor + ";" + this.backgroundColor + "m";
    }

    public boolean hasForegroundColor() {
        return this.foregroundColor > 0;
    }

    public void setTextAttribute(int attr) {
        switch (attr) {
            case 1: {
                this.bold = true;
                break;
            }
            case 4: {
                this.underscore = true;
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.textPos) {
            sb.append(this.text[i]);
            ++i;
        }
        return sb.toString();
    }
}

