/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclipsemonkey.lang.ruby;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eclipsemonkey.DOMDescriptor;
import org.eclipse.eclipsemonkey.EclipseMonkeyPlugin;
import org.eclipse.eclipsemonkey.IMonkeyScriptRunner;
import org.eclipse.eclipsemonkey.RunMonkeyException;
import org.eclipse.eclipsemonkey.ScriptMetadata;
import org.eclipse.eclipsemonkey.StoredScript;
import org.eclipse.eclipsemonkey.dom.IMonkeyDOMFactory;
import org.eclipse.eclipsemonkey.dom.Utilities;
import org.eclipse.eclipsemonkey.lang.ruby.RubyScriptConsole;
import org.eclipse.eclipsemonkey.lang.ruby.doms.IRubyDOMFactory;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.builtin.IRubyObject;
import org.osgi.framework.Bundle;

public class RubyScriptRunner
implements IMonkeyScriptRunner {
    private static final String DOM_EXTENSION_POINT = "org.eclipse.eclipsemonkey.dom";
    private static final String CLASS = "class";
    private static final String VARIABLE_NAME = "variableName";
    private static final String RUBY_DOM_EXTENSION_POINT = "org.eclipse.eclipsemonkey.lang.ruby.ruby_dom";
    private static final String BASED_ON = "basedOn";
    private IWorkbenchWindow window;
    private IPath path;
    private StoredScript storedScript;
    private static Ruby fgRuby;

    public RubyScriptRunner(IPath path, IWorkbenchWindow window) {
        this.path = path;
        this.window = window == null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow() : window;
    }

    public StoredScript getStoredScript() {
        return this.storedScript;
    }

    public Object run(String entryName, Object[] functionArgs) throws RunMonkeyException {
        String fileName;
        block7: {
            fileName = this.path.toPortableString();
            Map scriptStore = EclipseMonkeyPlugin.getDefault().getScriptStore();
            this.storedScript = (StoredScript)scriptStore.get(fileName);
            if (this.storedScript.metadata.ensure_doms_are_loaded(this.window)) break block7;
            return null;
        }
        try {
            String script = Utilities.getFileContents((IPath)this.path);
            Ruby ruby = RubyScriptRunner.getJRubyInstance();
            this.defineStandardGlobalVariables(ruby);
            ArrayList<ExtensionDOMLoader> loaders = new ArrayList<ExtensionDOMLoader>();
            loaders.add(new StandardDOMLoader(ruby, this.storedScript.metadata));
            loaders.add(new ExtensionRubyDOMLoader(ruby, this.storedScript.metadata));
            for (ExtensionDOMLoader loader : loaders) {
                loader.run();
            }
            ruby.setCurrentDirectory(this.path.toFile().getParent());
            IRubyObject result = ruby.evalScriptlet(script);
            return result;
        }
        catch (CoreException e) {
            this.error((Exception)((Object)e), fileName, "Core Exception");
        }
        catch (IOException e) {
            this.error(e, fileName, "IO error");
        }
        catch (RaiseException e) {
            this.error((Exception)((Object)e), fileName, e.getException().message.toString());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.error(e, fileName, e.getLocalizedMessage());
        }
        return null;
    }

    private static Ruby getJRubyInstance() {
        if (fgRuby == null) {
            RubyInstanceConfig config = new RubyInstanceConfig();
            PrintStream out = new PrintStream((OutputStream)RubyScriptConsole.getConsoleStream());
            config.setOutput(out);
            fgRuby = Ruby.newInstance((RubyInstanceConfig)config);
            File jrubyHome = RubyScriptRunner.getIncludedJRuby();
            if (jrubyHome != null) {
                fgRuby.setJRubyHome(jrubyHome.getAbsolutePath());
            }
            fgRuby.getLoadService().init(new ArrayList());
        }
        return fgRuby;
    }

    private static File getIncludedJRuby() {
        File file;
        block3: {
            try {
                Bundle bundle = Platform.getBundle((String)"org.jruby");
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(""), null);
                url = FileLocator.toFileURL((URL)url);
                String fileName = url.getFile();
                file = new File(fileName);
                if (file.exists()) break block3;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return file;
    }

    private void defineStandardGlobalVariables(Ruby ruby) {
        this.defineGlobal(ruby, "window", this.window);
    }

    private void defineGlobal(Ruby ruby, String name, Object value) {
        IRubyObject object = JavaUtil.convertJavaToRuby((Ruby)ruby, (Object)value);
        if (object instanceof JavaObject) {
            object = Java.wrap((IRubyObject)ruby.getJavaSupport().getJavaUtilitiesModule(), (IRubyObject)object);
        }
        ruby.defineVariable(new GlobalVariable(ruby, GlobalVariable.variableName((String)name), object));
    }

    private void error(Exception x, String fileName, String string) throws RunMonkeyException {
        RunMonkeyException e = new RunMonkeyException(x.getClass().getName(), fileName, null, string);
        PrintStream cs = new PrintStream((OutputStream)RubyScriptConsole.getConsoleStream());
        cs.println(string);
        cs.println(x.getLocalizedMessage());
        x.printStackTrace(cs);
        throw e;
    }

    private abstract class ExtensionDOMLoader {
        protected ScriptMetadata metadata;
        protected Ruby ruby;

        public ExtensionDOMLoader(Ruby ruby, ScriptMetadata metadata) {
            this.ruby = ruby;
            this.metadata = metadata;
        }

        public void run() throws IOException {
            IExtension[] extensions = this.getExtensions(this.getExtensionPoint());
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurations = extension.getConfigurationElements();
                int j = 0;
                while (j < configurations.length) {
                    IConfigurationElement element = configurations[j];
                    try {
                        IExtension declaring = element.getDeclaringExtension();
                        String declaring_plugin_id = declaring.getNamespaceIdentifier();
                        if (this.metadata.containsDOM_by_plugin(declaring_plugin_id)) {
                            this.checkExtensionPointSpecifics(element);
                            String variableName = element.getAttribute(RubyScriptRunner.VARIABLE_NAME);
                            Object object = element.createExecutableExtension(RubyScriptRunner.CLASS);
                            RubyScriptRunner.this.defineGlobal(this.ruby, variableName, this.getRootObject(object));
                        }
                    }
                    catch (InvalidRegistryObjectException invalidRegistryObjectException) {
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i;
            }
        }

        private IExtension[] getExtensions(String extensionPoint) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint(extensionPoint);
            if (point != null) {
                return point.getExtensions();
            }
            return new IExtension[0];
        }

        protected abstract Object getRootObject(Object var1);

        protected abstract String getExtensionPoint();

        protected abstract void checkExtensionPointSpecifics(IConfigurationElement var1) throws IOException;
    }

    private class ExtensionRubyDOMLoader
    extends ExtensionDOMLoader {
        public ExtensionRubyDOMLoader(Ruby ruby, ScriptMetadata metadata) {
            super(ruby, metadata);
        }

        protected void checkExtensionPointSpecifics(IConfigurationElement element) throws IOException {
            String basedOnDOM = element.getAttribute(RubyScriptRunner.BASED_ON);
            if (basedOnDOM != null && basedOnDOM.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*(\\p{Graph}+)\\/((\\p{Alnum}|\\.)+)", 32);
                Matcher m = p.matcher(basedOnDOM);
                while (m.find()) {
                    this.metadata.getDOMs().add(new DOMDescriptor(m.group(1), m.group(2)));
                }
                if (!this.metadata.ensure_doms_are_loaded(RubyScriptRunner.this.window)) {
                    throw new IOException("Cannot load the required DOM extension:\n\n" + basedOnDOM + "\n");
                }
            }
        }

        protected Object getRootObject(Object object) {
            IRubyDOMFactory factory = (IRubyDOMFactory)object;
            return factory.getDOMroot(this.ruby);
        }

        protected String getExtensionPoint() {
            return RubyScriptRunner.RUBY_DOM_EXTENSION_POINT;
        }
    }

    private class StandardDOMLoader
    extends ExtensionDOMLoader {
        public StandardDOMLoader(Ruby ruby, ScriptMetadata metadata) {
            super(ruby, metadata);
        }

        protected String getExtensionPoint() {
            return RubyScriptRunner.DOM_EXTENSION_POINT;
        }

        protected void checkExtensionPointSpecifics(IConfigurationElement element) throws IOException {
        }

        protected Object getRootObject(Object object) {
            IMonkeyDOMFactory factory = (IMonkeyDOMFactory)object;
            return factory.getDOMroot();
        }
    }
}

