/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclipsemonkey.lang.ruby.doms.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Editor
extends RubyObject {
    private static RubyClass __clazz;
    private IEditorPart _editor;

    private static RubyClass createClass(Ruby runtime) {
        if (__clazz == null) {
            RubyClass clazz = runtime.defineClass("Editor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            CallbackFactory fact = runtime.callbackFactory(Editor.class);
            clazz.defineFastMethod("currentOffset", fact.getFastMethod("getCurrentOffset"));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"current_offset"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"currentOffset"));
            clazz.defineFastMethod("source", fact.getFastMethod("getSource"));
            clazz.defineFastMethod("sourceLength", fact.getFastMethod("getSourceLength"));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"source_length"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"sourceLength"));
            clazz.defineFastMethod("id", fact.getFastMethod("getId"));
            clazz.defineFastMethod("close", fact.getFastMethod("close", RubyBoolean.class));
            clazz.defineFastMethod("save", fact.getFastMethod("save"));
            clazz.defineFastMethod("selectionRange", fact.getFastMethod("getSelectionRange"));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"selection_range"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"selectionRange"));
            clazz.defineFastMethod("lineDelimiter", fact.getFastMethod("getLineDelimiter"));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"line_delimiter"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"lineDelimiter"));
            clazz.defineFastMethod("applyEdit", fact.getFastMethod("applyEdit", RubyFixnum.class, RubyFixnum.class, RubyString.class));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"apply_edit"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"applyEdit"));
            clazz.defineFastMethod("selectAndReveal", fact.getFastMethod("selectAndReveal", RubyFixnum.class, RubyFixnum.class));
            clazz.alias_method(runtime.getCurrentContext(), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"select_and_reveal"), (IRubyObject)RubySymbol.newSymbol((Ruby)runtime, (String)"selectAndReveal"));
            __clazz = clazz;
        }
        return __clazz;
    }

    public Editor(Ruby runtime, IEditorPart editor) {
        super(runtime, Editor.createClass(runtime));
        this._editor = editor;
    }

    private IDocument getDocument() {
        ITextEditor editor = this.getTextEditor();
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        return doc;
    }

    public ITextEditor getTextEditor() {
        IEditorPart part = this._editor;
        ITextEditor result = null;
        if (part instanceof ITextEditor) {
            result = (ITextEditor)part;
        }
        return result;
    }

    public RubyString getSource() {
        return this.getRuntime().newString(this.getDocument().get());
    }

    public IRubyObject getSelectionRange() {
        ITextSelection ts = (ITextSelection)this.getTextEditor().getSelectionProvider().getSelection();
        RubyRange range = RubyRange.newRange((Ruby)this.getRuntime(), (ThreadContext)this.getRuntime().getCurrentContext(), (IRubyObject)RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)ts.getOffset()), (IRubyObject)RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)(ts.getOffset() + ts.getLength())), (boolean)false);
        return range;
    }

    public IRubyObject applyEdit(RubyFixnum offset, RubyFixnum deleteLength, RubyString insertText) throws BadLocationException {
        IEditorPart part = this._editor;
        if (part != null && part instanceof ITextEditor) {
            IDocument doc = this.getDocument();
            doc.replace(RubyNumeric.num2int((IRubyObject)offset), RubyNumeric.num2int((IRubyObject)deleteLength), insertText.toString());
        }
        return this.getRuntime().getTrue();
    }

    public RubyString getLineDelimiter() {
        String[] delims;
        IDocument document = this.getDocument();
        RubyString result = this.getRuntime().newString("\n");
        if (document != null && (delims = document.getLegalLineDelimiters()).length > 0) {
            result = this.getRuntime().newString(delims[0]);
        }
        return result;
    }

    public RubyBoolean close(RubyBoolean save) {
        ITextEditor editor = this.getTextEditor();
        if (editor != null) {
            editor.close(save.isTrue());
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public RubyBoolean save() {
        if (this._editor != null) {
            this._editor.doSave(null);
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public RubyString getId() {
        RubyString result = this.getRuntime().newString("");
        if (this._editor != null) {
            result = this.getRuntime().newString(this._editor.getSite().getId());
        }
        return result;
    }

    public RubyFixnum getSourceLength() {
        return this.getRuntime().newFixnum(this.getDocument().getLength());
    }

    public RubyFixnum getCurrentOffset() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        class ResultRef {
            public int result = -1;

            ResultRef() {
            }
        }
        final ResultRef result = new ResultRef();
        display.syncExec(new Runnable(){
            {
            }

            public void run() {
                ITextSelection ts = (ITextSelection)Editor.this.getTextEditor().getSelectionProvider().getSelection();
                result.result = ts.getOffset();
            }
        });
        return this.getRuntime().newFixnum(result.result);
    }

    public RubyBoolean selectAndReveal(RubyFixnum roffset, RubyFixnum rlength) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        final int offset = RubyNumeric.num2int((IRubyObject)roffset);
        final int length = RubyNumeric.num2int((IRubyObject)rlength);
        display.asyncExec(new Runnable(){

            public void run() {
                ITextEditor editor = Editor.this.getTextEditor();
                editor.selectAndReveal(offset, length);
            }
        });
        return this.getRuntime().getTrue();
    }
}

