/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt;

import com.aptana.rdt.AptanaRDTMessages;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.GemListener;
import com.aptana.rdt.core.gems.GemRequirement;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.internal.core.gems.GemManager;
import com.aptana.rdt.internal.core.gems.RubyGemsInitializer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;
import org.osgi.util.tracker.ServiceTracker;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AptanaRDTPlugin
extends Plugin {
    private static final String BIN = "bin";
    public static final String PLUGIN_ID = "com.aptana.rdt";
    public Set<String> optionNames = new HashSet<String>(20);
    public Hashtable<String, String> optionsCache;
    public final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    private ServiceTracker gemManagersTracker;
    static final int PREF_INSTANCE = 0;
    static final int PREF_DEFAULT = 1;
    public static final String COMPILER_PB_UNUSED_PARAMETER = "com.aptana.rdt.compiler.problem.unusedParameter";
    public static final String COMPILER_PB_UNUSED_PRIVATE_MEMBER = "com.aptana.rdt.compiler.problem.unusedPrivateMember";
    public static final String COMPILER_PB_UNNECESSARY_ELSE = "com.aptana.rdt.compiler.problem.unnecessaryElse";
    public static final String COMPILER_PB_LOCAL_MASKS_METHOD = "com.aptana.rdt.compiler.problem.localVariableMasksMethod";
    public static final String COMPILER_PB_MISSPELLED_CONSTRUCTOR = "com.aptana.rdt.compiler.problem.misspelledConstructor";
    public static final String COMPILER_PB_POSSIBLE_ACCIDENTAL_BOOLEAN_ASSIGNMENT = "com.aptana.rdt.compiler.problem.possibleAccidentalBooleanAssignment";
    public static final String COMPILER_PB_CODE_COMPLEXITY_BRANCHES = "com.aptana.rdt.compiler.problem.codeComplexityBranches";
    public static final String COMPILER_PB_CODE_COMPLEXITY_LINES = "com.aptana.rdt.compiler.problem.codeComplexityLines";
    public static final String COMPILER_PB_CODE_COMPLEXITY_RETURNS = "com.aptana.rdt.compiler.problem.codeComplexityReturns";
    public static final String COMPILER_PB_CODE_COMPLEXITY_LOCALS = "com.aptana.rdt.compiler.problem.codeComplexityLocals";
    public static final String COMPILER_PB_CODE_COMPLEXITY_ARGUMENTS = "com.aptana.rdt.compiler.problem.codeComplexityArguments";
    public static final String COMPILER_PB_MAX_LOCALS = "com.aptana.rdt.compiler.problem.maxLocals";
    public static final String COMPILER_PB_MAX_RETURNS = "com.aptana.rdt.compiler.problem.maxReturns";
    public static final String COMPILER_PB_MAX_BRANCHES = "com.aptana.rdt.compiler.problem.maxBranches";
    public static final String COMPILER_PB_MAX_LINES = "com.aptana.rdt.compiler.problem.maxLines";
    public static final String COMPILER_PB_MAX_ARGUMENTS = "com.aptana.rdt.compiler.problem.maxArguments";
    public static final String COMPILER_PB_SIMILAR_VARIABLE_NAMES = "com.aptana.rdt.compiler.problem.similarVariableNames";
    public static final String COMPILER_PB_UNREACHABLE_CODE = "com.aptana.rdt.compiler.problem.unreachableCode";
    public static final String COMPILER_PB_COMPARABLE_MISSING_METHOD = "com.aptana.rdt.compiler.problem.comparableMissingMethod";
    public static final String COMPILER_PB_ENUMERABLE_MISSING_METHOD = "com.aptana.rdt.compiler.problem.enumerableMissingMethod";
    public static final String COMPILER_PB_SUBCLASS_DOESNT_CALL_SUPER = "com.aptana.rdt.compiler.problem.subclassDoesntCallSuper";
    public static final String COMPILER_PB_ASSIGNMENT_PRECEDENCE = "com.aptana.rdt.compiler.problem.assignmentPrecedence";
    public static final String COMPILER_PB_CONSTANT_NAMING_CONVENTION = "com.aptana.rdt.compiler.problem.constantNamingConvention";
    public static final String COMPILER_PB_METHOD_MISSING_NO_RESPOND_TO = "com.aptana.rdt.compiler.problem.methodMissingWithoutRespondTo";
    public static final String COMPILER_PB_DYNAMIC_VARIABLE_ALIASES_LOCAL = "com.aptana.rdt.compiler.problem.dynamicVariableAliasesLocal";
    public static final String COMPILER_PB_LOCAL_VARIABLE_POSSIBLE_ATTRIBUTE_ACCESS = "com.aptana.rdt.compiler.problem.localVariablePossibleAttributeAccess";
    public static final String COMPILER_PB_LOCAL_METHOD_NAMING_CONVENTION = "com.aptana.rdt.compiler.problem.methodOrLocalNamingConvention";
    public static final String COMPILER_PB_UNUSED_LOCAL_VARIABLE = "com.aptana.rdt.compiler.problem.unusedLocalVariable";
    public static final String COMPILER_PB_DEPRECATED_REQUIRE_GEM = "com.aptana.rdt.compiler.problem.deprecatedRequireGem";
    public static final String COMPILER_PB_RETRY_OUTSIDE_RESCUE = "com.aptana.rdtcompiler.problem.retryOutsideRescueBody";
    public static final String COMPILER_PB_DUPLICATE_HASH_KEY = "com.aptana.rdt.compiler.problem.duplicateHashKey";
    public static final String EXTENSION_POINT_GEMS = "gems";
    private static AptanaRDTPlugin plugin;

    public AptanaRDTPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializePreferences();
        context.registerService(IGemManager.class.getName(), (Object)this.getGemManager(), null);
        this.getGemManager().addGemListener(new GemListener(){

            public void managerInitialized() {
                if (AptanaRDTPlugin.this.getGemManager().gemInstalled("ruby-debug-ide")) {
                    this.setRubyDebugUp();
                }
            }

            private void setRubyDebugUp() {
                AptanaRDTPlugin.this.setRubyDebugAsDefault();
                AptanaRDTPlugin.this.removeListener(this);
            }

            public void gemsRefreshed() {
                if (AptanaRDTPlugin.this.getGemManager().gemInstalled("ruby-debug-ide")) {
                    this.setRubyDebugUp();
                }
            }

            public void gemUpdated(Gem gem) {
            }

            public void gemRemoved(Gem gem) {
            }

            public void gemAdded(Gem gem) {
            }
        });
        RubyGemsInitializer job = new RubyGemsInitializer();
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
        this.gemManagersTracker = new ServiceTracker(context, IGemManager.class.getName(), null);
        this.gemManagersTracker.open(true);
    }

    private void initializePreferences() {
        this.preferencesLookup[0] = new InstanceScope().getNode(PLUGIN_ID);
        this.preferencesLookup[1] = new DefaultScope().getNode(PLUGIN_ID);
        Object listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == AptanaRDTPlugin.this.preferencesLookup[0]) {
                    AptanaRDTPlugin.this.preferencesLookup[0] = new InstanceScope().getNode(AptanaRDTPlugin.PLUGIN_ID);
                    AptanaRDTPlugin.this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new RubyModelManager.EclipsePreferencesListener());
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[0].parent()).addNodeChangeListener(listener);
        this.preferencesLookup[0].addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)new RubyModelManager.EclipsePreferencesListener());
        listener = new IEclipsePreferences.INodeChangeListener(){

            public void added(IEclipsePreferences.NodeChangeEvent event) {
            }

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                if (event.getChild() == AptanaRDTPlugin.this.preferencesLookup[1]) {
                    AptanaRDTPlugin.this.preferencesLookup[1] = new DefaultScope().getNode(AptanaRDTPlugin.PLUGIN_ID);
                }
            }
        };
        ((IEclipsePreferences)this.preferencesLookup[1].parent()).addNodeChangeListener(listener);
    }

    protected void setRubyDebugAsDefault() {
        LaunchingPlugin.getDefault().getPluginPreferences().setValue("useRubyDebug", true);
    }

    protected void removeListener(GemListener listener) {
        RubyDebugGemListener job = new RubyDebugGemListener(listener);
        job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        this.gemManagersTracker.close();
        super.stop(context);
        plugin = null;
    }

    public IGemManager[] getGemManagers() {
        Object[] raw = this.gemManagersTracker.getServices();
        if (raw == null || raw.length == 0) {
            return new IGemManager[0];
        }
        ArrayList<IGemManager> gemManagers = new ArrayList<IGemManager>();
        int i = 0;
        while (i < raw.length) {
            gemManagers.add((IGemManager)raw[i]);
            ++i;
        }
        if (gemManagers.contains(this.getGemManager())) {
            gemManagers.remove(this.getGemManager());
        }
        gemManagers.add(0, this.getGemManager());
        return gemManagers.toArray(new IGemManager[gemManagers.size()]);
    }

    public static AptanaRDTPlugin getDefault() {
        return plugin;
    }

    public static File getFileInPlugin(IPath path) {
        try {
            URL installURL = new URL(AptanaRDTPlugin.getDefault().getBundle().getEntry("/"), path.toString());
            URL localURL = FileLocator.toFileURL((URL)installURL);
            return new File(localURL.getFile());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void log(Throwable e) {
        AptanaRDTPlugin.log((IStatus)new Status(4, AptanaRDTPlugin.getPluginId(), -1, AptanaRDTMessages.RubyRedPlugin_internal_error, e));
    }

    public static void log(IStatus status) {
        if (AptanaRDTPlugin.getDefault() != null && AptanaRDTPlugin.getDefault().getLog() != null) {
            AptanaRDTPlugin.getDefault().getLog().log(status);
        } else {
            System.out.println(status.getMessage());
        }
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public Hashtable<String, String> getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        IPreferencesService service = Platform.getPreferencesService();
        for (String propertyName : this.optionNames) {
            String propertyValue = service.get(propertyName, null, (Preferences[])this.preferencesLookup);
            if (propertyValue == null) continue;
            options.put(propertyName, propertyValue);
        }
        this.optionsCache = new Hashtable(options);
        return options;
    }

    public IGemManager getGemManager() {
        return GemManager.getInstance();
    }

    public static IPath findGem(String string) {
        IGemManager gemManager = AptanaRDTPlugin.getDefault().getGemManager();
        if (gemManager == null) {
            return null;
        }
        IPath path = gemManager.getGemPath(string);
        if (path == null) {
            return null;
        }
        IPath[] rubyLibPaths = RubyCore.getLoadpathVariable((String)"GEM_LIB");
        IPath rubyLibPath = null;
        int i = 0;
        while (i < rubyLibPaths.length) {
            if (rubyLibPaths[i].isPrefixOf(path)) {
                rubyLibPath = rubyLibPaths[i];
                break;
            }
            ++i;
        }
        if (rubyLibPath == null) {
            return null;
        }
        Path resPath = new Path("GEM_LIB");
        int k = rubyLibPath.segmentCount();
        while (k < path.segmentCount()) {
            resPath = resPath.append(path.segment(k));
            ++k;
        }
        return resPath;
    }

    public static void log(String string) {
        AptanaRDTPlugin.log((IStatus)new Status(1, PLUGIN_ID, -1, string, null));
    }

    public static void addGemLoadPath(IRubyProject rubyProject, Gem originalGem, IProgressMonitor monitor) throws RubyModelException {
        ArrayList<ILoadpathEntry> list = new ArrayList<ILoadpathEntry>();
        ILoadpathEntry[] original = rubyProject.getRawLoadpath();
        list.addAll((Collection)Arrays.asList(original));
        HashSet<Gem> gems = new HashSet<Gem>();
        gems.add(originalGem);
        Set<GemRequirement> dependencies = AptanaRDTPlugin.getDefault().getGemManager().getDependencies(originalGem);
        for (GemRequirement dependency : dependencies) {
            Gem gem = AptanaRDTPlugin.getDefault().getGemManager().findGem(dependency);
            if (gem == null) continue;
            gems.add(gem);
        }
        for (Gem gem : gems) {
            IPath gemPath = AptanaRDTPlugin.findGem(String.valueOf(gem.getName()) + "-" + gem.getVersion());
            if (gemPath == null) continue;
            list.add(RubyCore.newVariableEntry((IPath)gemPath));
        }
        if (list.size() == original.length) {
            return;
        }
        if (rubyProject.getRawLoadpath().length != original.length) {
            System.out.println("yuck");
        }
        rubyProject.setRawLoadpath(list.toArray(new ILoadpathEntry[list.size()]), monitor);
    }

    public static IPath checkBinDir(String command) {
        List<IPath> paths = AptanaRDTPlugin.getDefault().getGemManager().getGemInstallPaths();
        if (paths == null) {
            return null;
        }
        for (IPath path : paths) {
            IPath possible;
            if (path == null || !(possible = path.removeLastSegments(1).append(BIN).append(command)).toFile().exists()) continue;
            return possible;
        }
        return null;
    }

    public static IPath checkGemBinDir(String gemName, String command) {
        IPath path = AptanaRDTPlugin.getDefault().getGemManager().getGemPath(gemName);
        if (path == null) {
            return null;
        }
        if ((path = path.append(BIN).append(command)).toFile().exists()) {
            return path;
        }
        return null;
    }

    private static class RubyDebugGemListener
    extends Job {
        private GemListener listener;

        public RubyDebugGemListener(GemListener listener) {
            super("Removing temporary gem listener");
            this.listener = listener;
        }

        protected IStatus run(IProgressMonitor monitor) {
            GemManager.getInstance().removeGemListener(this.listener);
            return Status.OK_STATUS;
        }
    }
}

