/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.Gem;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.LocalFileGem;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributedGemRegistry {
    private static Collection<Gem> fContributed;

    private ContributedGemRegistry() {
    }

    public static Collection<Gem> getContributedGems() {
        if (fContributed == null) {
            ArrayList<Gem> gems = new ArrayList<Gem>();
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.aptana.rdt", "gems");
            IConfigurationElement[] configs = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configs.length) {
                IConfigurationElement element = configs[i];
                if ("gem".equals(element.getName())) {
                    try {
                        Gem gem = ContributedGemRegistry.createGem(element);
                        if (gem != null) {
                            gems.add(gem);
                        }
                    }
                    catch (InvalidRegistryObjectException e) {
                        AptanaRDTPlugin.log(e);
                    }
                }
                ++i;
            }
            fContributed = gems;
        }
        return fContributed;
    }

    private static Gem createGem(IConfigurationElement element) {
        boolean install = false;
        String autoInstall = element.getAttribute("auto-install");
        if (autoInstall != null && autoInstall.trim().length() > 0) {
            install = Boolean.parseBoolean(autoInstall);
        }
        if (!install) {
            return null;
        }
        String name = element.getAttribute("name");
        Gem gem = null;
        String path = element.getAttribute("path");
        gem = path == null || path.trim().length() == 0 ? new Gem(name, ContributedGemRegistry.getVersion(element), null) : ContributedGemRegistry.createLocalGem(name, path, element);
        String compiles = element.getAttribute("compiles");
        gem.setCompiles(Boolean.parseBoolean(compiles));
        boolean forceUpdate = false;
        String forceUpdateRaw = element.getAttribute("force-update");
        if (forceUpdateRaw != null && forceUpdateRaw.trim().length() > 0) {
            forceUpdate = Boolean.parseBoolean(forceUpdateRaw);
        }
        gem.setForceUpdate(forceUpdate);
        return gem;
    }

    private static Gem createLocalGem(String name, String path, IConfigurationElement element) {
        Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
        if (url == null) {
            AptanaRDTPlugin.log("Unable to generate a URL for the gem with path: " + path + " in the " + element.getContributor().getName() + " plugin");
            return null;
        }
        LocalFileGem gem = null;
        if (name == null || name.trim().length() == 0) {
            gem = LocalFileGem.create(url);
        } else {
            String platform = element.getAttribute("platform");
            if (platform == null || platform.trim().length() == 0) {
                platform = "ruby";
            }
            gem = new LocalFileGem(url, name, ContributedGemRegistry.getVersion(element), "", platform);
        }
        IConfigurationElement[] dependencies = element.getChildren("dependency");
        int j = 0;
        while (j < dependencies.length) {
            String dependency = dependencies[j].getAttribute("name");
            gem.addDependency(dependency);
            ++j;
        }
        return gem;
    }

    private static String getVersion(IConfigurationElement element) {
        String version = element.getAttribute("version");
        if (version != null) {
            return version;
        }
        return "";
    }

    public static Gem getGem(String name) {
        Collection<Gem> gems = ContributedGemRegistry.filterByPlatform(ContributedGemRegistry.getContributedGems());
        for (Gem gem : gems) {
            if (!gem.getName().equals(name)) continue;
            return gem;
        }
        return null;
    }

    public static Collection<Gem> filterByPlatform(Collection<Gem> gems) {
        HashMap<String, Gem> map = new HashMap<String, Gem>();
        for (Gem gem : gems) {
            if (map.containsKey(gem.getName())) {
                if (RubyRuntime.currentVMIsJRuby() && gem.getPlatform().equals("java")) {
                    map.put(gem.getName(), gem);
                }
                if (RubyRuntime.currentVMIsJRuby() || !Platform.getOS().equals("win32") || !gem.getPlatform().equals("mswin32") || RubyRuntime.currentVMIsCygwin()) continue;
                map.put(gem.getName(), gem);
                continue;
            }
            if (gem.getPlatform().equals("mswin32") && (!Platform.getOS().equals("win32") || RubyRuntime.currentVMIsJRuby() || RubyRuntime.currentVMIsCygwin()) || !RubyRuntime.currentVMIsJRuby() && gem.getPlatform().equals("java")) continue;
            if (gem instanceof LocalFileGem) {
                LocalFileGem localGem = (LocalFileGem)gem;
                if (RubyRuntime.currentVMIsJRuby() && !gem.getPlatform().equals("java") && localGem.compiles()) continue;
            }
            map.put(gem.getName(), gem);
        }
        return map.values();
    }

    public static List<Gem> sortByDependency(Collection<Gem> gems) {
        gems = new ArrayList<Gem>(gems);
        ArrayList<Gem> sorted = new ArrayList<Gem>();
        while (sorted.size() < gems.size()) {
            for (Gem gem : gems) {
                if (sorted.size() == gems.size()) {
                    return sorted;
                }
                if (sorted.contains(gem)) continue;
                boolean add = true;
                if (gem instanceof LocalFileGem) {
                    LocalFileGem local = (LocalFileGem)gem;
                    Set<String> dependencies = local.getDependencies();
                    for (String dependency : dependencies) {
                        if (ContributedGemRegistry.getGemManager().gemInstalled(dependency) || ContributedGemRegistry.contains(sorted, dependency)) continue;
                        add = false;
                        if (ContributedGemRegistry.contains(gems, dependency)) break;
                        AptanaRDTPlugin.log("Unable to install " + local.toString() + " because we were unable to satisfy it's dependencies!");
                        gems.remove(gem);
                        break;
                    }
                }
                if (!add) continue;
                sorted.add(gem);
            }
        }
        return sorted;
    }

    private static boolean contains(Collection<Gem> gems, String name) {
        for (Gem gem : gems) {
            if (!gem.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static IGemManager getGemManager() {
        return AptanaRDTPlugin.getDefault().getGemManager();
    }
}

