/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import com.aptana.rdt.core.gems.Gem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalGem
extends Gem {
    private Collection<Gem> gems;

    private LogicalGem(Collection<Gem> gems, String name, String version, String description) {
        super(name, version, description);
        this.gems = gems;
    }

    public static LogicalGem create(Collection<Gem> gems) {
        if (gems == null || gems.isEmpty()) {
            throw new IllegalArgumentException("Need a non-null, non-empty Collection of Gems");
        }
        String name = null;
        String description = null;
        String version = "(";
        for (Gem gem : gems) {
            if (name == null) {
                name = gem.getName();
            }
            if (description == null) {
                description = gem.getDescription();
            }
            version = String.valueOf(version) + gem.getVersion() + ", ";
        }
        version = version.substring(0, version.length() - 2);
        version = String.valueOf(version) + ')';
        return new LogicalGem(gems, name, version, description);
    }

    public SortedSet<String> getVersions() {
        String raw = this.getVersion().substring(1, this.getVersion().length() - 1);
        TreeSet<String> version = new TreeSet<String>(new VersionComparator());
        StringTokenizer tokenizer = new StringTokenizer(raw, ",");
        while (tokenizer.hasMoreTokens()) {
            version.add(tokenizer.nextToken().trim());
        }
        return version;
    }

    public Collection<Gem> getGems() {
        return this.gems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VersionComparator
    implements Comparator {
        private VersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            String v1 = (String)o1;
            String v2 = (String)o2;
            List<Integer> v1Parts = this.getParts(v1);
            List<Integer> v2Parts = this.getParts(v2);
            int blah = Math.min(v1Parts.size(), v2Parts.size());
            int i = 0;
            while (i < blah) {
                Integer two;
                Integer one = v1Parts.get(i);
                int result = one.compareTo(two = v2Parts.get(i));
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            if (v1Parts.size() > v2Parts.size()) {
                return 1;
            }
            if (v2Parts.size() > v1Parts.size()) {
                return -1;
            }
            return 0;
        }

        private List<Integer> getParts(String version) {
            StringTokenizer tokenizer = new StringTokenizer(version, ".");
            ArrayList<Integer> parts = new ArrayList<Integer>();
            while (tokenizer.hasMoreTokens()) {
                parts.add(Integer.parseInt(tokenizer.nextToken()));
            }
            return parts;
        }
    }
}

