/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.core.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private String raw;
    private List<String> versions;

    public Version(String raw) {
        this.raw = raw;
        if (this.raw != null) {
            this.raw = this.raw.trim();
            if (this.raw.endsWith(",") && this.raw.length() > 1) {
                this.raw = this.raw.substring(0, this.raw.length() - 1);
            }
            if (this.raw.startsWith(",") && this.raw.length() > 1) {
                this.raw = this.raw.substring(1, this.raw.length());
            }
        }
        if (!Version.correctFormat(this.raw)) {
            throw new IllegalArgumentException("version string must be of format #.#.#(.#)?, instead it was: " + raw);
        }
        this.parse();
    }

    public static boolean correctFormat(String raw) {
        return raw.trim().matches("\\d+\\.\\d+\\.\\d+(\\.\\d+)?");
    }

    private void parse() {
        StringTokenizer tokenizer = new StringTokenizer(this.raw, ".");
        this.versions = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            this.versions.add(tokenizer.nextToken());
        }
    }

    @Override
    public int compareTo(Version o) {
        int diff = this.getMajor() - o.getMajor();
        if (diff != 0) {
            return diff;
        }
        diff = this.getMinor() - o.getMinor();
        if (diff != 0) {
            return diff;
        }
        diff = this.getBugfix() - o.getBugfix();
        if (diff != 0) {
            return diff;
        }
        return this.getRevision() - o.getRevision();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            return this.isEqualTo((Version)obj);
        }
        return false;
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public boolean isGreaterThan(Version other) {
        if (this.getMajor() > other.getMajor()) {
            return true;
        }
        if (this.getMajor() < other.getMajor()) {
            return false;
        }
        if (this.getMinor() > other.getMinor()) {
            return true;
        }
        if (this.getMinor() < other.getMinor()) {
            return false;
        }
        if (this.getBugfix() > other.getBugfix()) {
            return true;
        }
        if (this.getBugfix() < other.getBugfix()) {
            return false;
        }
        if (this.getRevision() > other.getRevision()) {
            return true;
        }
        if (this.getRevision() < other.getRevision()) {
            return false;
        }
        return false;
    }

    public boolean isEqualTo(Version other) {
        if (this.getMajor() != other.getMajor()) {
            return false;
        }
        if (this.getMinor() != other.getMinor()) {
            return false;
        }
        if (this.getBugfix() != other.getBugfix()) {
            return false;
        }
        return this.getRevision() == other.getRevision();
    }

    public boolean isGreaterThanOrEqualTo(Version other) {
        return this.isGreaterThan(other) || this.isEqualTo(other);
    }

    public boolean isLessThan(Version other) {
        if (this.getMajor() > other.getMajor()) {
            return false;
        }
        if (this.getMajor() < other.getMajor()) {
            return true;
        }
        if (this.getMinor() > other.getMinor()) {
            return false;
        }
        if (this.getMinor() < other.getMinor()) {
            return true;
        }
        if (this.getBugfix() > other.getBugfix()) {
            return false;
        }
        if (this.getBugfix() < other.getBugfix()) {
            return true;
        }
        if (this.getRevision() > other.getRevision()) {
            return false;
        }
        return this.getRevision() < other.getRevision();
    }

    public boolean isLessThanOrEqualTo(Version other) {
        return this.isLessThan(other) || this.isEqualTo(other);
    }

    public int getMajor() {
        if (this.versions.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(this.versions.get(0));
    }

    public int getMinor() {
        if (this.versions.size() < 2) {
            return 0;
        }
        return Integer.parseInt(this.versions.get(1));
    }

    public int getBugfix() {
        if (this.versions.size() < 3) {
            return 0;
        }
        return Integer.parseInt(this.versions.get(2));
    }

    public int getRevision() {
        if (this.versions.size() < 4) {
            return 0;
        }
        return Integer.parseInt(this.versions.get(3));
    }

    public String toString() {
        return this.raw;
    }

    public boolean isGreaterThanOrEqualTo(String string) {
        return this.isGreaterThanOrEqualTo(new Version(string));
    }

    public boolean isLessThanOrEqualTo(String string) {
        return this.isLessThanOrEqualTo(new Version(string));
    }

    public boolean isLessThan(String string) {
        return this.isLessThan(new Version(string));
    }
}

