/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.core.gems;

import com.aptana.rdt.core.gems.Gem;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemManagerContentHandler
implements ContentHandler {
    private HashSet<Gem> gems;
    private String name;
    private String version;
    private String description;
    private StringBuffer data = new StringBuffer();
    private String platform;

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = start;
        while (i < start + length) {
            this.data.append(ch[i]);
            ++i;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (qName.equals("name")) {
            this.name = this.data.toString();
        } else if (qName.equals("version")) {
            this.version = this.data.toString();
        } else if (qName.equals("description")) {
            this.description = this.data.toString();
        } else if (qName.equals("platform")) {
            this.platform = this.data.toString();
        } else if (qName.equals("gem")) {
            if (this.version.indexOf(",") != -1) {
                String[] versions = this.version.split(", ");
                int i = 0;
                while (i < versions.length) {
                    this.gems.add(new Gem(this.name, versions[i], this.description, this.platform));
                    ++i;
                }
            } else {
                this.gems.add(new Gem(this.name, this.version, this.description, this.platform));
            }
        }
        this.data.delete(0, this.data.length());
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.gems = new HashSet();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }

    public Set<Gem> getGems() {
        return Collections.unmodifiableSet(this.gems);
    }
}

