/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.launching;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.IGemManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rubypeople.rdt.core.LoadpathVariableInitializer;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.launching.LaunchingPlugin;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

public class GemLoadpathVariablesInitializer
extends LoadpathVariableInitializer
implements IVMInstallChangedListener {
    private static final String LEOPARD_GEM_PATH_1 = "/System/Library/Frameworks/Ruby.framework/Versions/1.8/usr/lib/ruby/gems/1.8/gems";
    private static final String LEOPARD_GEM_PATH_2 = "/Library/Ruby/Gems/1.8/gems";
    private IProgressMonitor fMonitor;

    public GemLoadpathVariablesInitializer() {
        RubyRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void initialize(final String variable) {
        if (!variable.equals("GEM_LIB")) {
            return;
        }
        IVMInstall vmInstall = RubyRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            return;
        }
        this.setQuickNDirtyPaths(variable, vmInstall);
        Job realJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IGemManager gemManager = AptanaRDTPlugin.getDefault().getGemManager();
                List<IPath> gemPaths = null;
                int tries = 3;
                while (tries > 0) {
                    gemPaths = gemManager.getGemInstallPaths();
                    if (gemPaths != null) break;
                    --tries;
                }
                if (gemPaths == null) {
                    gemPaths = this.loadCachedValue();
                } else {
                    this.saveValue(gemPaths);
                }
                if (gemPaths == null) {
                    return new Status(4, "com.aptana.rdt", -1, "Unable to retrieve gem install paths", null);
                }
                IPath[] paths = new IPath[gemPaths.size()];
                int i = 0;
                for (IPath path : gemPaths) {
                    paths[i++] = path.append("gems");
                }
                if (RubyRuntime.currentVMIsCygwin()) {
                    File home = RubyRuntime.getDefaultVMInstall().getInstallLocation();
                    int x = 0;
                    while (x < paths.length) {
                        String portablePath = paths[x].toOSString();
                        if (portablePath.startsWith("\\usr\\lib")) {
                            portablePath = portablePath.substring(4);
                        }
                        String cygwinConverted = String.valueOf(home.getAbsolutePath()) + portablePath;
                        Path path = new Path(cygwinConverted);
                        paths[x] = path;
                        ++x;
                    }
                }
                GemLoadpathVariablesInitializer.this.setVariable(variable, paths);
                return Status.OK_STATUS;
            }

            private void saveValue(List<IPath> gemPaths) {
                block16: {
                    File file = this.getCacheFile();
                    OutputStreamWriter writer = null;
                    try {
                        try {
                            if (!file.exists()) {
                                file.createNewFile();
                            }
                            writer = new FileWriter(file);
                            for (IPath gemPath : gemPaths) {
                                writer.write(String.valueOf(gemPath.toPortableString()) + "\n");
                            }
                        }
                        catch (IOException e) {
                            AptanaRDTPlugin.log(e);
                            try {
                                if (writer != null) {
                                    writer.close();
                                }
                                break block16;
                            }
                            catch (IOException iOException) {}
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }

            private File getCacheFile() {
                IPath path = AptanaRDTPlugin.getDefault().getStateLocation().append(String.valueOf(RubyRuntime.getDefaultVMInstall().getId()) + "_gem_install_paths.txt");
                return path.toFile();
            }

            private List<IPath> loadCachedValue() {
                ArrayList<IPath> paths = new ArrayList<IPath>();
                try {
                    String contents = new String(Util.getFileCharContent((File)this.getCacheFile(), null));
                    String[] rawPaths = contents.split("\n");
                    int i = 0;
                    while (i < rawPaths.length) {
                        paths.add(Path.fromPortableString((String)rawPaths[i]));
                        ++i;
                    }
                }
                catch (IOException e) {
                    AptanaRDTPlugin.log(e);
                }
                return paths;
            }
        };
        realJob.setSystem(true);
        realJob.setPriority(30);
        realJob.schedule();
    }

    private void setQuickNDirtyPaths(String variable, IVMInstall vmInstall) {
        File dir;
        if (Platform.getOS().equals("macosx") && !RubyRuntime.currentVMIsJRuby() && (dir = new File(LEOPARD_GEM_PATH_2)).exists()) {
            this.setVariable(variable, new IPath[]{new Path(LEOPARD_GEM_PATH_1), new Path(LEOPARD_GEM_PATH_2)});
            return;
        }
        IPath quickNDirty = new Path(vmInstall.getInstallLocation().getAbsolutePath()).append("lib").append("ruby").append("gems").append("1.8").append("gems");
        this.setVariable(variable, new IPath[]{quickNDirty});
    }

    private void setVariable(String variable, IPath[] newPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription wsDescription = workspace.getDescription();
        boolean wasAutobuild = wsDescription.isAutoBuilding();
        try {
            try {
                this.setAutobuild(workspace, false);
                this.setRubyVMVariable(newPath, variable);
            }
            catch (CoreException ce) {
                LaunchingPlugin.log((Throwable)ce);
                try {
                    this.setAutobuild(workspace, wasAutobuild);
                }
                catch (CoreException ce2) {
                    LaunchingPlugin.log((Throwable)ce2);
                }
                return;
            }
        }
        finally {
            try {
                this.setAutobuild(workspace, wasAutobuild);
            }
            catch (CoreException ce) {
                LaunchingPlugin.log((Throwable)ce);
            }
        }
    }

    private void setRubyVMVariable(IPath[] newPath, String var) throws CoreException {
        RubyCore.setLoadpathVariable((String)var, (IPath[])newPath, (IProgressMonitor)this.getMonitor());
    }

    private boolean setAutobuild(IWorkspace ws, boolean newState) throws CoreException {
        IWorkspaceDescription wsDescription = ws.getDescription();
        boolean oldState = wsDescription.isAutoBuilding();
        if (oldState != newState) {
            wsDescription.setAutoBuilding(newState);
            ws.setDescription(wsDescription);
        }
        return oldState;
    }

    protected IProgressMonitor getMonitor() {
        if (this.fMonitor == null) {
            return new NullProgressMonitor();
        }
        return this.fMonitor;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        this.initialize("GEM_LIB");
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmRemoved(IVMInstall removedVm) {
    }
}

